/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.bugtraq;

import com.syntevo.bugtraq.BugtraqException;
import com.syntevo.bugtraq.BugtraqParserIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BugtraqParser {
    private final Pattern idPattern;
    private final Pattern linkPattern;
    private final Pattern filterPattern;

    @NotNull
    public static BugtraqParser createInstance(@NotNull String idRegex, @Nullable String linkRegex, @Nullable String filterRegex) throws BugtraqException {
        try {
            return new BugtraqParser(idRegex, linkRegex, filterRegex);
        }
        catch (PatternSyntaxException ex) {
            throw new BugtraqException(ex);
        }
    }

    private BugtraqParser(@NotNull String idRegex, @Nullable String linkRegex, @Nullable String filterRegex) {
        this.idPattern = BugtraqParser.compilePatternSafe(idRegex);
        this.linkPattern = linkRegex != null ? BugtraqParser.compilePatternSafe(linkRegex) : null;
        this.filterPattern = filterRegex != null ? BugtraqParser.compilePatternSafe(filterRegex) : null;
    }

    @Nullable
    public List<BugtraqParserIssueId> parse(@NotNull String message) {
        List<Part> parts = new ArrayList<Part>();
        parts.add(new Part(message, 0, message.length() - 1));
        if (this.filterPattern != null) {
            parts = BugtraqParser.collectParts(parts, this.filterPattern);
        }
        if (this.linkPattern != null) {
            parts = BugtraqParser.collectParts(parts, this.linkPattern);
        }
        ArrayList<BugtraqParserIssueId> ids = new ArrayList<BugtraqParserIssueId>();
        for (Part part : parts) {
            Matcher matcher = this.idPattern.matcher(part.text);
            while (matcher.find()) {
                BugtraqParserIssueId id;
                Part subPart = BugtraqParser.createSubPart(part, matcher, matcher.groupCount() == 0 ? 0 : 1);
                if (subPart == null) continue;
                if (this.linkPattern == null) {
                    id = new BugtraqParserIssueId(subPart.from, subPart.to, subPart.text);
                } else {
                    if (matcher.find()) continue;
                    id = new BugtraqParserIssueId(part.from, part.to, subPart.text);
                }
                if (ids.size() > 0) {
                    BugtraqParserIssueId lastId = (BugtraqParserIssueId)ids.get(ids.size() - 1);
                    if (id.getFrom() <= lastId.getTo()) continue;
                }
                ids.add(id);
            }
        }
        return ids;
    }

    private static List<Part> collectParts(@NotNull List<Part> mainParts, @NotNull Pattern pattern) {
        ArrayList<Part> subParts = new ArrayList<Part>();
        for (Part part : mainParts) {
            Matcher matcher = pattern.matcher(part.text);
            while (matcher.find()) {
                Part newPart = BugtraqParser.createSubPart(part, matcher, matcher.groupCount() == 0 ? 0 : 1);
                if (newPart == null) continue;
                subParts.add(newPart);
            }
        }
        return subParts;
    }

    @Nullable
    private static Part createSubPart(Part part, Matcher matcher, int group) {
        int textStart = matcher.start(group) + part.from;
        int textEnd = matcher.end(group) - 1 + part.from;
        if (textEnd < 0) {
            return null;
        }
        return new Part(matcher.group(group), textStart, textEnd);
    }

    private static Pattern compilePatternSafe(String pattern) throws PatternSyntaxException {
        return Pattern.compile(pattern);
    }

    private static class Part {
        private final int from;
        private final int to;
        private final String text;

        public Part(String text, int from, int to) {
            this.text = text;
            this.from = from;
            this.to = to;
        }
    }
}

