/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.models.RefModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class AddIndexedBranch {
    public static void main(String ... args) {
        Params params = new Params();
        CmdLineParser parser = new CmdLineParser((Object)params);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException t) {
            System.err.println(t.getMessage());
            parser.printUsage((OutputStream)System.out);
            return;
        }
        TreeSet<String> exclusions = new TreeSet<String>();
        for (String exclude : params.exclusions) {
            exclusions.add(exclude.toLowerCase());
        }
        File folder = new File(params.folder);
        List<String> repoList = JGitUtils.getRepositoryList(folder, false, true, -1, null);
        int modCount = 0;
        int skipCount = 0;
        for (String repo : repoList) {
            boolean skip = false;
            for (String exclusion : exclusions) {
                if (!StringUtils.fuzzyMatch(repo, exclusion)) continue;
                skip = true;
                break;
            }
            if (skip) {
                System.out.println("skipping " + repo);
                ++skipCount;
                continue;
            }
            try {
                File gitDir = RepositoryCache.FileKey.resolve((File)new File(folder, repo), (FS)FS.DETECTED);
                Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).build();
                StoredConfig config = repository.getConfig();
                config.load();
                LinkedHashSet<Object> indexedBranches = new LinkedHashSet<Object>();
                if (params.addAllLocalBranches) {
                    List<RefModel> list = JGitUtils.getLocalBranches(repository, true, -1);
                    for (RefModel refModel : list) {
                        System.out.println(MessageFormat.format("adding [gitblit] indexBranch={0} for {1}", refModel.getName(), repo));
                        indexedBranches.add(refModel.getName());
                    }
                } else {
                    System.out.println(MessageFormat.format("adding [gitblit] indexBranch={0} for {1}", params.branch, repo));
                    indexedBranches.add(params.branch);
                }
                Object[] branches = config.getStringList("gitblit", null, "indexBranch");
                if (!ArrayUtils.isEmpty(branches)) {
                    for (Object branch : branches) {
                        indexedBranches.add(branch);
                    }
                }
                config.setStringList("gitblit", null, "indexBranch", new ArrayList(indexedBranches));
                config.save();
                ++modCount;
            }
            catch (Exception e) {
                System.err.println(repo);
                e.printStackTrace();
            }
        }
        System.out.println(MessageFormat.format("updated {0} repository configurations, skipped {1}", modCount, skipCount));
    }

    private static class Params {
        @Option(name="--repositoriesFolder", usage="The root repositories folder ", required=true, metaVar="PATH")
        public String folder;
        @Option(name="--branch", usage="The branch to index", metaVar="BRANCH")
        public String branch = "default";
        @Option(name="--skip", usage="Skip the named repository (simple fizzy matching is supported)")
        public List<String> exclusions = new ArrayList<String>();
        @Option(name="--all-local-branches", usage="Add all local branches to index. If specified, the --branch parameter is not considered.")
        public boolean addAllLocalBranches;

        private Params() {
        }
    }
}

