/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.Constants;
import com.gitblit.IUserService;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.models.UserRepositoryPreferences;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUserService
implements IUserService {
    private static final String TEAM = "team";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String DISPLAYNAME = "displayName";
    private static final String EMAILADDRESS = "emailAddress";
    private static final String ORGANIZATIONALUNIT = "organizationalUnit";
    private static final String ORGANIZATION = "organization";
    private static final String LOCALITY = "locality";
    private static final String STATEPROVINCE = "stateProvince";
    private static final String COUNTRYCODE = "countryCode";
    private static final String COOKIE = "cookie";
    private static final String REPOSITORY = "repository";
    private static final String ROLE = "role";
    private static final String MAILINGLIST = "mailingList";
    private static final String PRERECEIVE = "preReceiveScript";
    private static final String POSTRECEIVE = "postReceiveScript";
    private static final String STARRED = "starred";
    private static final String LOCALE = "locale";
    private static final String EMAILONMYTICKETCHANGES = "emailMeOnMyTicketChanges";
    private static final String TRANSPORT = "transport";
    private static final String ACCOUNTTYPE = "accountType";
    private static final String DISABLED = "disabled";
    private final File realmFile;
    private final Logger logger = LoggerFactory.getLogger(ConfigUserService.class);
    private final Map<String, UserModel> users = new ConcurrentHashMap<String, UserModel>();
    private final Map<String, UserModel> cookies = new ConcurrentHashMap<String, UserModel>();
    private final Map<String, TeamModel> teams = new ConcurrentHashMap<String, TeamModel>();
    private volatile long lastModified;
    private volatile boolean forceReload;

    public ConfigUserService(File realmFile) {
        this.realmFile = realmFile;
    }

    @Override
    public void setup(IRuntimeManager runtimeManager) {
    }

    @Override
    public synchronized String getCookie(UserModel model) {
        if (!StringUtils.isEmpty(model.cookie)) {
            return model.cookie;
        }
        UserModel storedModel = this.getUserModel(model.username);
        if (storedModel == null) {
            return null;
        }
        return storedModel.cookie;
    }

    @Override
    public synchronized UserModel getUserModel(char[] cookie) {
        String hash = new String(cookie);
        if (StringUtils.isEmpty(hash)) {
            return null;
        }
        this.read();
        UserModel model = null;
        if (this.cookies.containsKey(hash)) {
            model = this.cookies.get(hash);
        }
        if (model != null) {
            model = DeepCopier.copy(model);
        }
        return model;
    }

    @Override
    public synchronized UserModel getUserModel(String username) {
        this.read();
        UserModel model = this.users.get(username.toLowerCase());
        if (model != null) {
            model = DeepCopier.copy(model);
        }
        return model;
    }

    @Override
    public synchronized boolean updateUserModel(UserModel model) {
        return this.updateUserModel(model.username, model);
    }

    @Override
    public synchronized boolean updateUserModels(Collection<UserModel> models) {
        try {
            this.read();
            for (UserModel model : models) {
                UserModel originalUser = this.users.remove(model.username.toLowerCase());
                this.users.put(model.username.toLowerCase(), model);
                if (model.teams == null) continue;
                HashSet<TeamModel> userTeams = new HashSet<TeamModel>();
                for (TeamModel team : model.teams) {
                    TeamModel t = this.teams.get(team.name.toLowerCase());
                    if (t == null) {
                        t = team;
                        this.teams.put(team.name.toLowerCase(), t);
                    }
                    t.addUser(model.username);
                    userTeams.add(t);
                }
                model.teams.clear();
                model.teams.addAll(userTeams);
                if (originalUser == null) continue;
                for (TeamModel team : originalUser.teams) {
                    if (model.isTeamMember(team.name)) continue;
                    team.removeUser(model.username);
                }
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update user {0} models!", models.size()), t);
            return false;
        }
    }

    @Override
    public synchronized boolean updateUserModel(String username, UserModel model) {
        UserModel originalUser = null;
        try {
            if (!model.isLocalAccount()) {
                model.password = "#externalAccount";
            }
            this.read();
            originalUser = this.users.remove(username.toLowerCase());
            if (originalUser != null) {
                this.cookies.remove(originalUser.cookie);
            }
            this.users.put(model.username.toLowerCase(), model);
            if (model.teams != null) {
                for (TeamModel team : model.teams) {
                    TeamModel t = this.teams.get(team.name.toLowerCase());
                    if (t == null) {
                        team.addUser(username);
                        this.teams.put(team.name.toLowerCase(), team);
                        continue;
                    }
                    t.removeUser(username);
                    t.addUser(model.username);
                }
                if (originalUser != null) {
                    for (TeamModel team : originalUser.teams) {
                        if (model.isTeamMember(team.name)) continue;
                        team.removeUser(username);
                    }
                }
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            if (originalUser != null) {
                this.users.put(originalUser.username.toLowerCase(), originalUser);
            } else {
                this.users.remove(model.username.toLowerCase());
            }
            this.logger.error(MessageFormat.format("Failed to update user model {0}!", model.username), t);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteUserModel(UserModel model) {
        return this.deleteUser(model.username);
    }

    @Override
    public synchronized boolean deleteUser(String username) {
        try {
            this.read();
            UserModel model = this.users.remove(username.toLowerCase());
            if (model == null) {
                return false;
            }
            for (TeamModel team : model.teams) {
                TeamModel t = this.teams.get(team.name);
                if (t == null) {
                    team.removeUser(username);
                    this.teams.put(team.name.toLowerCase(), team);
                    continue;
                }
                t.removeUser(username);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete user {0}!", username), t);
            return false;
        }
    }

    @Override
    public synchronized List<String> getAllTeamNames() {
        this.read();
        ArrayList<String> list = new ArrayList<String>(this.teams.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized List<TeamModel> getAllTeams() {
        this.read();
        List<TeamModel> list = new ArrayList<TeamModel>(this.teams.values());
        list = DeepCopier.copy(list);
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized List<String> getTeamNamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.read();
            for (Map.Entry<String, TeamModel> entry : this.teams.entrySet()) {
                TeamModel model = entry.getValue();
                if (!model.hasRepositoryPermission(role)) continue;
                list.add(model.name);
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get teamnames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized TeamModel getTeamModel(String teamname) {
        this.read();
        TeamModel model = this.teams.get(teamname.toLowerCase());
        if (model != null) {
            model = DeepCopier.copy(model);
        }
        return model;
    }

    @Override
    public synchronized boolean updateTeamModel(TeamModel model) {
        return this.updateTeamModel(model.name, model);
    }

    @Override
    public synchronized boolean updateTeamModels(Collection<TeamModel> models) {
        try {
            this.read();
            for (TeamModel team : models) {
                this.teams.put(team.name.toLowerCase(), team);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to update team {0} models!", models.size()), t);
            return false;
        }
    }

    @Override
    public synchronized boolean updateTeamModel(String teamname, TeamModel model) {
        TeamModel original = null;
        try {
            this.read();
            original = this.teams.remove(teamname.toLowerCase());
            this.teams.put(model.name.toLowerCase(), model);
            this.write();
            return true;
        }
        catch (Throwable t) {
            if (original != null) {
                this.teams.put(original.name.toLowerCase(), original);
            } else {
                this.teams.remove(model.name.toLowerCase());
            }
            this.logger.error(MessageFormat.format("Failed to update team model {0}!", model.name), t);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteTeamModel(TeamModel model) {
        return this.deleteTeam(model.name);
    }

    @Override
    public synchronized boolean deleteTeam(String teamname) {
        try {
            this.read();
            this.teams.remove(teamname.toLowerCase());
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete team {0}!", teamname), t);
            return false;
        }
    }

    @Override
    public synchronized List<String> getAllUsernames() {
        this.read();
        ArrayList<String> list = new ArrayList<String>(this.users.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized List<UserModel> getAllUsers() {
        this.read();
        List<UserModel> list = new ArrayList<UserModel>(this.users.values());
        list = DeepCopier.copy(list);
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized List<String> getUsernamesForRepositoryRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.read();
            for (Map.Entry<String, UserModel> entry : this.users.entrySet()) {
                UserModel model = entry.getValue();
                if (!model.hasRepositoryPermission(role)) continue;
                list.add(model.username);
            }
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to get usernames for role {0}!", role), t);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public synchronized boolean renameRepositoryRole(String oldRole, String newRole) {
        try {
            Constants.AccessPermission permission;
            this.read();
            for (UserModel userModel : this.users.values()) {
                if (!userModel.hasRepositoryPermission(oldRole)) continue;
                permission = userModel.removeRepositoryPermission(oldRole);
                userModel.setRepositoryPermission(newRole, permission);
            }
            for (TeamModel teamModel : this.teams.values()) {
                if (!teamModel.hasRepositoryPermission(oldRole)) continue;
                permission = teamModel.removeRepositoryPermission(oldRole);
                teamModel.setRepositoryPermission(newRole, permission);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to rename role {0} to {1}!", oldRole, newRole), t);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRepositoryRole(String role) {
        try {
            this.read();
            for (UserModel user : this.users.values()) {
                user.removeRepositoryPermission(role);
            }
            for (TeamModel team : this.teams.values()) {
                team.removeRepositoryPermission(role);
            }
            this.write();
            return true;
        }
        catch (Throwable t) {
            this.logger.error(MessageFormat.format("Failed to delete role {0}!", role), t);
            return false;
        }
    }

    private synchronized void write() throws IOException {
        ArrayList<String> permissions;
        ArrayList<String> roles;
        File realmFileCopy = new File(this.realmFile.getAbsolutePath() + ".tmp");
        FileBasedConfig config = new FileBasedConfig(realmFileCopy, FS.detect());
        for (UserModel userModel : this.users.values()) {
            List<String> starred;
            if (!StringUtils.isEmpty(userModel.password)) {
                config.setString(USER, userModel.username, PASSWORD, userModel.password);
            }
            if (!StringUtils.isEmpty(userModel.cookie)) {
                config.setString(USER, userModel.username, COOKIE, userModel.cookie);
            }
            if (!StringUtils.isEmpty(userModel.displayName)) {
                config.setString(USER, userModel.username, DISPLAYNAME, userModel.displayName);
            }
            if (!StringUtils.isEmpty(userModel.emailAddress)) {
                config.setString(USER, userModel.username, EMAILADDRESS, userModel.emailAddress);
            }
            if (userModel.accountType != null) {
                config.setString(USER, userModel.username, ACCOUNTTYPE, userModel.accountType.name());
            }
            if (!StringUtils.isEmpty(userModel.organizationalUnit)) {
                config.setString(USER, userModel.username, ORGANIZATIONALUNIT, userModel.organizationalUnit);
            }
            if (!StringUtils.isEmpty(userModel.organization)) {
                config.setString(USER, userModel.username, ORGANIZATION, userModel.organization);
            }
            if (!StringUtils.isEmpty(userModel.locality)) {
                config.setString(USER, userModel.username, LOCALITY, userModel.locality);
            }
            if (!StringUtils.isEmpty(userModel.stateProvince)) {
                config.setString(USER, userModel.username, STATEPROVINCE, userModel.stateProvince);
            }
            if (!StringUtils.isEmpty(userModel.countryCode)) {
                config.setString(USER, userModel.username, COUNTRYCODE, userModel.countryCode);
            }
            if (userModel.disabled) {
                config.setBoolean(USER, userModel.username, DISABLED, true);
            }
            if (userModel.getPreferences() != null) {
                Locale locale = userModel.getPreferences().getLocale();
                if (locale != null) {
                    String val = StringUtils.isEmpty(locale.getCountry()) ? locale.getLanguage() : locale.getLanguage() + "_" + locale.getCountry();
                    config.setString(USER, userModel.username, LOCALE, val);
                }
                config.setBoolean(USER, userModel.username, EMAILONMYTICKETCHANGES, userModel.getPreferences().isEmailMeOnMyTicketChanges());
                if (userModel.getPreferences().getTransport() != null) {
                    config.setString(USER, userModel.username, TRANSPORT, userModel.getPreferences().getTransport().name());
                }
            }
            roles = new ArrayList();
            if (userModel.canAdmin) {
                roles.add(Constants.Role.ADMIN.getRole());
            }
            if (userModel.canFork) {
                roles.add(Constants.Role.FORK.getRole());
            }
            if (userModel.canCreate) {
                roles.add(Constants.Role.CREATE.getRole());
            }
            if (userModel.excludeFromFederation) {
                roles.add(Constants.Role.NOT_FEDERATED.getRole());
            }
            if (roles.size() == 0) {
                roles.add(Constants.Role.NONE.getRole());
            }
            config.setStringList(USER, userModel.username, ROLE, roles);
            if (userModel.permissions != null && !userModel.canAdmin) {
                permissions = new ArrayList();
                for (Map.Entry<String, Constants.AccessPermission> entry : userModel.permissions.entrySet()) {
                    if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                    permissions.add(entry.getValue().asRole(entry.getKey()));
                }
                config.setStringList(USER, userModel.username, REPOSITORY, permissions);
            }
            if (userModel.getPreferences() == null || (starred = userModel.getPreferences().getStarredRepositories()).size() <= 0) continue;
            config.setStringList(USER, userModel.username, STARRED, starred);
        }
        for (TeamModel teamModel : this.teams.values()) {
            roles = new ArrayList<String>();
            if (teamModel.canAdmin) {
                roles.add(Constants.Role.ADMIN.getRole());
            }
            if (teamModel.canFork) {
                roles.add(Constants.Role.FORK.getRole());
            }
            if (teamModel.canCreate) {
                roles.add(Constants.Role.CREATE.getRole());
            }
            if (roles.size() == 0) {
                roles.add(Constants.Role.NONE.getRole());
            }
            config.setStringList(TEAM, teamModel.name, ROLE, roles);
            if (teamModel.accountType != null) {
                config.setString(TEAM, teamModel.name, ACCOUNTTYPE, teamModel.accountType.name());
            }
            if (!teamModel.canAdmin) {
                if (teamModel.permissions == null) {
                    if (!ArrayUtils.isEmpty(teamModel.repositories)) {
                        config.setStringList(TEAM, teamModel.name, REPOSITORY, new ArrayList<String>(teamModel.repositories));
                    }
                } else {
                    permissions = new ArrayList<String>();
                    for (Map.Entry<String, Constants.AccessPermission> entry : teamModel.permissions.entrySet()) {
                        if (!entry.getValue().exceeds(Constants.AccessPermission.NONE)) continue;
                        permissions.add(entry.getValue().asRole(entry.getKey()));
                    }
                    config.setStringList(TEAM, teamModel.name, REPOSITORY, permissions);
                }
            }
            if (!ArrayUtils.isEmpty(teamModel.users)) {
                config.setStringList(TEAM, teamModel.name, USER, new ArrayList<String>(teamModel.users));
            }
            if (!ArrayUtils.isEmpty(teamModel.mailingLists)) {
                config.setStringList(TEAM, teamModel.name, MAILINGLIST, new ArrayList<String>(teamModel.mailingLists));
            }
            if (!ArrayUtils.isEmpty(teamModel.preReceiveScripts)) {
                config.setStringList(TEAM, teamModel.name, PRERECEIVE, teamModel.preReceiveScripts);
            }
            if (ArrayUtils.isEmpty(teamModel.postReceiveScripts)) continue;
            config.setStringList(TEAM, teamModel.name, POSTRECEIVE, teamModel.postReceiveScripts);
        }
        config.save();
        this.forceReload = true;
        if (realmFileCopy.exists() && realmFileCopy.length() > 0L) {
            if (this.realmFile.exists() && !this.realmFile.delete()) {
                throw new IOException(MessageFormat.format("Failed to delete {0}!", this.realmFile.getAbsolutePath()));
            }
            if (!realmFileCopy.renameTo(this.realmFile)) {
                throw new IOException(MessageFormat.format("Failed to rename {0} to {1}!", realmFileCopy.getAbsolutePath(), this.realmFile.getAbsolutePath()));
            }
        } else {
            throw new IOException(MessageFormat.format("Failed to save {0}!", realmFileCopy.getAbsolutePath()));
        }
    }

    protected synchronized void read() {
        if (this.realmFile.exists() && (this.forceReload || this.realmFile.lastModified() != this.lastModified)) {
            this.forceReload = false;
            this.lastModified = this.realmFile.lastModified();
            this.users.clear();
            this.cookies.clear();
            this.teams.clear();
            try {
                FileBasedConfig config = new FileBasedConfig(this.realmFile, FS.detect());
                config.load();
                Set usernames = config.getSubsections(USER);
                for (String username : usernames) {
                    UserModel user = new UserModel(username.toLowerCase());
                    user.password = config.getString(USER, username, PASSWORD);
                    user.displayName = config.getString(USER, username, DISPLAYNAME);
                    user.emailAddress = config.getString(USER, username, EMAILADDRESS);
                    user.accountType = Constants.AccountType.fromString(config.getString(USER, username, ACCOUNTTYPE));
                    user.disabled = config.getBoolean(USER, username, DISABLED, false);
                    user.organizationalUnit = config.getString(USER, username, ORGANIZATIONALUNIT);
                    user.organization = config.getString(USER, username, ORGANIZATION);
                    user.locality = config.getString(USER, username, LOCALITY);
                    user.stateProvince = config.getString(USER, username, STATEPROVINCE);
                    user.countryCode = config.getString(USER, username, COUNTRYCODE);
                    user.cookie = config.getString(USER, username, COOKIE);
                    if (StringUtils.isEmpty(user.cookie) && !StringUtils.isEmpty(user.password)) {
                        user.cookie = user.createCookie();
                    }
                    user.getPreferences().setLocale(config.getString(USER, username, LOCALE));
                    user.getPreferences().setEmailMeOnMyTicketChanges(config.getBoolean(USER, username, EMAILONMYTICKETCHANGES, true));
                    user.getPreferences().setTransport(Constants.Transport.fromString(config.getString(USER, username, TRANSPORT)));
                    HashSet<String> roles = new HashSet<String>(Arrays.asList(config.getStringList(USER, username, ROLE)));
                    user.canAdmin = roles.contains(Constants.Role.ADMIN.getRole());
                    user.canFork = roles.contains(Constants.Role.FORK.getRole());
                    user.canCreate = roles.contains(Constants.Role.CREATE.getRole());
                    user.excludeFromFederation = roles.contains(Constants.Role.NOT_FEDERATED.getRole());
                    if (!user.canAdmin) {
                        HashSet<String> repositories = new HashSet<String>(Arrays.asList(config.getStringList(USER, username, REPOSITORY)));
                        for (String repository : repositories) {
                            user.addRepositoryPermission(repository);
                        }
                    }
                    HashSet<String> starred = new HashSet<String>(Arrays.asList(config.getStringList(USER, username, STARRED)));
                    for (String repository : starred) {
                        UserRepositoryPreferences prefs = user.getPreferences().getRepositoryPreferences(repository);
                        prefs.starred = true;
                    }
                    this.users.put(user.username, user);
                    if (StringUtils.isEmpty(user.cookie)) continue;
                    this.cookies.put(user.cookie, user);
                }
                Set teamnames = config.getSubsections(TEAM);
                for (String teamname : teamnames) {
                    TeamModel team = new TeamModel(teamname);
                    HashSet<String> roles = new HashSet<String>(Arrays.asList(config.getStringList(TEAM, teamname, ROLE)));
                    team.canAdmin = roles.contains(Constants.Role.ADMIN.getRole());
                    team.canFork = roles.contains(Constants.Role.FORK.getRole());
                    team.canCreate = roles.contains(Constants.Role.CREATE.getRole());
                    team.accountType = Constants.AccountType.fromString(config.getString(TEAM, teamname, ACCOUNTTYPE));
                    if (!team.canAdmin) {
                        team.addRepositoryPermissions(Arrays.asList(config.getStringList(TEAM, teamname, REPOSITORY)));
                    }
                    team.addUsers(Arrays.asList(config.getStringList(TEAM, teamname, USER)));
                    team.addMailingLists(Arrays.asList(config.getStringList(TEAM, teamname, MAILINGLIST)));
                    team.preReceiveScripts.addAll(Arrays.asList(config.getStringList(TEAM, teamname, PRERECEIVE)));
                    team.postReceiveScripts.addAll(Arrays.asList(config.getStringList(TEAM, teamname, POSTRECEIVE)));
                    this.teams.put(team.name.toLowerCase(), team);
                    for (String user : team.users) {
                        UserModel model = this.users.get(user);
                        if (model == null) continue;
                        model.teams.add(team);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Failed to read {0}", this.realmFile), (Throwable)e);
            }
        }
    }

    protected long lastModified() {
        return this.lastModified;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.realmFile.getAbsolutePath() + ")";
    }
}

