/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit;

import com.gitblit.IStoredSettings;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;

public class WebXmlSettings
extends IStoredSettings {
    private final Properties properties = new Properties();
    private File overrideFile;

    public WebXmlSettings(ServletContext context) {
        super(WebXmlSettings.class);
        Enumeration keys = context.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = context.getInitParameter(key);
            this.properties.put(key, this.decodeValue(value));
            this.logger.debug(key + "=" + this.properties.getProperty(key));
        }
    }

    public void applyOverrides(File overrideFile) {
        this.overrideFile = overrideFile;
        if (overrideFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(overrideFile);
                this.properties.load(is);
                ((InputStream)is).close();
            }
            catch (Throwable t) {
                this.logger.error(MessageFormat.format("Failed to apply {0} setting overrides", overrideFile.getAbsolutePath()), t);
            }
        }
    }

    private String decodeValue(String value) {
        return StringUtils.decodeFromHtml(value).replace("\\\\", "\\");
    }

    @Override
    protected Properties read() {
        return this.properties;
    }

    @Override
    public synchronized boolean saveSettings() {
        try {
            Properties props = new Properties();
            if (this.overrideFile.exists()) {
                FileInputStream is = new FileInputStream(this.overrideFile);
                props.load(is);
                ((InputStream)is).close();
            }
            for (String key : this.removals) {
                props.remove(key);
            }
            this.removals.clear();
            FileOutputStream os = new FileOutputStream(this.overrideFile);
            props.store(os, null);
            ((OutputStream)os).close();
            this.properties.clear();
            this.properties.putAll((Map<?, ?>)props);
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Failed to save settings!", t);
            return false;
        }
    }

    @Override
    public synchronized boolean saveSettings(Map<String, String> settings) {
        try {
            Properties props = new Properties();
            if (this.overrideFile.exists()) {
                FileInputStream is = new FileInputStream(this.overrideFile);
                props.load(is);
                ((InputStream)is).close();
            }
            props.putAll(settings);
            FileOutputStream os = new FileOutputStream(this.overrideFile);
            props.store(os, null);
            ((OutputStream)os).close();
            this.properties.putAll(settings);
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Failed to save settings!", t);
            return false;
        }
    }

    public String toString() {
        return "WEB.XML";
    }
}

