/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;

public class HtpasswdAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    private static final String KEY_HTPASSWD_FILE = "realm.htpasswd.userfile";
    private static final String DEFAULT_HTPASSWD_FILE = "${baseFolder}/htpasswd";
    private static final String KEY_SUPPORT_PLAINTEXT_PWD = "realm.htpasswd.supportPlaintextPasswords";
    private boolean supportPlainTextPwd;
    private File htpasswdFile;
    private final Map<String, String> htUsers = new ConcurrentHashMap<String, String>();
    private volatile long lastModified;

    public HtpasswdAuthProvider() {
        super("htpasswd");
    }

    @Override
    public void setup() {
        String os = System.getProperty("os.name").toLowerCase();
        this.supportPlainTextPwd = os.startsWith("windows") || os.startsWith("netware");
        this.read();
        this.logger.debug("Read " + this.htUsers.size() + " users from htpasswd file: " + this.htpasswdFile);
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return true;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return true;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        this.read();
        String storedPwd = this.htUsers.get(username);
        if (storedPwd != null) {
            boolean authenticated = false;
            String passwd = new String(password);
            if (storedPwd.startsWith("$apr1$")) {
                if (storedPwd.equals(Md5Crypt.apr1Crypt((String)passwd, (String)storedPwd))) {
                    this.logger.debug("Apache MD5 encoded password matched for user '" + username + "'");
                    authenticated = true;
                }
            } else if (storedPwd.startsWith("{SHA}")) {
                String passwd64 = Base64.encodeBase64String((byte[])DigestUtils.sha1((String)passwd));
                if (storedPwd.substring("{SHA}".length()).equals(passwd64)) {
                    this.logger.debug("Unsalted SHA-1 encoded password matched for user '" + username + "'");
                    authenticated = true;
                }
            } else if (this.supportCryptPwd() && storedPwd.equals(Crypt.crypt((String)passwd, (String)storedPwd))) {
                this.logger.debug("Libc crypt encoded password matched for user '" + username + "'");
                authenticated = true;
            } else if (this.supportPlaintextPwd() && storedPwd.equals(passwd)) {
                this.logger.debug("Clear text password matched for user '" + username + "'");
                authenticated = true;
            }
            if (authenticated) {
                this.logger.debug("Htpasswd authenticated: " + username);
                UserModel curr = this.userManager.getUserModel(username);
                UserModel user = curr == null ? new UserModel(username) : curr;
                this.setCookie(user);
                user.password = "#externalAccount";
                user.accountType = this.getAccountType();
                this.updateUser(user);
                return user;
            }
        }
        return null;
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.HTPASSWD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void read() {
        boolean forceReload = false;
        File file = this.getFileOrFolder(KEY_HTPASSWD_FILE, DEFAULT_HTPASSWD_FILE);
        if (!file.equals(this.htpasswdFile)) {
            this.htpasswdFile = file;
            this.htUsers.clear();
            forceReload = true;
        }
        if (this.htpasswdFile.exists() && (forceReload || this.htpasswdFile.lastModified() != this.lastModified)) {
            this.lastModified = this.htpasswdFile.lastModified();
            this.htUsers.clear();
            Pattern entry = Pattern.compile("^([^:]+):(.+)");
            try (Scanner scanner = null;){
                scanner = new Scanner(new FileInputStream(this.htpasswdFile));
                while (scanner.hasNextLine()) {
                    Matcher m;
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty() || line.startsWith("#") || !(m = entry.matcher(line)).matches()) continue;
                    this.htUsers.put(m.group(1), m.group(2));
                }
            }
        }
    }

    private boolean supportPlaintextPwd() {
        return this.settings.getBoolean(KEY_SUPPORT_PLAINTEXT_PWD, this.supportPlainTextPwd);
    }

    private boolean supportCryptPwd() {
        return !this.supportPlaintextPwd();
    }

    public int getNumberHtpasswdUsers() {
        return this.htUsers.size();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.htpasswdFile != null ? this.htpasswdFile.getAbsolutePath() : "null") + ")";
    }
}

