/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.ldap.LdapConnection;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.service.LdapSyncService;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LdapAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public LdapAuthProvider() {
        super("ldap");
    }

    private long getSynchronizationPeriodInMilliseconds() {
        String period = this.settings.getString("realm.ldap.syncPeriod", null);
        if (StringUtils.isEmpty(period)) {
            period = this.settings.getString("realm.ldap.ldapCachePeriod", null);
            if (StringUtils.isEmpty(period)) {
                period = "5 MINUTES";
            } else {
                this.logger.warn("realm.ldap.ldapCachePeriod is obsolete!");
                this.logger.warn(MessageFormat.format("Please set {0}={1} in gitblit.properties!", "realm.ldap.syncPeriod", period));
                this.settings.overrideSetting("realm.ldap.syncPeriod", period);
            }
        }
        try {
            String[] s = period.split(" ", 2);
            long duration = Math.abs(Long.parseLong(s[0]));
            TimeUnit timeUnit = TimeUnit.valueOf(s[1]);
            return timeUnit.toMillis(duration);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("realm.ldap.syncPeriod must have format '<long> <TimeUnit>' where <TimeUnit> is one of 'MILLISECONDS', 'SECONDS', 'MINUTES', 'HOURS', 'DAYS'");
        }
    }

    @Override
    public void setup() {
        this.configureSyncService();
    }

    @Override
    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sync() {
        boolean enabled = this.settings.getBoolean("realm.ldap.synchronize", false);
        if (enabled) {
            this.logger.info("Synchronizing with LDAP @ " + this.settings.getRequiredString("realm.ldap.server"));
            boolean deleteRemovedLdapUsers = this.settings.getBoolean("realm.ldap.removeDeletedUsers", true);
            LdapConnection ldapConnection = new LdapConnection(this.settings);
            if (ldapConnection.connect()) {
                if (ldapConnection.bind() == null) {
                    ldapConnection.close();
                    this.logger.error("Cannot synchronize with LDAP.");
                    return;
                }
                try {
                    String uidAttribute = this.settings.getString("realm.ldap.uid", "uid");
                    String accountBase = ldapConnection.getAccountBase();
                    String accountPattern = ldapConnection.getAccountPattern();
                    accountPattern = StringUtils.replace(accountPattern, "${username}", "*");
                    SearchResult result = this.doSearch(ldapConnection, accountBase, accountPattern);
                    if (result != null && result.getEntryCount() > 0) {
                        HashMap<String, UserModel> ldapUsers = new HashMap<String, UserModel>();
                        for (SearchResultEntry loggingInUser : result.getSearchEntries()) {
                            Attribute uid = loggingInUser.getAttribute(uidAttribute);
                            if (uid == null) {
                                this.logger.error("Can not synchronize with LDAP, missing \"{}\" attribute", (Object)uidAttribute);
                                continue;
                            }
                            String username = uid.getValue();
                            this.logger.debug("LDAP synchronizing: " + username);
                            UserModel user = this.userManager.getUserModel(username);
                            if (user == null) {
                                user = new UserModel(username);
                            }
                            if (!this.supportsTeamMembershipChanges()) {
                                this.getTeamsFromLdap(ldapConnection, username, loggingInUser, user);
                            }
                            this.setUserAttributes(user, loggingInUser);
                            ldapUsers.put(username.toLowerCase(), user);
                        }
                        if (deleteRemovedLdapUsers) {
                            this.logger.debug("detecting removed LDAP users...");
                            for (UserModel userModel : this.userManager.getAllUsers()) {
                                if (Constants.AccountType.LDAP != userModel.accountType || ldapUsers.containsKey(userModel.username)) continue;
                                this.logger.info("deleting removed LDAP user " + userModel.username + " from user service");
                                this.userManager.deleteUser(userModel.username);
                            }
                        }
                        this.userManager.updateUserModels(ldapUsers.values());
                        if (!this.supportsTeamMembershipChanges()) {
                            HashMap<String, TeamModel> userTeams = new HashMap<String, TeamModel>();
                            for (UserModel user : ldapUsers.values()) {
                                for (TeamModel userTeam : user.teams) {
                                    this.setAdminAttribute(userTeam);
                                    userTeams.put(userTeam.name, userTeam);
                                }
                            }
                            this.userManager.updateTeamModels(userTeams.values());
                        }
                    }
                    if (!this.supportsTeamMembershipChanges()) {
                        this.getEmptyTeamsFromLdap(ldapConnection);
                    }
                }
                finally {
                    ldapConnection.close();
                }
            }
        }
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return StringUtils.isEmpty(this.settings.getString("realm.ldap.displayName", ""));
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return StringUtils.isEmpty(this.settings.getString("realm.ldap.email", ""));
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return !this.settings.getBoolean("realm.ldap.maintainTeams", false);
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return Constants.Role.ADMIN != role || this.supportsTeamMembershipChanges();
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return Constants.Role.ADMIN != role || this.supportsTeamMembershipChanges();
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.LDAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserModel authenticate(String username, char[] password) {
        block12: {
            String simpleUsername = this.getSimpleUsername(username);
            LdapConnection ldapConnection = new LdapConnection(this.settings);
            if (ldapConnection.connect()) {
                String passwd = new String(password);
                BindResult bindResult = null;
                String bindPattern = this.settings.getString("realm.ldap.bindpattern", "");
                bindResult = !StringUtils.isEmpty(bindPattern) ? ldapConnection.bind(bindPattern, simpleUsername, passwd) : ldapConnection.bind();
                if (bindResult == null) {
                    ldapConnection.close();
                    return null;
                }
                try {
                    SearchResultEntry loggingInUser;
                    String loggingInUserDN;
                    SearchResult result = ldapConnection.searchUser(simpleUsername);
                    if (result == null || result.getEntryCount() != 1 || !ldapConnection.isAuthenticated(loggingInUserDN = (loggingInUser = (SearchResultEntry)result.getSearchEntries().get(0)).getDN(), passwd)) break block12;
                    this.logger.debug("LDAP authenticated: " + username);
                    UserModel user = null;
                    Object object = this;
                    synchronized (object) {
                        user = this.userManager.getUserModel(simpleUsername);
                        if (user == null) {
                            user = new UserModel(simpleUsername);
                        }
                        this.setCookie(user);
                        if (!this.supportsTeamMembershipChanges()) {
                            this.getTeamsFromLdap(ldapConnection, simpleUsername, loggingInUser, user);
                        }
                        this.setUserAttributes(user, loggingInUser);
                        this.updateUser(user);
                        if (!this.supportsTeamMembershipChanges()) {
                            for (TeamModel userTeam : user.teams) {
                                this.setAdminAttribute(userTeam);
                                this.updateTeam(userTeam);
                            }
                        }
                    }
                    object = user;
                    return object;
                }
                finally {
                    ldapConnection.close();
                }
            }
        }
        return null;
    }

    private void setAdminAttribute(UserModel user) {
        List<String> admins;
        if (!this.supportsTeamMembershipChanges() && !ArrayUtils.isEmpty(admins = this.settings.getStrings("realm.ldap.admins"))) {
            user.canAdmin = false;
            for (String admin : admins) {
                if (!user.getName().equalsIgnoreCase(admin)) continue;
                user.canAdmin = true;
            }
        }
    }

    private void setAdminAttribute(TeamModel team) {
        List<String> admins;
        if (!this.supportsTeamMembershipChanges() && !ArrayUtils.isEmpty(admins = this.settings.getStrings("realm.ldap.admins"))) {
            team.canAdmin = false;
            for (String admin : admins) {
                if (!admin.startsWith("@") || !team.name.equalsIgnoreCase(admin.substring(1))) continue;
                team.canAdmin = true;
            }
        }
    }

    private void setUserAttributes(UserModel user, SearchResultEntry userEntry) {
        String email;
        this.setAdminAttribute(user);
        user.password = "#externalAccount";
        user.accountType = this.getAccountType();
        String displayName = this.settings.getString("realm.ldap.displayName", "");
        if (!StringUtils.isEmpty(displayName)) {
            if (displayName.contains("${")) {
                for (Attribute userAttribute : userEntry.getAttributes()) {
                    displayName = StringUtils.replace(displayName, "${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                user.displayName = displayName;
            } else {
                Attribute attribute = userEntry.getAttribute(displayName);
                if (attribute != null && attribute.hasValue()) {
                    user.displayName = attribute.getValue();
                }
            }
        }
        if (!StringUtils.isEmpty(email = this.settings.getString("realm.ldap.email", ""))) {
            if (email.contains("${")) {
                for (Attribute userAttribute : userEntry.getAttributes()) {
                    email = StringUtils.replace(email, "${" + userAttribute.getName() + "}", userAttribute.getValue());
                }
                user.emailAddress = email;
            } else {
                Attribute attribute = userEntry.getAttribute(email);
                user.emailAddress = attribute != null && attribute.hasValue() ? attribute.getValue() : null;
            }
        }
    }

    private void getTeamsFromLdap(LdapConnection ldapConnection, String simpleUsername, SearchResultEntry loggingInUser, UserModel user) {
        String loggingInUserDN = loggingInUser.getDN();
        user.teams.clear();
        String groupBase = this.settings.getString("realm.ldap.groupBase", "");
        String groupMemberPattern = this.settings.getString("realm.ldap.groupMemberPattern", "(&(objectClass=group)(member=${dn}))");
        groupMemberPattern = StringUtils.replace(groupMemberPattern, "${dn}", LdapConnection.escapeLDAPSearchFilter(loggingInUserDN));
        groupMemberPattern = StringUtils.replace(groupMemberPattern, "${username}", LdapConnection.escapeLDAPSearchFilter(simpleUsername));
        for (Attribute userAttribute : loggingInUser.getAttributes()) {
            groupMemberPattern = StringUtils.replace(groupMemberPattern, "${" + userAttribute.getName() + "}", LdapConnection.escapeLDAPSearchFilter(userAttribute.getValue()));
        }
        SearchResult teamMembershipResult = this.searchTeamsInLdap(ldapConnection, groupBase, true, groupMemberPattern, Arrays.asList("cn"));
        if (teamMembershipResult != null && teamMembershipResult.getEntryCount() > 0) {
            for (int i = 0; i < teamMembershipResult.getEntryCount(); ++i) {
                SearchResultEntry teamEntry = (SearchResultEntry)teamMembershipResult.getSearchEntries().get(i);
                String teamName = teamEntry.getAttribute("cn").getValue();
                TeamModel teamModel = this.userManager.getTeamModel(teamName);
                if (teamModel == null) {
                    teamModel = this.createTeamFromLdap(teamEntry);
                }
                user.teams.add(teamModel);
                teamModel.addUser(user.getName());
            }
        }
    }

    private void getEmptyTeamsFromLdap(LdapConnection ldapConnection) {
        this.logger.info("Start fetching empty teams from ldap.");
        String groupBase = this.settings.getString("realm.ldap.groupBase", "");
        String groupMemberPattern = this.settings.getString("realm.ldap.groupEmptyMemberPattern", "(&(objectClass=group)(!(member=*)))");
        SearchResult teamMembershipResult = this.searchTeamsInLdap(ldapConnection, groupBase, true, groupMemberPattern, null);
        if (teamMembershipResult != null && teamMembershipResult.getEntryCount() > 0) {
            for (int i = 0; i < teamMembershipResult.getEntryCount(); ++i) {
                String teamName;
                TeamModel teamModel;
                SearchResultEntry teamEntry = (SearchResultEntry)teamMembershipResult.getSearchEntries().get(i);
                if (teamEntry.hasAttribute("member") || (teamModel = this.userManager.getTeamModel(teamName = teamEntry.getAttribute("cn").getValue())) != null) continue;
                teamModel = this.createTeamFromLdap(teamEntry);
                this.setAdminAttribute(teamModel);
                this.userManager.updateTeamModel(teamModel);
            }
        }
        this.logger.info("Finished fetching empty teams from ldap.");
    }

    private SearchResult searchTeamsInLdap(LdapConnection ldapConnection, String base, boolean dereferenceAliases, String filter, List<String> attributes) {
        SearchResult result = ldapConnection.search(base, dereferenceAliases, filter, attributes);
        if (result == null) {
            return null;
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            this.logger.debug("Rebinding as user to search for teams in LDAP");
            result = null;
            if (ldapConnection.rebindAsUser()) {
                result = ldapConnection.search(base, dereferenceAliases, filter, attributes);
                if (result.getResultCode() != ResultCode.SUCCESS) {
                    return null;
                }
                this.logger.info("Successful search after rebinding as user.");
            }
        }
        return result;
    }

    private TeamModel createTeamFromLdap(SearchResultEntry teamEntry) {
        TeamModel answer = new TeamModel(teamEntry.getAttributeValue("cn"));
        answer.accountType = this.getAccountType();
        return answer;
    }

    private SearchResult doSearch(LdapConnection ldapConnection, String base, String filter) {
        try {
            SearchRequest searchRequest = new SearchRequest(base, SearchScope.SUB, filter, new String[0]);
            SearchResult result = ldapConnection.search(searchRequest);
            if (result.getResultCode() != ResultCode.SUCCESS) {
                return null;
            }
            return result;
        }
        catch (LDAPException e) {
            this.logger.error("Problem creating LDAP search", (Throwable)e);
            return null;
        }
    }

    protected String getSimpleUsername(String username) {
        int lastSlash = username.lastIndexOf(92);
        if (lastSlash > -1) {
            username = username.substring(lastSlash + 1);
        }
        return username;
    }

    private void configureSyncService() {
        LdapSyncService ldapSyncService = new LdapSyncService(this.settings, this);
        if (ldapSyncService.isReady()) {
            long ldapSyncPeriod = this.getSynchronizationPeriodInMilliseconds();
            int delay = 1;
            this.logger.info("Ldap sync service will update users and groups every {} minutes.", (Object)TimeUnit.MILLISECONDS.toMinutes(ldapSyncPeriod));
            this.scheduledExecutorService.scheduleAtFixedRate(ldapSyncService, delay, ldapSyncPeriod, TimeUnit.MILLISECONDS);
        } else {
            this.logger.info("Ldap sync service is disabled.");
        }
    }
}

