/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import java.io.File;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.CLibrary;

public class PAMAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    public PAMAuthProvider() {
        super("pam");
    }

    @Override
    public void setup() {
        String[] files = new String[]{"/etc/shadow", "/etc/master.passwd"};
        File passwdFile = null;
        for (String name : files) {
            File f = new File(name);
            if (!f.exists()) continue;
            passwdFile = f;
            break;
        }
        if (passwdFile == null) {
            this.logger.error("PAM Authentication could not find a passwd database!");
        } else if (!passwdFile.canRead()) {
            this.logger.error("PAM Authentication can not read passwd database {}! PAM authentications may fail!", (Object)passwdFile);
        }
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return true;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return true;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.PAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserModel authenticate(String username, char[] password) {
        if (CLibrary.libc.getpwnam(username) == null) {
            this.logger.warn("Can not get PAM passwd for " + username);
            return null;
        }
        PAM pam2 = null;
        try {
            String serviceName = this.settings.getString("realm.pam.serviceName", "system-auth");
            pam2 = new PAM(serviceName);
            pam2.authenticate(username, new String(password));
        }
        catch (PAMException e) {
            this.logger.error(e.getMessage());
            UserModel userModel = null;
            return userModel;
        }
        finally {
            if (pam2 != null) {
                pam2.dispose();
            }
        }
        UserModel user = this.userManager.getUserModel(username);
        if (user == null) {
            user = new UserModel(username.toLowerCase());
        }
        this.setCookie(user);
        user.accountType = this.getAccountType();
        user.password = "#externalAccount";
        this.updateUser(user);
        return user;
    }
}

