/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;

public class SalesforceAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    public SalesforceAuthProvider() {
        super("salesforce");
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.SALESFORCE;
    }

    @Override
    public void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserModel authenticate(String username, char[] password) {
        ConnectorConfig config = new ConnectorConfig();
        config.setUsername(username);
        config.setPassword(new String(password));
        try {
            PartnerConnection connection = Connector.newConnection((ConnectorConfig)config);
            GetUserInfoResult info = connection.getUserInfo();
            String org = this.settings.getString("realm.salesforce.orgId", "0").trim();
            if (!org.equals("0") && !org.equals(info.getOrganizationId())) {
                this.logger.warn("Access attempted by user of an invalid org: " + info.getUserName() + ", org: " + info.getOrganizationName() + "(" + info.getOrganizationId() + ")");
                return null;
            }
            this.logger.info("Authenticated user " + info.getUserName() + " using org " + info.getOrganizationName() + "(" + info.getOrganizationId() + ")");
            String simpleUsername = this.getSimpleUsername(info);
            UserModel user = null;
            SalesforceAuthProvider salesforceAuthProvider = this;
            synchronized (salesforceAuthProvider) {
                user = this.userManager.getUserModel(simpleUsername);
                if (user == null) {
                    user = new UserModel(simpleUsername);
                }
                this.setCookie(user);
                this.setUserAttributes(user, info);
                this.updateUser(user);
            }
            return user;
        }
        catch (ConnectionException e) {
            this.logger.error("Failed to authenticate", (Throwable)e);
            return null;
        }
    }

    private void setUserAttributes(UserModel user, GetUserInfoResult info) {
        user.password = "#externalAccount";
        user.accountType = this.getAccountType();
        user.displayName = info.getUserFullName();
        user.emailAddress = info.getUserEmail();
    }

    private String getSimpleUsername(GetUserInfoResult info) {
        String email = info.getUserEmail();
        return email.split("@")[0];
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return false;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }
}

