/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.auth;

import com.gitblit.Constants;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.sun.jna.platform.win32.Win32Exception;
import java.util.TreeSet;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WindowsAuthProvider
extends AuthenticationProvider.UsernamePasswordAuthenticationProvider {
    private IWindowsAuthProvider waffle;

    public WindowsAuthProvider() {
        super("windows");
    }

    @Override
    public void setup() {
        this.waffle = new WindowsAuthProviderImpl();
        IWindowsComputer computer = this.waffle.getCurrentComputer();
        this.logger.info("Windows Authentication Provider");
        this.logger.info("      name = " + computer.getComputerName());
        this.logger.info("    status = " + this.describeJoinStatus(computer.getJoinStatus()));
        this.logger.info("  memberOf = " + computer.getMemberOf());
    }

    protected String describeJoinStatus(String value) {
        if ("NetSetupUnknownStatus".equals(value)) {
            return "unknown";
        }
        if ("NetSetupUnjoined".equals(value)) {
            return "not joined";
        }
        if ("NetSetupWorkgroupName".equals(value)) {
            return "joined to a workgroup";
        }
        if ("NetSetupDomainName".equals(value)) {
            return "joined to a domain";
        }
        return value;
    }

    @Override
    public boolean supportsCredentialChanges() {
        return false;
    }

    @Override
    public boolean supportsDisplayNameChanges() {
        return false;
    }

    @Override
    public boolean supportsEmailAddressChanges() {
        return true;
    }

    @Override
    public boolean supportsTeamMembershipChanges() {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return true;
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return true;
    }

    @Override
    public Constants.AccountType getAccountType() {
        return Constants.AccountType.WINDOWS;
    }

    @Override
    public UserModel authenticate(String username, char[] password) {
        String defaultDomain = this.settings.getString("realm.windows.defaultDomain", null);
        if (StringUtils.isEmpty(defaultDomain)) {
            defaultDomain = null;
        }
        if (defaultDomain != null) {
            if (username.startsWith(defaultDomain + "\\")) {
                username = username.substring(defaultDomain.length() + 1);
            } else if (username.endsWith("@" + defaultDomain)) {
                username = username.substring(0, username.lastIndexOf(64));
            }
        }
        IWindowsIdentity identity = null;
        try {
            identity = username.indexOf(64) > -1 || username.indexOf(92) > -1 ? this.waffle.logonUser(username, new String(password)) : this.waffle.logonDomainUser(username, defaultDomain, new String(password));
        }
        catch (Win32Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
        if (identity.isGuest() && !this.settings.getBoolean("realm.windows.allowGuests", false)) {
            this.logger.warn("Guest account access is disabled");
            identity.dispose();
            return null;
        }
        UserModel user = this.userManager.getUserModel(username);
        if (user == null) {
            user = new UserModel(username.toLowerCase());
        }
        this.setCookie(user);
        user.accountType = this.getAccountType();
        String fqn = identity.getFqn();
        user.displayName = fqn.indexOf(92) > -1 ? fqn.substring(fqn.lastIndexOf(92) + 1) : fqn;
        user.password = "#externalAccount";
        TreeSet<String> groupNames = new TreeSet<String>();
        for (IWindowsAccount group : identity.getGroups()) {
            groupNames.add(group.getFqn());
        }
        if (this.settings.getBoolean("realm.windows.permitBuiltInAdministrators", true) && groupNames.contains("BUILTIN\\Administrators")) {
            user.canAdmin = true;
        }
        this.updateUser(user);
        identity.dispose();
        return user;
    }
}

