/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.ConfigUserService;
import com.gitblit.Constants;
import com.gitblit.FileSettings;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.authority.AuthorityWorker;
import com.gitblit.authority.CertificateStatus;
import com.gitblit.authority.CertificateStatusRenderer;
import com.gitblit.authority.DefaultOidsPanel;
import com.gitblit.authority.NewCertificateConfig;
import com.gitblit.authority.NewSSLCertificateDialog;
import com.gitblit.authority.RequestFocusListener;
import com.gitblit.authority.UserCertificateConfig;
import com.gitblit.authority.UserCertificateModel;
import com.gitblit.authority.UserCertificatePanel;
import com.gitblit.authority.UserCertificateTableModel;
import com.gitblit.authority.Utils;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.models.Mailing;
import com.gitblit.models.UserModel;
import com.gitblit.service.MailService;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.mail.Message;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.LoggerFactory;

public class GitblitAuthority
extends JFrame
implements X509Utils.X509Log {
    private static final long serialVersionUID = 1L;
    private final UserCertificateTableModel tableModel = new UserCertificateTableModel();
    private UserCertificatePanel userCertificatePanel;
    private File folder;
    private IStoredSettings gitblitSettings;
    private IUserService userService;
    private String caKeystorePassword;
    private JTable table;
    private int defaultDuration;
    private TableRowSorter<UserCertificateTableModel> defaultSorter = new TableRowSorter<UserCertificateTableModel>(this.tableModel);
    private MailService mail;
    private JButton certificateDefaultsButton;
    private JButton newSSLCertificate;

    public static void main(String ... args) {
        String folder = "data";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("--baseFolder")) continue;
            if (i + 1 == args.length) {
                System.out.println("Invalid --baseFolder parameter!");
                System.exit(-1);
                break;
            }
            if (".".equals(args[i + 1])) break;
            folder = args[i + 1];
            break;
        }
        final String baseFolder = folder;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GitblitAuthority authority = new GitblitAuthority();
                authority.initialize(baseFolder);
                authority.setLocationRelativeTo(null);
                authority.setVisible(true);
            }
        });
    }

    public void initialize(String baseFolder) {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.setTitle("Gitblit Certificate Authority v" + Constants.getVersion() + " (" + Constants.getBuildDate() + ")");
        this.setContentPane(this.getUI());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GitblitAuthority.this.saveSizeAndPosition();
            }

            @Override
            public void windowOpened(WindowEvent event) {
            }
        });
        File folder = new File(baseFolder).getAbsoluteFile();
        this.load(folder);
        this.setSizeAndPosition();
    }

    private void setSizeAndPosition() {
        String[] chunks;
        String sz = null;
        String pos = null;
        try {
            StoredConfig config = this.getConfig();
            sz = config.getString("ui", null, "size");
            pos = config.getString("ui", null, "position");
            this.defaultDuration = config.getInt("new", "duration", 365);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (StringUtils.isEmpty(sz)) {
            this.setSize(900, 600);
        } else {
            chunks = sz.split("x");
            int width = Integer.parseInt(chunks[0]);
            int height = Integer.parseInt(chunks[1]);
            this.setSize(width, height);
        }
        if (StringUtils.isEmpty(pos)) {
            this.setLocationRelativeTo(null);
        } else {
            chunks = pos.split(",");
            int x = Integer.parseInt(chunks[0]);
            int y = Integer.parseInt(chunks[1]);
            this.setLocation(x, y);
        }
    }

    private void saveSizeAndPosition() {
        try {
            StoredConfig config = this.getConfig();
            Dimension sz = this.getSize();
            config.setString("ui", null, "size", MessageFormat.format("{0,number,0}x{1,number,0}", sz.width, sz.height));
            Point pos = this.getLocationOnScreen();
            config.setString("ui", null, "position", MessageFormat.format("{0,number,0},{1,number,0}", pos.x, pos.y));
            config.save();
        }
        catch (Throwable t) {
            Utils.showException(this, t);
        }
    }

    private StoredConfig getConfig() throws IOException, ConfigInvalidException {
        File configFile = new File(this.folder, "certs/authority.conf");
        FileBasedConfig config = new FileBasedConfig(configFile, FS.detect());
        config.load();
        return config;
    }

    private IUserService loadUsers(File folder) {
        File file = new File(folder, "gitblit.properties");
        if (!file.exists()) {
            return null;
        }
        this.gitblitSettings = new FileSettings(file.getAbsolutePath());
        this.mail = new MailService(this.gitblitSettings);
        String us = this.gitblitSettings.getString("realm.userService", "${baseFolder}/users.conf");
        String ext = us.substring(us.lastIndexOf(".") + 1).toLowerCase();
        ConfigUserService service = null;
        if (!ext.equals("conf") && !ext.equals("properties") && ext.contains("userservice")) {
            String realm2 = ext.substring(0, ext.indexOf("userservice"));
            us = this.gitblitSettings.getString(MessageFormat.format("realm.{0}.backingUserService", realm2), "${baseFolder}/users.conf");
        }
        if (!us.endsWith(".conf")) {
            throw new RuntimeException("Unsupported user service: " + us);
        }
        service = new ConfigUserService(FileUtils.resolveParameter("${baseFolder}", folder, us));
        service = new ConfigUserService(FileUtils.resolveParameter("${baseFolder}", folder, us));
        return service;
    }

    private void load(File folder) {
        this.folder = folder;
        this.userService = this.loadUsers(folder);
        System.out.println("${baseFolder} set to " + folder);
        if (this.userService == null) {
            JOptionPane.showMessageDialog(this, MessageFormat.format("Sorry, {0} doesn't look like a Gitblit GO installation.", folder));
        } else {
            HashMap<String, UserCertificateModel> map = new HashMap<String, UserCertificateModel>();
            for (String user : this.userService.getAllUsernames()) {
                UserModel model = this.userService.getUserModel(user);
                UserCertificateModel ucm = new UserCertificateModel(model);
                map.put(user, ucm);
            }
            File certificatesConfigFile = new File(folder, "certs/authority.conf");
            FileBasedConfig config = new FileBasedConfig(certificatesConfigFile, FS.detect());
            if (certificatesConfigFile.exists()) {
                try {
                    config.load();
                    List<UserCertificateModel> list = ((UserCertificateConfig)UserCertificateConfig.KEY.parse((Config)config)).list;
                    for (UserCertificateModel ucm : list) {
                        ucm.user = this.userService.getUserModel(ucm.user.username);
                        map.put(ucm.user.username, ucm);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ConfigInvalidException e) {
                    e.printStackTrace();
                }
            }
            this.tableModel.list = new ArrayList(map.values());
            Collections.sort(this.tableModel.list);
            this.tableModel.fireTableDataChanged();
            Utils.packColumns(this.table, 5);
            File caKeystore = new File(folder, "certs/caKeyStore.p12");
            if (!caKeystore.exists()) {
                int res;
                if (!X509Utils.unlimitedStrength && (res = JOptionPane.showConfirmDialog(this, Translation.get("gb.jceWarning"), Translation.get("gb.warning"), 0, 2)) != 0) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(URI.create("http://www.oracle.com/technetwork/java/javase/downloads/index.html"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    System.exit(1);
                }
                this.certificateDefaultsButton.doClick();
                this.prepareX509Infrastructure();
            }
        }
    }

    private boolean prepareX509Infrastructure() {
        if (this.caKeystorePassword == null) {
            JPasswordField pass = new JPasswordField(10);
            pass.setText(this.caKeystorePassword);
            pass.addAncestorListener(new RequestFocusListener());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(Translation.get("gb.enterKeystorePassword")), "North");
            panel.add((Component)pass, "Center");
            int result = JOptionPane.showConfirmDialog(this, panel, Translation.get("gb.password"), 2);
            if (result == 0) {
                this.caKeystorePassword = new String(pass.getPassword());
            } else {
                return false;
            }
        }
        X509Utils.X509Metadata metadata = new X509Utils.X509Metadata("localhost", this.caKeystorePassword);
        this.setMetadataDefaults(metadata);
        metadata.notAfter = new Date(System.currentTimeMillis() + 315360000000L);
        X509Utils.prepareX509Infrastructure(metadata, this.folder, this);
        return true;
    }

    private List<X509Certificate> findCerts(File folder, String username) {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        File userFolder = new File(folder, "certs" + File.separator + username);
        if (!userFolder.exists()) {
            return list;
        }
        File[] certs = userFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".cer") || name.toLowerCase().endsWith(".crt");
            }
        });
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            for (File cert : certs) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(cert));
                X509Certificate x509 = (X509Certificate)factory.generateCertificate(is);
                is.close();
                list.add(x509);
            }
        }
        catch (Exception e) {
            Utils.showException(this, e);
        }
        return list;
    }

    private Container getUI() {
        this.userCertificatePanel = new UserCertificatePanel(this){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }

            @Override
            public boolean isAllowEmail() {
                return GitblitAuthority.this.mail.isReady();
            }

            @Override
            public Date getDefaultExpiration() {
                Calendar c = Calendar.getInstance();
                c.add(5, GitblitAuthority.this.defaultDuration);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                return c.getTime();
            }

            @Override
            public boolean saveUser(String username, UserCertificateModel ucm) {
                return GitblitAuthority.this.userService.updateUserModel(username, ucm.user);
            }

            @Override
            public boolean newCertificate(UserCertificateModel ucm, X509Utils.X509Metadata metadata, boolean sendEmail) {
                if (!GitblitAuthority.this.prepareX509Infrastructure()) {
                    return false;
                }
                Date notAfter = metadata.notAfter;
                GitblitAuthority.this.setMetadataDefaults(metadata);
                metadata.notAfter = notAfter;
                UserModel user = ucm.user;
                if (!StringUtils.isEmpty(user.organizationalUnit)) {
                    metadata.oids.put("OU", user.organizationalUnit);
                }
                if (!StringUtils.isEmpty(user.organization)) {
                    metadata.oids.put("O", user.organization);
                }
                if (!StringUtils.isEmpty(user.locality)) {
                    metadata.oids.put("L", user.locality);
                }
                if (!StringUtils.isEmpty(user.stateProvince)) {
                    metadata.oids.put("ST", user.stateProvince);
                }
                if (!StringUtils.isEmpty(user.countryCode)) {
                    metadata.oids.put("C", user.countryCode);
                }
                File caKeystoreFile = new File(GitblitAuthority.this.folder, "certs/caKeyStore.p12");
                File zip = X509Utils.newClientBundle(user, metadata, caKeystoreFile, GitblitAuthority.this.caKeystorePassword, GitblitAuthority.this);
                if (ucm.expires == null || metadata.notAfter.before(ucm.expires)) {
                    ucm.expires = metadata.notAfter;
                }
                GitblitAuthority.this.updateAuthorityConfig(ucm);
                ucm.certs = null;
                int selectedIndex = GitblitAuthority.this.table.getSelectedRow();
                GitblitAuthority.this.tableModel.fireTableDataChanged();
                GitblitAuthority.this.table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                if (sendEmail) {
                    GitblitAuthority.this.sendEmail(user, metadata, zip);
                }
                return true;
            }

            @Override
            public boolean revoke(UserCertificateModel ucm, X509Certificate cert, X509Utils.RevocationReason reason) {
                File caKeystoreFile;
                if (!GitblitAuthority.this.prepareX509Infrastructure()) {
                    return false;
                }
                File caRevocationList = new File(GitblitAuthority.this.folder, "certs/caRevocationList.crl");
                if (X509Utils.revoke(cert, reason, caRevocationList, caKeystoreFile = new File(GitblitAuthority.this.folder, "certs/caKeyStore.p12"), GitblitAuthority.this.caKeystorePassword, GitblitAuthority.this)) {
                    File certificatesConfigFile = new File(GitblitAuthority.this.folder, "certs/authority.conf");
                    FileBasedConfig config = new FileBasedConfig(certificatesConfigFile, FS.detect());
                    if (certificatesConfigFile.exists()) {
                        try {
                            config.load();
                        }
                        catch (Exception e) {
                            Utils.showException(GitblitAuthority.this, e);
                        }
                    }
                    ucm.revoke(cert.getSerialNumber(), reason);
                    ucm.update((Config)config);
                    try {
                        config.save();
                    }
                    catch (Exception e) {
                        Utils.showException(GitblitAuthority.this, e);
                    }
                    ucm.certs = null;
                    int modelIndex = GitblitAuthority.this.table.convertRowIndexToModel(GitblitAuthority.this.table.getSelectedRow());
                    GitblitAuthority.this.tableModel.fireTableDataChanged();
                    GitblitAuthority.this.table.getSelectionModel().setSelectionInterval(modelIndex, modelIndex);
                    return true;
                }
                return false;
            }
        };
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        this.table.setRowSorter(this.defaultSorter);
        this.table.setDefaultRenderer(CertificateStatus.class, new CertificateStatusRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = GitblitAuthority.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                int modelIndex = GitblitAuthority.this.table.convertRowIndexToModel(row);
                UserCertificateModel ucm = GitblitAuthority.this.tableModel.get(modelIndex);
                if (ucm.certs == null) {
                    ucm.certs = GitblitAuthority.this.findCerts(GitblitAuthority.this.folder, ucm.user.username);
                }
                GitblitAuthority.this.userCertificatePanel.setUserCertificateModel(ucm);
            }
        });
        JPanel usersPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        usersPanel.add((Component)new HeaderPanel(Translation.get("gb.users"), "users_16x16.png"), "North");
        usersPanel.add((Component)new JScrollPane(this.table), "Center");
        usersPanel.setMinimumSize(new Dimension(400, 10));
        this.certificateDefaultsButton = new JButton(new ImageIcon(this.getClass().getResource("/settings_16x16.png")));
        this.certificateDefaultsButton.setFocusable(false);
        this.certificateDefaultsButton.setToolTipText(Translation.get("gb.newCertificateDefaults"));
        this.certificateDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                X509Utils.X509Metadata metadata = new X509Utils.X509Metadata("whocares", "whocares");
                File certificatesConfigFile = new File(GitblitAuthority.this.folder, "certs/authority.conf");
                FileBasedConfig config = new FileBasedConfig(certificatesConfigFile, FS.detect());
                NewCertificateConfig certificateConfig = null;
                if (certificatesConfigFile.exists()) {
                    try {
                        config.load();
                    }
                    catch (Exception x) {
                        Utils.showException(GitblitAuthority.this, x);
                    }
                    certificateConfig = (NewCertificateConfig)NewCertificateConfig.KEY.parse((Config)config);
                    certificateConfig.update(metadata);
                }
                InputVerifier verifier = new InputVerifier(){

                    @Override
                    public boolean verify(JComponent comp) {
                        boolean returnValue;
                        JTextField textField = (JTextField)comp;
                        try {
                            Integer.parseInt(textField.getText());
                            returnValue = true;
                        }
                        catch (NumberFormatException e) {
                            returnValue = false;
                        }
                        return returnValue;
                    }
                };
                JTextField siteNameTF = new JTextField(20);
                siteNameTF.setText(GitblitAuthority.this.gitblitSettings.getString("web.siteName", "Gitblit"));
                JPanel siteNamePanel = Utils.newFieldPanel(Translation.get("gb.siteName"), siteNameTF, Translation.get("gb.siteNameDescription"));
                JTextField validityTF = new JTextField(4);
                validityTF.setInputVerifier(verifier);
                validityTF.setVerifyInputWhenFocusTarget(true);
                validityTF.setText("" + certificateConfig.duration);
                JPanel validityPanel = Utils.newFieldPanel(Translation.get("gb.validity"), validityTF, Translation.get("gb.duration.days").replace("{0}", "").trim());
                JPanel p1 = new JPanel(new GridLayout(0, 1, 5, 2));
                p1.add(siteNamePanel);
                p1.add(validityPanel);
                DefaultOidsPanel oids = new DefaultOidsPanel(metadata);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)p1, "North");
                panel.add((Component)oids, "Center");
                int result = JOptionPane.showConfirmDialog(GitblitAuthority.this, panel, Translation.get("gb.newCertificateDefaults"), 2, 3, new ImageIcon(this.getClass().getResource("/settings_32x32.png")));
                if (result == 0) {
                    try {
                        oids.update(metadata);
                        certificateConfig.duration = Integer.parseInt(validityTF.getText());
                        certificateConfig.store((Config)config, metadata);
                        config.save();
                        HashMap<String, String> updates = new HashMap<String, String>();
                        updates.put("web.siteName", siteNameTF.getText());
                        GitblitAuthority.this.gitblitSettings.saveSettings(updates);
                    }
                    catch (Exception e1) {
                        Utils.showException(GitblitAuthority.this, e1);
                    }
                }
            }
        });
        this.newSSLCertificate = new JButton(new ImageIcon(this.getClass().getResource("/rosette_16x16.png")));
        this.newSSLCertificate.setFocusable(false);
        this.newSSLCertificate.setToolTipText(Translation.get("gb.newSSLCertificate"));
        this.newSSLCertificate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date defaultExpiration = new Date(System.currentTimeMillis() + 315360000000L);
                NewSSLCertificateDialog dialog = new NewSSLCertificateDialog((Frame)GitblitAuthority.this, defaultExpiration);
                dialog.setModal(true);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                final Date expires = dialog.getExpiration();
                final String hostname = dialog.getHostname();
                final boolean serveCertificate = dialog.isServeCertificate();
                AuthorityWorker worker = new AuthorityWorker(GitblitAuthority.this){

                    @Override
                    protected Boolean doRequest() throws IOException {
                        boolean hasCert;
                        if (!GitblitAuthority.this.prepareX509Infrastructure()) {
                            return false;
                        }
                        File caKeystoreFile = new File(GitblitAuthority.this.folder, "certs/caKeyStore.p12");
                        PrivateKey caPrivateKey = X509Utils.getPrivateKey("Gitblit Certificate Authority", caKeystoreFile, GitblitAuthority.this.caKeystorePassword);
                        X509Certificate caCert = X509Utils.getCertificate("Gitblit Certificate Authority", caKeystoreFile, GitblitAuthority.this.caKeystorePassword);
                        X509Utils.X509Metadata metadata = new X509Utils.X509Metadata(hostname, GitblitAuthority.this.caKeystorePassword);
                        GitblitAuthority.this.setMetadataDefaults(metadata);
                        metadata.notAfter = expires;
                        File serverKeystoreFile = new File(GitblitAuthority.this.folder, "serverKeyStore.jks");
                        X509Certificate cert = X509Utils.newSSLCertificate(metadata, caPrivateKey, caCert, serverKeystoreFile, GitblitAuthority.this);
                        boolean bl = hasCert = cert != null;
                        if (hasCert && serveCertificate) {
                            HashMap<String, String> updates = new HashMap<String, String>();
                            updates.put("server.certificateAlias", metadata.commonName);
                            GitblitAuthority.this.gitblitSettings.saveSettings(updates);
                        }
                        return hasCert;
                    }

                    @Override
                    protected void onSuccess() {
                        if (serveCertificate) {
                            JOptionPane.showMessageDialog(GitblitAuthority.this, MessageFormat.format(Translation.get("gb.sslCertificateGeneratedRestart"), hostname), Translation.get("gb.newSSLCertificate"), 1);
                        } else {
                            JOptionPane.showMessageDialog(GitblitAuthority.this, MessageFormat.format(Translation.get("gb.sslCertificateGenerated"), hostname), Translation.get("gb.newSSLCertificate"), 1);
                        }
                    }
                };
                worker.execute();
            }
        });
        JButton emailBundle = new JButton(new ImageIcon(this.getClass().getResource("/mail_16x16.png")));
        emailBundle.setFocusable(false);
        emailBundle.setToolTipText(Translation.get("gb.emailCertificateBundle"));
        emailBundle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File zip;
                int row = GitblitAuthority.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                int modelIndex = GitblitAuthority.this.table.convertRowIndexToModel(row);
                final UserCertificateModel ucm = GitblitAuthority.this.tableModel.get(modelIndex);
                if (ArrayUtils.isEmpty(ucm.certs)) {
                    JOptionPane.showMessageDialog(GitblitAuthority.this, MessageFormat.format(Translation.get("gb.pleaseGenerateClientCertificate"), ucm.user.getDisplayName()));
                }
                if (!(zip = new File(GitblitAuthority.this.folder, "certs" + File.separator + ucm.user.username + File.separator + ucm.user.username + ".zip")).exists()) {
                    return;
                }
                AuthorityWorker worker = new AuthorityWorker(GitblitAuthority.this){

                    @Override
                    protected Boolean doRequest() throws IOException {
                        X509Utils.X509Metadata metadata = new X509Utils.X509Metadata(ucm.user.username, "whocares");
                        metadata.serverHostname = GitblitAuthority.this.gitblitSettings.getString("web.siteName", "Gitblit");
                        if (StringUtils.isEmpty(metadata.serverHostname)) {
                            metadata.serverHostname = "Gitblit";
                        }
                        metadata.userDisplayname = ucm.user.getDisplayName();
                        return GitblitAuthority.this.sendEmail(ucm.user, metadata, zip);
                    }

                    @Override
                    protected void onSuccess() {
                        JOptionPane.showMessageDialog(GitblitAuthority.this, MessageFormat.format(Translation.get("gb.clientCertificateBundleSent"), ucm.user.getDisplayName()));
                    }
                };
                worker.execute();
            }
        });
        JButton logButton = new JButton(new ImageIcon(this.getClass().getResource("/script_16x16.png")));
        logButton.setFocusable(false);
        logButton.setToolTipText(Translation.get("gb.log"));
        logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File log = new File(GitblitAuthority.this.folder, "certs" + File.separator + "log.txt");
                if (log.exists()) {
                    String content = FileUtils.readContent(log, "\n");
                    JTextArea textarea = new JTextArea(content);
                    JScrollPane scrollPane = new JScrollPane(textarea);
                    scrollPane.setPreferredSize(new Dimension(700, 400));
                    JOptionPane.showMessageDialog(GitblitAuthority.this, scrollPane, log.getAbsolutePath(), 1);
                }
            }
        });
        final JTextField filterTextfield = new JTextField(15);
        filterTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitblitAuthority.this.filterUsers(filterTextfield.getText());
            }
        });
        filterTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GitblitAuthority.this.filterUsers(filterTextfield.getText());
            }
        });
        JToolBar buttonControls = new JToolBar(0);
        buttonControls.setFloatable(false);
        buttonControls.add(this.certificateDefaultsButton);
        buttonControls.add(this.newSSLCertificate);
        buttonControls.add(emailBundle);
        buttonControls.add(logButton);
        JPanel userControls = new JPanel(new FlowLayout(2, 5, 5));
        userControls.add(new JLabel(Translation.get("gb.filter")));
        userControls.add(filterTextfield);
        JPanel topPanel = new JPanel(new BorderLayout(0, 0));
        topPanel.add((Component)buttonControls, "West");
        topPanel.add((Component)userControls, "East");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)topPanel, "North");
        leftPanel.add((Component)usersPanel, "Center");
        this.userCertificatePanel.setMinimumSize(new Dimension(375, 10));
        JLabel statusLabel = new JLabel();
        statusLabel.setHorizontalAlignment(4);
        if (X509Utils.unlimitedStrength) {
            statusLabel.setText("JCE Unlimited Strength Jurisdiction Policy");
        } else {
            statusLabel.setText("JCE Standard Encryption Policy");
        }
        JPanel root = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        JSplitPane splitPane = new JSplitPane(1, leftPanel, this.userCertificatePanel);
        splitPane.setDividerLocation(1.0);
        root.add((Component)splitPane, "Center");
        root.add((Component)statusLabel, "South");
        return root;
    }

    private void filterUsers(final String fragment) {
        this.table.clearSelection();
        this.userCertificatePanel.setUserCertificateModel(null);
        if (StringUtils.isEmpty(fragment)) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        RowFilter<UserCertificateTableModel, Object> containsFilter = new RowFilter<UserCertificateTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends UserCertificateTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(fragment.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
        TableRowSorter<UserCertificateTableModel> sorter = new TableRowSorter<UserCertificateTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String message) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(this.folder, "certs" + File.separator + "log.txt"), true));
            writer.write(MessageFormat.format("{0,date,yyyy-MM-dd HH:mm}: {1}", new Date(), message));
            writer.newLine();
            writer.flush();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(GitblitAuthority.class).error("Failed to append log entry!", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean sendEmail(UserModel user, X509Utils.X509Metadata metadata, File zip) {
        try {
            if (this.mail.isReady()) {
                Mailing mailing = Mailing.newPlain();
                mailing.subject = user.getPreferences().getLocale() != null ? MessageFormat.format(ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp", user.getPreferences().getLocale()).getString("gb.emailClientCertificateSubject"), metadata.serverHostname) : MessageFormat.format(ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp", Locale.ENGLISH).getString("gb.emailClientCertificateSubject"), metadata.serverHostname);
                mailing.setRecipients(user.emailAddress);
                File fileMailTmp = null;
                String body = null;
                fileMailTmp = new File(this.folder, "certs" + File.separator + "mail.tmpl" + "_" + user.getPreferences().getLocale());
                if (fileMailTmp.exists()) {
                    body = X509Utils.processTemplate(fileMailTmp, metadata);
                } else {
                    fileMailTmp = new File(this.folder, "certs" + File.separator + "mail.tmpl");
                    body = X509Utils.processTemplate(fileMailTmp, metadata);
                }
                if (StringUtils.isEmpty(body)) {
                    body = MessageFormat.format("Hi {0}\n\nHere is your client certificate bundle.\nInside the zip file are installation instructions.", user.getDisplayName());
                }
                mailing.content = body;
                mailing.addAttachment(zip);
                Message message = this.mail.createMessage(mailing);
                this.mail.sendNow(message);
                return true;
            }
            JOptionPane.showMessageDialog(this, "Sorry, the mail server settings are not configured properly.\nCan not send email.", Translation.get("gb.error"), 0);
        }
        catch (Exception e) {
            Utils.showException(this, e);
        }
        return false;
    }

    private void setMetadataDefaults(X509Utils.X509Metadata metadata) {
        metadata.serverHostname = this.gitblitSettings.getString("web.siteName", "Gitblit");
        if (StringUtils.isEmpty(metadata.serverHostname)) {
            metadata.serverHostname = "Gitblit";
        }
        File certificatesConfigFile = new File(this.folder, "certs/authority.conf");
        FileBasedConfig config = new FileBasedConfig(certificatesConfigFile, FS.detect());
        if (certificatesConfigFile.exists()) {
            try {
                config.load();
            }
            catch (Exception e) {
                Utils.showException(this, e);
            }
            NewCertificateConfig certificateConfig = (NewCertificateConfig)NewCertificateConfig.KEY.parse((Config)config);
            certificateConfig.update(metadata);
        }
    }

    private void updateAuthorityConfig(UserCertificateModel ucm) {
        File certificatesConfigFile = new File(this.folder, "certs/authority.conf");
        FileBasedConfig config = new FileBasedConfig(certificatesConfigFile, FS.detect());
        if (certificatesConfigFile.exists()) {
            try {
                config.load();
            }
            catch (Exception e) {
                Utils.showException(this, e);
            }
        }
        ucm.update((Config)config);
        try {
            config.save();
        }
        catch (Exception e) {
            Utils.showException(this, e);
        }
    }
}

