/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.Utils;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.utils.StringUtils;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.bouncycastle.util.Arrays;

public class NewClientCertificateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JDateChooser expirationDate;
    JPasswordField pw1;
    JPasswordField pw2;
    JTextField hint;
    JCheckBox sendEmail;
    boolean isCanceled = true;

    public NewClientCertificateDialog(Frame owner, String displayname, Date defaultExpiration, boolean allowEmail) {
        super(owner);
        this.setTitle(Translation.get("gb.newCertificate"));
        JPanel content = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        this.expirationDate = new JDateChooser(defaultExpiration);
        this.pw1 = new JPasswordField(20);
        this.pw2 = new JPasswordField(20);
        this.hint = new JTextField(20);
        this.sendEmail = new JCheckBox(Translation.get("gb.sendEmail"));
        JPanel panel = new JPanel(new GridLayout(0, 2, 5, 5));
        panel.add(new JLabel(Translation.get("gb.expires")));
        panel.add((Component)this.expirationDate);
        panel.add(new JLabel(Translation.get("gb.password")));
        panel.add(this.pw1);
        panel.add(new JLabel(Translation.get("gb.confirmPassword")));
        panel.add(this.pw2);
        panel.add(new JLabel(Translation.get("gb.passwordHint")));
        panel.add(this.hint);
        if (allowEmail) {
            panel.add(new JLabel(""));
            panel.add(this.sendEmail);
        }
        JButton ok = new JButton(Translation.get("gb.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NewClientCertificateDialog.this.validateInputs()) {
                    NewClientCertificateDialog.this.isCanceled = false;
                    NewClientCertificateDialog.this.setVisible(false);
                }
            }
        });
        JButton cancel = new JButton(Translation.get("gb.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewClientCertificateDialog.this.isCanceled = true;
                NewClientCertificateDialog.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(ok);
        controls.add(cancel);
        JTextArea message = new JTextArea(Translation.get("gb.newClientCertificateMessage"));
        message.setLineWrap(true);
        message.setWrapStyleWord(true);
        message.setEditable(false);
        message.setRows(6);
        message.setPreferredSize(new Dimension(300, 100));
        content.add((Component)new JScrollPane(message), "Center");
        content.add((Component)panel, "North");
        content.add((Component)controls, "South");
        this.getContentPane().add((Component)new HeaderPanel(Translation.get("gb.newCertificate") + " (" + displayname + ")", "rosette_16x16.png"), "North");
        this.getContentPane().add((Component)content, "Center");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private boolean validateInputs() {
        if (this.getExpiration().getTime() < System.currentTimeMillis()) {
            JOptionPane.showMessageDialog(this, Translation.get("gb.invalidExpirationDate"), Translation.get("gb.error"), 0);
            return false;
        }
        if (this.pw1.getPassword().length == 0 || !Arrays.areEqual((char[])this.pw1.getPassword(), (char[])this.pw2.getPassword())) {
            JOptionPane.showMessageDialog(this, Translation.get("gb.passwordsDoNotMatch"), Translation.get("gb.error"), 0);
            return false;
        }
        if (StringUtils.isEmpty(this.getPasswordHint())) {
            JOptionPane.showMessageDialog(this, Translation.get("gb.passwordHintRequired"), Translation.get("gb.error"), 0);
            return false;
        }
        return true;
    }

    public String getPassword() {
        return new String(this.pw1.getPassword());
    }

    public String getPasswordHint() {
        return this.hint.getText();
    }

    public Date getExpiration() {
        return this.expirationDate.getDate();
    }

    public boolean sendEmail() {
        return this.sendEmail.isSelected();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

