/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.Utils;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.utils.StringUtils;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewSSLCertificateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JDateChooser expirationDate;
    JTextField hostname;
    JCheckBox serveCertificate;
    boolean isCanceled = true;

    public NewSSLCertificateDialog(Frame owner, Date defaultExpiration) {
        super(owner);
        this.setTitle(Translation.get("gb.newSSLCertificate"));
        JPanel content = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        this.expirationDate = new JDateChooser(defaultExpiration);
        this.hostname = new JTextField(20);
        this.serveCertificate = new JCheckBox(Translation.get("gb.serveCertificate"), true);
        JPanel panel = new JPanel(new GridLayout(0, 2, 5, 5));
        panel.add(new JLabel(Translation.get("gb.hostname")));
        panel.add(this.hostname);
        panel.add(new JLabel(Translation.get("gb.expires")));
        panel.add((Component)this.expirationDate);
        panel.add(new JLabel(""));
        panel.add(this.serveCertificate);
        JButton ok = new JButton(Translation.get("gb.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NewSSLCertificateDialog.this.validateInputs()) {
                    NewSSLCertificateDialog.this.isCanceled = false;
                    NewSSLCertificateDialog.this.setVisible(false);
                }
            }
        });
        JButton cancel = new JButton(Translation.get("gb.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSSLCertificateDialog.this.isCanceled = true;
                NewSSLCertificateDialog.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(ok);
        controls.add(cancel);
        content.add((Component)panel, "Center");
        content.add((Component)controls, "South");
        this.getContentPane().add((Component)new HeaderPanel(Translation.get("gb.newSSLCertificate"), "rosette_16x16.png"), "North");
        this.getContentPane().add((Component)content, "Center");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private boolean validateInputs() {
        if (this.getExpiration().getTime() < System.currentTimeMillis()) {
            JOptionPane.showMessageDialog(this, Translation.get("gb.invalidExpirationDate"), Translation.get("gb.error"), 0);
            return false;
        }
        if (StringUtils.isEmpty(this.getHostname())) {
            JOptionPane.showMessageDialog(this, Translation.get("gb.hostnameRequired"), Translation.get("gb.error"), 0);
            return false;
        }
        return true;
    }

    public String getHostname() {
        return this.hostname.getText();
    }

    public Date getExpiration() {
        return this.expirationDate.getDate();
    }

    public boolean isServeCertificate() {
        return this.serveCertificate.isSelected();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

