/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.CertificateStatus;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.Config;

public class UserCertificateModel
implements Comparable<UserCertificateModel> {
    public UserModel user;
    public Date expires;
    public List<X509Certificate> certs;
    public List<String> revoked;
    public String notes;

    public UserCertificateModel(UserModel user) {
        this.user = user;
    }

    public void update(Config config) {
        if (this.expires == null) {
            config.unset("user", this.user.username, "expires");
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            config.setString("user", this.user.username, "expires", df.format(this.expires));
        }
        if (StringUtils.isEmpty(this.notes)) {
            config.unset("user", this.user.username, "notes");
        } else {
            config.setString("user", this.user.username, "notes", this.notes);
        }
        if (ArrayUtils.isEmpty(this.revoked)) {
            config.unset("user", this.user.username, "revoked");
        } else {
            config.setStringList("user", this.user.username, "revoked", this.revoked);
        }
    }

    @Override
    public int compareTo(UserCertificateModel o) {
        return this.user.compareTo(o.user);
    }

    public void revoke(BigInteger serial, X509Utils.RevocationReason reason) {
        if (this.revoked == null) {
            this.revoked = new ArrayList<String>();
        }
        this.revoked.add(serial.toString() + ":" + reason.ordinal());
        this.expires = null;
        for (X509Certificate cert : this.certs) {
            if (this.isRevoked(cert.getSerialNumber()) || this.isExpired(cert.getNotAfter()) || this.expires != null && !cert.getNotAfter().after(this.expires)) continue;
            this.expires = cert.getNotAfter();
        }
    }

    public boolean isRevoked(BigInteger serial) {
        return this.isRevoked(serial.toString());
    }

    public boolean isRevoked(String serial) {
        if (ArrayUtils.isEmpty(this.revoked)) {
            return false;
        }
        String sn = serial + ":";
        for (String s : this.revoked) {
            if (!s.startsWith(sn)) continue;
            return true;
        }
        return false;
    }

    public X509Utils.RevocationReason getRevocationReason(BigInteger serial) {
        try {
            String sn = serial + ":";
            for (String s : this.revoked) {
                if (!s.startsWith(sn)) continue;
                String r = s.substring(sn.length());
                int i = Integer.parseInt(r);
                return X509Utils.RevocationReason.values()[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return X509Utils.RevocationReason.unspecified;
    }

    public CertificateStatus getStatus() {
        if (this.expires == null) {
            return CertificateStatus.unknown;
        }
        if (this.isExpired(this.expires)) {
            return CertificateStatus.expired;
        }
        if (this.isExpiring(this.expires)) {
            return CertificateStatus.expiring;
        }
        return CertificateStatus.ok;
    }

    public boolean hasExpired() {
        return this.expires != null && this.isExpiring(this.expires);
    }

    public CertificateStatus getStatus(X509Certificate cert) {
        if (this.isRevoked(cert.getSerialNumber())) {
            return CertificateStatus.revoked;
        }
        if (this.isExpired(cert.getNotAfter())) {
            return CertificateStatus.expired;
        }
        if (this.isExpiring(cert.getNotAfter())) {
            return CertificateStatus.expiring;
        }
        return CertificateStatus.ok;
    }

    private boolean isExpiring(Date date) {
        return date.getTime() - System.currentTimeMillis() <= 2592000000L;
    }

    private boolean isExpired(Date date) {
        return date.getTime() < System.currentTimeMillis();
    }
}

