/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.CertificateStatus;
import com.gitblit.authority.UserCertificateModel;
import com.gitblit.client.Translation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class UserCertificateTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<UserCertificateModel> list;

    public UserCertificateTableModel() {
        this(new ArrayList<UserCertificateModel>());
    }

    public UserCertificateTableModel(List<UserCertificateModel> list) {
        this.list = list;
        Collections.sort(this.list);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Username: {
                return Translation.get("gb.username");
            }
            case DisplayName: {
                return Translation.get("gb.displayName");
            }
            case Expires: {
                return Translation.get("gb.expires");
            }
            case Status: {
                return Translation.get("gb.status");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Expires: {
                return Date.class;
            }
            case Status: {
                return CertificateStatus.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            default: 
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        UserCertificateModel model = this.list.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Username: {
                return model.user.username;
            }
            case DisplayName: {
                return model.user.getDisplayName();
            }
            case Expires: {
                return model.expires;
            }
            case Status: {
                return model.getStatus();
            }
        }
        return null;
    }

    public UserCertificateModel get(int modelRow) {
        return this.list.get(modelRow);
    }

    static enum Columns {
        Username,
        DisplayName,
        Status,
        Expires;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

