/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.authority;

import com.gitblit.authority.Utils;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.Translation;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class X509CertificateViewer
extends JDialog {
    private static final long serialVersionUID = 1L;

    public X509CertificateViewer(Frame owner, X509Certificate cert) {
        super(owner);
        this.setTitle(Translation.get("gb.viewCertificate"));
        JPanel content = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        DateFormat df = DateFormat.getDateTimeInstance();
        int l1 = 15;
        int l2 = 25;
        int l3 = 45;
        JPanel panel = new JPanel(new GridLayout(0, 1, 0, 10));
        panel.add(this.newField(Translation.get("gb.version"), "" + cert.getVersion(), 3));
        panel.add(this.newField(Translation.get("gb.subject"), cert.getSubjectDN().getName(), l3));
        panel.add(this.newField(Translation.get("gb.issuer"), cert.getIssuerDN().getName(), l3));
        panel.add(this.newField(Translation.get("gb.serialNumber"), "0x" + cert.getSerialNumber().toString(16), l2));
        panel.add(this.newField(Translation.get("gb.serialNumber"), cert.getSerialNumber().toString(), l2));
        panel.add(this.newField(Translation.get("gb.validFrom"), df.format(cert.getNotBefore()), l2));
        panel.add(this.newField(Translation.get("gb.validUntil"), df.format(cert.getNotAfter()), l2));
        panel.add(this.newField(Translation.get("gb.publicKey"), cert.getPublicKey().getAlgorithm(), l1));
        panel.add(this.newField(Translation.get("gb.signatureAlgorithm"), cert.getSigAlgName(), l1));
        try {
            panel.add(this.newField(Translation.get("gb.sha1FingerPrint"), this.fingerprint(StringUtils.getSHA1(cert.getEncoded())), l3));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        try {
            panel.add(this.newField(Translation.get("gb.md5FingerPrint"), this.fingerprint(StringUtils.getMD5(cert.getEncoded())), l3));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        content.add((Component)panel, "Center");
        JButton ok = new JButton(Translation.get("gb.ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                X509CertificateViewer.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(ok);
        content.add((Component)controls, "South");
        this.getContentPane().add((Component)new HeaderPanel(Translation.get("gb.certificate"), "rosette_16x16.png"), "North");
        this.getContentPane().add((Component)content, "Center");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private JPanel newField(String label, String value, int cols) {
        JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
        JLabel lbl = new JLabel(label);
        lbl.setHorizontalAlignment(4);
        lbl.setPreferredSize(new Dimension(125, 20));
        panel.add(lbl);
        JTextField tf = new JTextField(value, cols);
        tf.setCaretPosition(0);
        tf.setEditable(false);
        panel.add(tf);
        return panel;
    }

    private String fingerprint(String value) {
        value = value.toUpperCase();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); i += 2) {
            sb.append(value.charAt(i));
            sb.append(value.charAt(i + 1));
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

