/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.JPalette;
import com.gitblit.client.RegistrantPermissionsPanel;
import com.gitblit.client.Translation;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.TeamModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditTeamDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String teamname;
    private final TeamModel team;
    private final ServerSettings settings;
    private boolean isCreate;
    private boolean canceled = true;
    private JTextField teamnameField;
    private JCheckBox canAdminCheckbox;
    private JCheckBox canForkCheckbox;
    private JCheckBox canCreateCheckbox;
    private JTextField mailingListsField;
    private RegistrantPermissionsPanel repositoryPalette;
    private JPalette<String> userPalette;
    private JPalette<String> preReceivePalette;
    private JLabel preReceiveInherited;
    private JPalette<String> postReceivePalette;
    private JLabel postReceiveInherited;
    private Set<String> teamnames;

    public EditTeamDialog(int protocolVersion, ServerSettings settings) {
        this(protocolVersion, new TeamModel(""), settings);
        this.isCreate = true;
        this.setTitle(Translation.get("gb.newTeam"));
    }

    public EditTeamDialog(int protocolVersion, TeamModel aTeam, ServerSettings settings) {
        this.teamname = aTeam.name;
        this.team = new TeamModel("");
        this.settings = settings;
        this.teamnames = new HashSet<String>();
        this.isCreate = false;
        this.initialize(protocolVersion, aTeam);
        this.setModal(true);
        this.setTitle(Translation.get("gb.edit") + ": " + aTeam.name);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditTeamDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private void initialize(int protocolVersion, TeamModel aTeam) {
        this.teamnameField = new JTextField(aTeam.name == null ? "" : aTeam.name, 25);
        this.canAdminCheckbox = new JCheckBox(Translation.get("gb.canAdminDescription"), aTeam.canAdmin);
        this.canForkCheckbox = new JCheckBox(Translation.get("gb.canForkDescription"), aTeam.canFork);
        this.canCreateCheckbox = new JCheckBox(Translation.get("gb.canCreateDescription"), aTeam.canCreate);
        this.mailingListsField = new JTextField(aTeam.mailingLists == null ? "" : StringUtils.flattenStrings(aTeam.mailingLists, " "), 50);
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.teamName"), this.teamnameField));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canAdmin"), this.canAdminCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canFork"), this.canForkCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.canCreate"), this.canCreateCheckbox));
        fieldsPanel.add(this.newFieldPanel(Translation.get("gb.mailingLists"), this.mailingListsField));
        final Insets _insets = new Insets(5, 5, 5, 5);
        this.repositoryPalette = new RegistrantPermissionsPanel(Constants.RegistrantType.REPOSITORY);
        this.userPalette = new JPalette();
        JPanel fieldsPanelTop = new JPanel(new BorderLayout());
        fieldsPanelTop.add((Component)fieldsPanel, "North");
        JPanel repositoriesPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        repositoriesPanel.add((Component)this.repositoryPalette, "Center");
        JPanel usersPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        usersPanel.add(this.userPalette, "Center");
        this.preReceivePalette = new JPalette(true);
        this.preReceiveInherited = new JLabel();
        JPanel preReceivePanel = new JPanel(new BorderLayout(5, 5));
        preReceivePanel.add(this.preReceivePalette, "Center");
        preReceivePanel.add((Component)this.preReceiveInherited, "West");
        this.postReceivePalette = new JPalette(true);
        this.postReceiveInherited = new JLabel();
        JPanel postReceivePanel = new JPanel(new BorderLayout(5, 5));
        postReceivePanel.add(this.postReceivePalette, "Center");
        postReceivePanel.add((Component)this.postReceiveInherited, "West");
        JTabbedPane panel = new JTabbedPane(1);
        panel.addTab(Translation.get("gb.general"), fieldsPanelTop);
        panel.addTab(Translation.get("gb.teamMembers"), usersPanel);
        panel.addTab(Translation.get("gb.restrictedRepositories"), repositoriesPanel);
        panel.addTab(Translation.get("gb.preReceiveScripts"), preReceivePanel);
        panel.addTab(Translation.get("gb.postReceiveScripts"), postReceivePanel);
        JButton createButton = new JButton(Translation.get("gb.save"));
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditTeamDialog.this.validateFields()) {
                    EditTeamDialog.this.canceled = false;
                    EditTeamDialog.this.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(Translation.get("gb.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditTeamDialog.this.canceled = true;
                EditTeamDialog.this.setVisible(false);
            }
        });
        JPanel controls = new JPanel();
        controls.add(cancelButton);
        controls.add(createButton);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return _insets;
            }
        };
        centerPanel.add((Component)panel, "Center");
        centerPanel.add((Component)controls, "South");
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
    }

    private JPanel newFieldPanel(String label, JComponent comp) {
        JLabel fieldLabel = new JLabel(label);
        fieldLabel.setFont(fieldLabel.getFont().deriveFont(1));
        fieldLabel.setPreferredSize(new Dimension(150, 20));
        JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
        panel.add(fieldLabel);
        panel.add(comp);
        return panel;
    }

    private boolean validateFields() {
        String tname = this.teamnameField.getText();
        if (StringUtils.isEmpty(tname)) {
            this.error("Please enter a team name!");
            return false;
        }
        boolean rename = false;
        if (this.isCreate) {
            if (this.teamnames.contains(tname.toLowerCase())) {
                this.error(MessageFormat.format("Team name ''{0}'' is unavailable.", tname));
                return false;
            }
        } else {
            boolean bl = rename = !StringUtils.isEmpty(this.teamname) && !this.teamname.equalsIgnoreCase(tname);
            if (rename && this.teamnames.contains(tname.toLowerCase())) {
                this.error(MessageFormat.format("Failed to rename ''{0}'' because ''{1}'' already exists.", this.teamname, tname));
                return false;
            }
        }
        this.team.name = tname;
        this.team.canAdmin = this.canAdminCheckbox.isSelected();
        this.team.canFork = this.canForkCheckbox.isSelected();
        this.team.canCreate = this.canCreateCheckbox.isSelected();
        String ml = this.mailingListsField.getText();
        if (!StringUtils.isEmpty(ml)) {
            HashSet<String> list = new HashSet<String>();
            for (String address : ml.split("(,|\\s)")) {
                if (StringUtils.isEmpty(address)) continue;
                list.add(address.toLowerCase());
            }
            this.team.mailingLists.clear();
            this.team.mailingLists.addAll(list);
        }
        for (RegistrantAccessPermission rp : this.repositoryPalette.getPermissions()) {
            this.team.setRepositoryPermission(rp.registrant, rp.permission);
        }
        this.team.users.clear();
        this.team.users.addAll(this.userPalette.getSelections());
        this.team.preReceiveScripts.clear();
        this.team.preReceiveScripts.addAll(this.preReceivePalette.getSelections());
        this.team.postReceiveScripts.clear();
        this.team.postReceiveScripts.addAll(this.postReceivePalette.getSelections());
        return true;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message, Translation.get("gb.error"), 0);
    }

    public void setTeams(List<TeamModel> teams) {
        this.teamnames.clear();
        for (TeamModel team : teams) {
            this.teamnames.add(team.name.toLowerCase());
        }
    }

    public void setRepositories(List<RepositoryModel> repositories, List<RegistrantAccessPermission> permissions) {
        String prefix;
        ArrayList<String> restricted = new ArrayList<String>();
        for (RepositoryModel repo : repositories) {
            if (!repo.accessRestriction.exceeds(Constants.AccessRestrictionType.NONE) || !repo.authorizationControl.equals((Object)Constants.AuthorizationControl.NAMED)) continue;
            restricted.add(repo.name);
        }
        StringUtils.sortRepositorynames(restricted);
        ArrayList<String> list = new ArrayList<String>();
        list.add(".*");
        if (this.settings.hasKey("git.userRepositoryPrefix")) {
            prefix = this.settings.get((String)"git.userRepositoryPrefix").currentValue;
            if (StringUtils.isEmpty(prefix)) {
                prefix = "~";
            }
        } else {
            prefix = "~";
        }
        if (prefix.length() == 1) {
            list.add("[^" + prefix + "].*");
        }
        String lastProject = null;
        for (String repo : restricted) {
            String projectPath = StringUtils.getFirstPathElement(repo);
            if (lastProject != null && lastProject.equalsIgnoreCase(projectPath)) continue;
            lastProject = projectPath;
            if (!StringUtils.isEmpty(projectPath)) {
                list.add(projectPath + "/.*");
            }
            list.add(repo);
        }
        if (permissions == null) {
            permissions = new ArrayList<RegistrantAccessPermission>();
        } else {
            for (RegistrantAccessPermission rp : permissions) {
                list.remove(rp.registrant);
            }
        }
        this.repositoryPalette.setObjects(list, permissions);
    }

    public void setUsers(List<String> users, List<String> selected) {
        Collections.sort(users);
        if (selected != null) {
            Collections.sort(selected);
        }
        this.userPalette.setObjects(users, selected);
    }

    public void setPreReceiveScripts(List<String> unused, List<String> inherited, List<String> selected) {
        Collections.sort(unused);
        if (selected != null) {
            Collections.sort(selected);
        }
        this.preReceivePalette.setObjects(unused, selected);
        this.showInherited(inherited, this.preReceiveInherited);
    }

    public void setPostReceiveScripts(List<String> unused, List<String> inherited, List<String> selected) {
        Collections.sort(unused);
        if (selected != null) {
            Collections.sort(selected);
        }
        this.postReceivePalette.setObjects(unused, selected);
        this.showInherited(inherited, this.postReceiveInherited);
    }

    private void showInherited(List<String> list, JLabel label) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            sb.append("<html><body><b>INHERITED</b><ul style=\"margin-left:5px;list-style-type: none;\">");
            for (String script : list) {
                sb.append("<li>").append(script).append("</li>");
            }
            sb.append("</ul></body></html>");
        }
        label.setText(sb.toString());
    }

    public TeamModel getTeam() {
        if (this.canceled) {
            return null;
        }
        return this.team;
    }
}

