/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.FeedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FeedsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<FeedModel> list;

    public FeedsTableModel() {
        this(new ArrayList<FeedModel>());
    }

    public FeedsTableModel(List<FeedModel> feeds) {
        this.list = feeds;
        Collections.sort(this.list);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Repository: {
                return Translation.get("gb.repository");
            }
            case Branch: {
                return Translation.get("gb.branch");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Subscribed: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Subscribed: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FeedModel model = this.list.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Repository: {
                return model.repository;
            }
            case Branch: {
                return model.branch;
            }
            case Subscribed: {
                return model.subscribed;
            }
        }
        return null;
    }

    public FeedModel get(int modelRow) {
        return this.list.get(modelRow);
    }

    static enum Columns {
        Subscribed,
        Repository,
        Branch;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

