/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.client.ClosableTabComponent;
import com.gitblit.client.EditRegistrationDialog;
import com.gitblit.client.GitblitPanel;
import com.gitblit.client.GitblitRegistration;
import com.gitblit.client.RegistrationsDialog;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedModel;
import com.gitblit.utils.Base64;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public class GitblitManager
extends JFrame
implements RegistrationsDialog.RegistrationListener {
    private static final long serialVersionUID = 1L;
    private static final String SERVER = "server";
    private static final String FEED = "feed";
    private final SimpleDateFormat dateFormat;
    private JTabbedPane serverTabs;
    private File configFile = new File(System.getProperty("user.home"), ".gitblit/config");
    private Map<String, GitblitRegistration> registrations = new LinkedHashMap<String, GitblitRegistration>();
    private JMenu recentMenu;
    private int maxRecentCount = 5;

    private GitblitManager() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private void initialize() {
        this.setContentPane(this.getCenterPanel());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.setTitle("Gitblit Manager v" + Constants.getVersion() + " (" + Constants.getBuildDate() + ")");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GitblitManager.this.saveSizeAndPosition();
            }

            @Override
            public void windowOpened(WindowEvent event) {
                GitblitManager.this.manageRegistrations();
            }
        });
        this.setSizeAndPosition();
        this.loadRegistrations();
        this.rebuildRecentMenu();
    }

    private void setSizeAndPosition() {
        String[] chunks;
        String sz = null;
        String pos = null;
        try {
            StoredConfig config = this.getConfig();
            sz = config.getString("ui", null, "size");
            pos = config.getString("ui", null, "position");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (StringUtils.isEmpty(sz)) {
            this.setSize(850, 500);
        } else {
            chunks = sz.split("x");
            int width = Integer.parseInt(chunks[0]);
            int height = Integer.parseInt(chunks[1]);
            this.setSize(width, height);
        }
        if (StringUtils.isEmpty(pos)) {
            this.setLocationRelativeTo(null);
        } else {
            chunks = pos.split(",");
            int x = Integer.parseInt(chunks[0]);
            int y = Integer.parseInt(chunks[1]);
            this.setLocation(x, y);
        }
    }

    private void saveSizeAndPosition() {
        try {
            StoredConfig config = this.getConfig();
            Dimension sz = this.getSize();
            config.setString("ui", null, "size", MessageFormat.format("{0,number,0}x{1,number,0}", sz.width, sz.height));
            Point pos = this.getLocationOnScreen();
            config.setString("ui", null, "position", MessageFormat.format("{0,number,0},{1,number,0}", pos.x, pos.y));
            config.save();
        }
        catch (Throwable t) {
            Utils.showException(this, t);
        }
    }

    private JMenuBar setupMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu serversMenu = new JMenu(Translation.get("gb.servers"));
        menuBar.add(serversMenu);
        this.recentMenu = new JMenu(Translation.get("gb.recent"));
        serversMenu.add(this.recentMenu);
        JMenuItem manage = new JMenuItem(Translation.get("gb.manage") + "...");
        manage.setAccelerator(KeyStroke.getKeyStroke(77, 128, false));
        manage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GitblitManager.this.manageRegistrations();
            }
        });
        serversMenu.add(manage);
        return menuBar;
    }

    private JPanel getCenterPanel() {
        this.serverTabs = new JTabbedPane(1);
        JMenuBar menubar = this.setupMenu();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)menubar, "North");
        panel.add((Component)this.serverTabs, "Center");
        return panel;
    }

    private void manageRegistrations() {
        RegistrationsDialog dialog = new RegistrationsDialog(new ArrayList<GitblitRegistration>(this.registrations.values()), this);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    @Override
    public void login(GitblitRegistration reg) {
        if (!(reg.savePassword || reg.password != null && reg.password.length != 0)) {
            EditRegistrationDialog dialog = new EditRegistrationDialog((Window)this, reg, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            GitblitRegistration newReg = dialog.getRegistration();
            if (newReg == null) {
                return;
            }
            newReg.feeds.addAll(reg.feeds);
            reg = newReg;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        final GitblitRegistration registration = reg;
        final GitblitPanel panel = new GitblitPanel(registration, this);
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws IOException {
                panel.login();
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    boolean success = (Boolean)this.get();
                    GitblitManager.this.serverTabs.addTab(registration.name, panel);
                    int idx = GitblitManager.this.serverTabs.getTabCount() - 1;
                    GitblitManager.this.serverTabs.setSelectedIndex(idx);
                    GitblitManager.this.serverTabs.setTabComponentAt(idx, new ClosableTabComponent(registration.name, null, GitblitManager.this.serverTabs, panel));
                    registration.lastLogin = new Date();
                    GitblitManager.this.saveRegistration(registration.name, registration);
                    GitblitManager.this.registrations.put(registration.name, registration);
                    GitblitManager.this.rebuildRecentMenu();
                    if (!registration.savePassword) {
                        registration.password = null;
                    }
                }
                catch (Throwable t) {
                    Throwable cause = t.getCause();
                    if (cause instanceof ConnectException) {
                        JOptionPane.showMessageDialog(GitblitManager.this, cause.getMessage(), Translation.get("gb.error"), 0);
                    } else if (cause instanceof GitBlitException.ForbiddenException) {
                        JOptionPane.showMessageDialog(GitblitManager.this, "This Gitblit server does not allow RPC Management or Administration", Translation.get("gb.error"), 0);
                    } else {
                        Utils.showException(GitblitManager.this, t);
                    }
                }
                finally {
                    GitblitManager.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        worker.execute();
    }

    private void rebuildRecentMenu() {
        this.recentMenu.removeAll();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/gitblt-favicon.png"));
        List<GitblitRegistration> list = new ArrayList<GitblitRegistration>(this.registrations.values());
        Collections.sort(list, new Comparator<GitblitRegistration>(){

            @Override
            public int compare(GitblitRegistration o1, GitblitRegistration o2) {
                return o2.lastLogin.compareTo(o1.lastLogin);
            }
        });
        if (list.size() > this.maxRecentCount) {
            list = list.subList(0, this.maxRecentCount);
        }
        for (int i = 0; i < list.size(); ++i) {
            final GitblitRegistration reg = list.get(i);
            JMenuItem item = new JMenuItem(reg.name, icon);
            item.setAccelerator(KeyStroke.getKeyStroke(49 + i, 128, false));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GitblitManager.this.login(reg);
                }
            });
            this.recentMenu.add(item);
        }
    }

    private void loadRegistrations() {
        try {
            StoredConfig config = this.getConfig();
            Set servers = config.getSubsections(SERVER);
            for (String server2 : servers) {
                Date lastLogin = new Date(0L);
                String date = config.getString(SERVER, server2, "lastLogin");
                if (!StringUtils.isEmpty(date)) {
                    lastLogin = this.dateFormat.parse(date);
                }
                String url = config.getString(SERVER, server2, "url");
                String account = config.getString(SERVER, server2, "account");
                String pw = config.getString(SERVER, server2, "password");
                char[] password = StringUtils.isEmpty(pw) ? new char[]{} : new String(Base64.decode(pw)).toCharArray();
                GitblitRegistration reg = new GitblitRegistration(server2, url, account, password){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void cacheFeeds() {
                        GitblitManager.this.writeFeedCache(this);
                    }
                };
                String[] feeds = config.getStringList(SERVER, server2, FEED);
                if (feeds != null) {
                    for (String definition : feeds) {
                        FeedModel feed = new FeedModel(definition);
                        reg.feeds.add(feed);
                    }
                }
                reg.lastLogin = lastLogin;
                this.loadFeedCache(reg);
                this.registrations.put(reg.name, reg);
            }
        }
        catch (Throwable t) {
            Utils.showException(this, t);
        }
    }

    @Override
    public boolean saveRegistration(String name, GitblitRegistration reg) {
        try {
            StoredConfig config = this.getConfig();
            if (!StringUtils.isEmpty(name) && !name.equals(reg.name)) {
                this.registrations.remove(name);
                config.unsetSection(SERVER, name);
            }
            config.setString(SERVER, reg.name, "url", reg.url);
            config.setString(SERVER, reg.name, "account", reg.account);
            if (reg.savePassword) {
                config.setString(SERVER, reg.name, "password", Base64.encodeBytes(new String(reg.password).getBytes("UTF-8")));
            } else {
                config.setString(SERVER, reg.name, "password", "");
            }
            if (reg.lastLogin != null) {
                config.setString(SERVER, reg.name, "lastLogin", this.dateFormat.format(reg.lastLogin));
            }
            ArrayList<String> definitions = new ArrayList<String>();
            for (FeedModel feed : reg.feeds) {
                definitions.add(feed.toString());
            }
            if (definitions.size() > 0) {
                config.setStringList(SERVER, reg.name, FEED, definitions);
            }
            config.save();
            return true;
        }
        catch (Throwable t) {
            Utils.showException(this, t);
            return false;
        }
    }

    @Override
    public boolean deleteRegistrations(List<GitblitRegistration> list) {
        boolean success = false;
        try {
            StoredConfig config = this.getConfig();
            for (GitblitRegistration reg : list) {
                config.unsetSection(SERVER, reg.name);
                this.registrations.remove(reg.name);
            }
            config.save();
            success = true;
        }
        catch (Throwable t) {
            Utils.showException(this, t);
        }
        return success;
    }

    private StoredConfig getConfig() throws IOException, ConfigInvalidException {
        FileBasedConfig config = new FileBasedConfig(this.configFile, FS.detect());
        config.load();
        return config;
    }

    private void loadFeedCache(GitblitRegistration reg) {
        File feedCache = new File(this.configFile.getParentFile(), StringUtils.getSHA1(reg.toString()) + ".cache");
        if (!feedCache.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(feedCache));
            HashMap<String, Date> cache = new HashMap<String, Date>();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] kvp = line.split("=");
                cache.put(kvp[0], df.parse(kvp[1]));
            }
            reader.close();
            for (FeedModel feed : reg.feeds) {
                String name = feed.toString();
                if (!cache.containsKey(name)) continue;
                feed.currentRefreshDate = (Date)cache.get(name);
            }
        }
        catch (Exception e) {
            Utils.showException(this, e);
        }
    }

    private void writeFeedCache(GitblitRegistration reg) {
        try {
            File feedCache = new File(this.configFile.getParentFile(), StringUtils.getSHA1(reg.toString()) + ".cache");
            FileWriter writer = new FileWriter(feedCache);
            for (FeedModel feed : reg.feeds) {
                writer.append(MessageFormat.format("{0}={1,date,yyyy-MM-dd'T'HH:mm:ss}\n", feed.toString(), feed.currentRefreshDate));
            }
            writer.close();
        }
        catch (Exception e) {
            Utils.showException(this, e);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GitblitManager frame = new GitblitManager();
                frame.initialize();
                frame.setVisible(true);
            }
        });
    }
}

