/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public abstract class GitblitWorker
extends SwingWorker<Boolean, Void> {
    private final Component parent;
    private final Constants.RpcRequest request;

    public GitblitWorker(Component parent, Constants.RpcRequest request) {
        this.parent = parent;
        this.request = request;
        parent.setCursor(Cursor.getPredefinedCursor(3));
    }

    protected Constants.RpcRequest getRequestType() {
        return this.request;
    }

    @Override
    protected Boolean doInBackground() throws IOException {
        return this.doRequest();
    }

    @Override
    protected void done() {
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Boolean success = (Boolean)this.get();
            if (success.booleanValue()) {
                this.onSuccess();
            } else {
                this.onFailure();
            }
        }
        catch (Throwable t) {
            if (t instanceof GitBlitException.ForbiddenException) {
                Utils.explainForbidden(this.parent, this.request);
            }
            if (t instanceof GitBlitException.UnauthorizedException) {
                Utils.explainUnauthorized(this.parent, this.request);
            }
            if (t instanceof GitBlitException.NotAllowedException) {
                Utils.explainNotAllowed(this.parent, this.request);
            }
            if (t instanceof GitBlitException.UnknownRequestException) {
                Utils.explainNotAllowed(this.parent, this.request);
            }
            Utils.showException(this.parent, t);
        }
    }

    protected abstract Boolean doRequest() throws IOException;

    protected abstract void onSuccess();

    protected void onFailure() {
    }

    protected void showFailure(String message, Object ... args) {
        String msg = MessageFormat.format(message, args);
        JOptionPane.showMessageDialog(this.parent, msg, Translation.get("gb.error"), 0);
    }
}

