/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.utils.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Insets insets = new Insets(5, 5, 5, 5);
    private Color lightColor = new Color(0, 0, 96);
    private JLabel headerLabel;
    private JLabel refreshLabel;

    public HeaderPanel(String text, String icon) {
        super(new GridLayout(1, 2, 5, 5), true);
        this.setOpaque(true);
        this.setBackground(new Color(0, 0, 32));
        this.headerLabel = new JLabel(text);
        if (!StringUtils.isEmpty(icon)) {
            this.headerLabel.setIcon(new ImageIcon(this.getClass().getResource("/" + icon)));
        }
        this.headerLabel.setForeground(Color.white);
        this.headerLabel.setFont(this.headerLabel.getFont().deriveFont(14.0f));
        this.add(this.headerLabel);
        this.refreshLabel = new JLabel("", 4);
        this.refreshLabel.setForeground(Color.white);
        this.add(this.refreshLabel);
    }

    public void setText(String text) {
        this.headerLabel.setText(text);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.refreshLabel.setText("refreshed " + df.format(new Date()));
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paintComponent(Graphics oldG) {
        Graphics2D g = (Graphics2D)oldG;
        Point2D.Float startPoint = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float endPoint = new Point2D.Float(0.0f, this.getHeight());
        GradientPaint gradientPaint = new GradientPaint(startPoint, this.lightColor, endPoint, this.getBackground(), false);
        g.setPaint(gradientPaint);
        g.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        g.setColor(new Color(255, 153, 0));
        int stroke = 2;
        g.setStroke(new BasicStroke(stroke));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

