/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.RepositoryModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class IndicatorsRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImageIcon blankIcon = new ImageIcon(this.getClass().getResource("/blank.png"));
    private final ImageIcon pushIcon = new ImageIcon(this.getClass().getResource("/lock_go_16x16.png"));
    private final ImageIcon pullIcon = new ImageIcon(this.getClass().getResource("/lock_pull_16x16.png"));
    private final ImageIcon viewIcon = new ImageIcon(this.getClass().getResource("/shield_16x16.png"));
    private final ImageIcon doxIcon = new ImageIcon(this.getClass().getResource("/book_16x16.png"));
    private final ImageIcon frozenIcon = new ImageIcon(this.getClass().getResource("/cold_16x16.png"));
    private final ImageIcon federatedIcon = new ImageIcon(this.getClass().getResource("/federated_16x16.png"));
    private final ImageIcon forkIcon = new ImageIcon(this.getClass().getResource("/commit_divide_16x16.png"));
    private final ImageIcon sparkleshareIcon = new ImageIcon(this.getClass().getResource("/star_16x16.png"));
    private final ImageIcon mirrorIcon = new ImageIcon(this.getClass().getResource("/mirror_16x16.png"));

    public IndicatorsRenderer() {
        super(new FlowLayout(2, 1, 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.removeAll();
        if (value instanceof RepositoryModel) {
            JLabel icon;
            StringBuilder tooltip = new StringBuilder();
            RepositoryModel model = (RepositoryModel)value;
            if (model.isSparkleshared()) {
                icon = new JLabel(this.sparkleshareIcon);
                tooltip.append(Translation.get("gb.isSparkleshared")).append("<br/>");
                this.add(icon);
            }
            if (model.isMirror) {
                icon = new JLabel(this.mirrorIcon);
                tooltip.append(Translation.get("gb.isMirror")).append("<br/>");
                this.add(icon);
            }
            if (model.isFork()) {
                icon = new JLabel(this.forkIcon);
                tooltip.append(Translation.get("gb.isFork")).append("<br/>");
                this.add(icon);
            }
            if (model.isFrozen) {
                icon = new JLabel(this.frozenIcon);
                tooltip.append(Translation.get("gb.isFrozen")).append("<br/>");
                this.add(icon);
            }
            if (model.isFederated) {
                icon = new JLabel(this.federatedIcon);
                tooltip.append(Translation.get("gb.isFederated")).append("<br/>");
                this.add(icon);
            }
            switch (model.accessRestriction) {
                case NONE: {
                    this.add(new JLabel(this.blankIcon));
                    break;
                }
                case PUSH: {
                    icon = new JLabel(this.pushIcon);
                    tooltip.append(Translation.get("gb.pushRestricted")).append("<br/>");
                    this.add(icon);
                    break;
                }
                case CLONE: {
                    icon = new JLabel(this.pullIcon);
                    tooltip.append(Translation.get("gb.cloneRestricted")).append("<br/>");
                    this.add(icon);
                    break;
                }
                case VIEW: {
                    icon = new JLabel(this.viewIcon);
                    tooltip.append(Translation.get("gb.viewRestricted")).append("<br/>");
                    this.add(icon);
                    break;
                }
                default: {
                    this.add(new JLabel(this.blankIcon));
                }
            }
            if (tooltip.length() > 0) {
                tooltip.insert(0, "<html><body>");
                this.setToolTipText(tooltip.toString().trim());
            }
        }
        return this;
    }
}

