/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.GitblitClient;
import com.gitblit.models.FeedEntryModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

public class MessageRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private final ImageIcon mergeIcon;
    private final ImageIcon blankIcon;
    private final JLabel messageLabel;
    private final JLabel headLabel;
    private final JLabel branchLabel;
    private final JLabel remoteLabel;
    private final JLabel tagLabel;

    public MessageRenderer() {
        this((GitblitClient)null);
    }

    public MessageRenderer(GitblitClient gitblit) {
        super(new FlowLayout(0, 5, 1));
        this.gitblit = gitblit;
        this.mergeIcon = new ImageIcon(this.getClass().getResource("/commit_merge_16x16.png"));
        this.blankIcon = new ImageIcon(this.getClass().getResource("/blank.png"));
        this.messageLabel = new JLabel();
        this.headLabel = this.newRefLabel();
        this.branchLabel = this.newRefLabel();
        this.remoteLabel = this.newRefLabel();
        this.tagLabel = this.newRefLabel();
        this.add(this.messageLabel);
        this.add(this.headLabel);
        this.add(this.branchLabel);
        this.add(this.remoteLabel);
        this.add(this.tagLabel);
    }

    private JLabel newRefLabel() {
        JLabel label = new JLabel();
        label.setOpaque(true);
        Font font = label.getFont();
        label.setFont(font.deriveFont(font.getSize2D() - 1.0f));
        return label;
    }

    private void resetRef(JLabel label) {
        label.setText("");
        label.setBackground(this.messageLabel.getBackground());
        label.setBorder(null);
        label.setVisible(false);
    }

    private void showRef(String ref, JLabel label) {
        String name = ref;
        Color bg = this.getBackground();
        LineBorder border = null;
        if (name.startsWith("refs/heads/")) {
            bg = Color.decode("#CCFFCC");
            name = name.substring("refs/heads/".length());
            border = new LineBorder(Color.decode("#00CC33"), 1);
        } else if (name.startsWith("refs/remotes/")) {
            bg = Color.decode("#CAC2F5");
            name = name.substring("refs/remotes/".length());
            border = new LineBorder(Color.decode("#6C6CBF"), 1);
        } else if (name.startsWith("refs/tags/")) {
            bg = Color.decode("#FFFFAA");
            name = name.substring("refs/tags/".length());
            border = new LineBorder(Color.decode("#FFCC00"), 1);
        } else if (name.equals("HEAD")) {
            bg = Color.decode("#FFAAFF");
            border = new LineBorder(Color.decode("#FF00EE"), 1);
        }
        label.setText(name);
        label.setBackground(bg);
        label.setBorder(border);
        label.setVisible(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.messageLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        if (value == null) {
            return this;
        }
        FeedEntryModel entry = (FeedEntryModel)value;
        if (this.gitblit == null) {
            this.messageLabel.setText(entry.title);
        } else if (entry.published.after(this.gitblit.getLastFeedRefresh(entry.repository, entry.branch))) {
            this.messageLabel.setText("<html><body><b>" + entry.title);
        } else {
            this.messageLabel.setText(entry.title);
        }
        this.resetRef(this.headLabel);
        this.resetRef(this.branchLabel);
        this.resetRef(this.remoteLabel);
        this.resetRef(this.tagLabel);
        int parentCount = 0;
        if (entry.tags != null) {
            for (String tag : entry.tags) {
                if (tag.startsWith("ref:")) {
                    tag = tag.substring("ref:".length());
                } else if (tag.startsWith("parent:")) {
                    ++parentCount;
                }
                if (tag.equals(entry.branch)) continue;
                if (tag.startsWith("refs/heads/")) {
                    this.showRef(tag, this.branchLabel);
                    continue;
                }
                if (tag.startsWith("refs/remotes/")) {
                    this.showRef(tag, this.remoteLabel);
                    continue;
                }
                if (tag.startsWith("refs/tags/")) {
                    this.showRef(tag, this.tagLabel);
                    continue;
                }
                if (!tag.equals("HEAD")) continue;
                this.showRef(tag, this.headLabel);
            }
        }
        if (parentCount > 1) {
            this.messageLabel.setIcon(this.mergeIcon);
        } else {
            this.messageLabel.setIcon(this.blankIcon);
        }
        return this;
    }
}

