/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.Translation;
import com.gitblit.models.RegistrantAccessPermission;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RegistrantPermissionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    List<RegistrantAccessPermission> permissions;

    public RegistrantPermissionsTableModel() {
        this(new ArrayList<RegistrantAccessPermission>());
    }

    public RegistrantPermissionsTableModel(List<RegistrantAccessPermission> list) {
        this.setPermissions(list);
    }

    public void setPermissions(List<RegistrantAccessPermission> list) {
        this.permissions = list;
    }

    @Override
    public int getRowCount() {
        return this.permissions.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Registrant: {
                return Translation.get("gb.name");
            }
            case Type: {
                return Translation.get("gb.type");
            }
            case Permission: {
                return Translation.get("gb.permission");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == Columns.Permission.ordinal()) {
            return Constants.AccessPermission.class;
        }
        if (columnIndex == Columns.Type.ordinal()) {
            return RegistrantAccessPermission.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == Columns.Permission.ordinal()) {
            return this.permissions.get((int)rowIndex).mutable;
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RegistrantAccessPermission rp = this.permissions.get(rowIndex);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Registrant: {
                return rp.registrant;
            }
            case Type: {
                return rp;
            }
            case Permission: {
                return rp.permission;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object o, int rowIndex, int columnIndex) {
        RegistrantAccessPermission rp = this.permissions.get(rowIndex);
        if (columnIndex == Columns.Permission.ordinal()) {
            rp.permission = (Constants.AccessPermission)((Object)o);
        }
    }

    static enum Columns {
        Registrant,
        Type,
        Permission;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

