/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.BranchRenderer;
import com.gitblit.client.FeedEntryTableModel;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.MessageRenderer;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SearchDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final boolean isSearch;
    private final GitblitClient gitblit;
    private FeedEntryTableModel tableModel;
    private HeaderPanel header;
    private JTable table;
    private JComboBox repositorySelector;
    private DefaultComboBoxModel branchChoices;
    private JComboBox branchSelector;
    private JComboBox searchTypeSelector;
    private JTextField searchFragment;
    private JComboBox maxHitsSelector;
    private int page;
    private JButton prev;
    private JButton next;

    public SearchDialog(GitblitClient gitblit, boolean isSearch) {
        this.gitblit = gitblit;
        this.isSearch = isSearch;
        this.setTitle(Translation.get(isSearch ? "gb.search" : "gb.log"));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/gitblt-favicon.png")).getImage());
        this.initialize();
        this.setSize(900, 550);
    }

    private void initialize() {
        this.prev = new JButton("<");
        this.prev.setToolTipText(Translation.get("gb.pagePrevious"));
        this.prev.setEnabled(false);
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search(--SearchDialog.this.page);
            }
        });
        this.next = new JButton(">");
        this.next.setToolTipText(Translation.get("gb.pageNext"));
        this.next.setEnabled(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search(++SearchDialog.this.page);
            }
        });
        JButton search = new JButton(Translation.get(this.isSearch ? "gb.search" : "gb.refresh"));
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search(0);
            }
        });
        final JButton viewCommit = new JButton(Translation.get("gb.view"));
        viewCommit.setEnabled(false);
        viewCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.viewCommit();
            }
        });
        final JButton viewCommitDiff = new JButton(Translation.get("gb.commitdiff"));
        viewCommitDiff.setEnabled(false);
        viewCommitDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.viewCommitDiff();
            }
        });
        final JButton viewTree = new JButton(Translation.get("gb.tree"));
        viewTree.setEnabled(false);
        viewTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.viewTree();
            }
        });
        JPanel controls = new JPanel(new FlowLayout(1, 5, 0));
        controls.add(viewCommit);
        controls.add(viewCommitDiff);
        controls.add(viewTree);
        NameRenderer nameRenderer = new NameRenderer();
        this.tableModel = new FeedEntryTableModel();
        this.header = new HeaderPanel(Translation.get(this.isSearch ? "gb.search" : "gb.log"), this.isSearch ? "search-icon.png" : "commit_changes_16x16.png");
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        String name = this.table.getColumnName(FeedEntryTableModel.Columns.Author.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Repository.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Branch.ordinal());
        this.table.getColumn(name).setCellRenderer(new BranchRenderer());
        name = this.table.getColumnName(FeedEntryTableModel.Columns.Message.ordinal());
        this.table.getColumn(name).setCellRenderer(new MessageRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.isControlDown()) {
                        SearchDialog.this.viewCommitDiff();
                    } else {
                        SearchDialog.this.viewCommit();
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean singleSelection = SearchDialog.this.table.getSelectedRowCount() == 1;
                viewCommit.setEnabled(singleSelection);
                viewCommitDiff.setEnabled(singleSelection);
                viewTree.setEnabled(singleSelection);
            }
        });
        this.repositorySelector = new JComboBox<Object>(this.gitblit.getRepositories().toArray());
        this.repositorySelector.setRenderer(nameRenderer);
        this.repositorySelector.setForeground(nameRenderer.getForeground());
        this.repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedBranch = null;
                if (SearchDialog.this.branchSelector.getSelectedIndex() > -1) {
                    selectedBranch = SearchDialog.this.branchSelector.getSelectedItem().toString();
                }
                SearchDialog.this.updateBranches();
                if (StringUtils.isEmpty(selectedBranch)) {
                    SearchDialog.this.branchSelector.setSelectedIndex(-1);
                } else if (SearchDialog.this.branchChoices.getIndexOf(selectedBranch) > -1) {
                    SearchDialog.this.branchChoices.setSelectedItem(selectedBranch);
                } else {
                    SearchDialog.this.branchSelector.setSelectedIndex(-1);
                }
            }
        });
        this.branchChoices = new DefaultComboBoxModel();
        this.branchSelector = new JComboBox(this.branchChoices);
        this.branchSelector.setRenderer(new BranchRenderer());
        this.searchTypeSelector = new JComboBox<Constants.SearchType>(Constants.SearchType.values());
        this.searchTypeSelector.setSelectedItem((Object)Constants.SearchType.COMMIT);
        this.maxHitsSelector = new JComboBox<Integer>(new Integer[]{25, 50, 75, 100});
        this.maxHitsSelector.setSelectedIndex(0);
        this.searchFragment = new JTextField(25);
        this.searchFragment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchDialog.this.search(0);
            }
        });
        JPanel queryPanel = new JPanel(new FlowLayout(0, 5, 0));
        queryPanel.add(new JLabel(Translation.get("gb.repository")));
        queryPanel.add(this.repositorySelector);
        queryPanel.add(new JLabel(Translation.get("gb.branch")));
        queryPanel.add(this.branchSelector);
        if (this.isSearch) {
            queryPanel.add(new JLabel(Translation.get("gb.type")));
            queryPanel.add(this.searchTypeSelector);
        }
        queryPanel.add(new JLabel(Translation.get("gb.maxHits")));
        queryPanel.add(this.maxHitsSelector);
        JPanel actionsPanel = new JPanel(new FlowLayout(0, 5, 0));
        actionsPanel.add(search);
        actionsPanel.add(this.prev);
        actionsPanel.add(this.next);
        JPanel northControls = new JPanel(new BorderLayout(5, 5));
        northControls.add((Component)queryPanel, "West");
        if (this.isSearch) {
            northControls.add((Component)this.searchFragment, "Center");
        }
        northControls.add((Component)actionsPanel, "East");
        JPanel northPanel = new JPanel(new BorderLayout(0, 5));
        northPanel.add((Component)this.header, "North");
        northPanel.add((Component)northControls, "Center");
        JPanel contentPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.add((Component)northPanel, "North");
        contentPanel.add((Component)new JScrollPane(this.table), "Center");
        contentPanel.add((Component)controls, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)contentPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                if (SearchDialog.this.isSearch) {
                    SearchDialog.this.searchFragment.requestFocus();
                } else {
                    SearchDialog.this.search(0);
                }
            }

            @Override
            public void windowActivated(WindowEvent event) {
                if (SearchDialog.this.isSearch) {
                    SearchDialog.this.searchFragment.requestFocus();
                }
            }
        });
    }

    public void selectRepository(RepositoryModel repository) {
        this.repositorySelector.setSelectedItem(repository);
    }

    private void updateBranches() {
        String repository = null;
        if (this.repositorySelector.getSelectedIndex() > -1) {
            repository = this.repositorySelector.getSelectedItem().toString();
        }
        List<String> branches = this.gitblit.getBranches(repository);
        this.branchChoices.removeAllElements();
        for (String branch : branches) {
            this.branchChoices.addElement(branch);
        }
    }

    protected void search(final int page) {
        int maxEntryCount;
        this.page = page;
        final String repository = this.repositorySelector.getSelectedItem().toString();
        final String branch = this.branchSelector.getSelectedIndex() > -1 ? this.branchSelector.getSelectedItem().toString() : null;
        final Constants.SearchType searchType = (Constants.SearchType)((Object)this.searchTypeSelector.getSelectedItem());
        final String fragment = this.isSearch ? this.searchFragment.getText() : null;
        int n = maxEntryCount = this.maxHitsSelector.getSelectedIndex() > -1 ? (Integer)this.maxHitsSelector.getSelectedItem() : -1;
        if (this.isSearch && StringUtils.isEmpty(fragment)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<List<FeedEntryModel>, Void> worker = new SwingWorker<List<FeedEntryModel>, Void>(){

            @Override
            protected List<FeedEntryModel> doInBackground() throws IOException {
                if (SearchDialog.this.isSearch) {
                    return SearchDialog.this.gitblit.search(repository, branch, fragment, searchType, maxEntryCount, page);
                }
                return SearchDialog.this.gitblit.log(repository, branch, maxEntryCount, page);
            }

            @Override
            protected void done() {
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    List results = (List)this.get();
                    if (SearchDialog.this.isSearch) {
                        SearchDialog.this.updateTable(true, fragment, results);
                    } else {
                        SearchDialog.this.updateTable(true, branch == null ? "" : branch, results);
                    }
                }
                catch (Throwable t) {
                    Utils.showException(SearchDialog.this, t);
                }
            }
        };
        worker.execute();
    }

    protected void updateTable(boolean pack, String text, List<FeedEntryModel> entries) {
        this.tableModel.entries.clear();
        this.tableModel.entries.addAll(entries);
        this.tableModel.fireTableDataChanged();
        this.setTitle(Translation.get(this.isSearch ? "gb.search" : "gb.log") + (StringUtils.isEmpty(text) ? "" : ": " + text) + " (" + entries.size() + (this.page > 0 ? ", pg " + (this.page + 1) : "") + ")");
        this.header.setText(this.getTitle());
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(0, 0, true)));
        int maxHits = (Integer)this.maxHitsSelector.getSelectedItem();
        this.next.setEnabled(entries.size() == maxHits);
        this.prev.setEnabled(this.page > 0);
    }

    protected FeedEntryModel getSelectedSyndicatedEntry() {
        int viewRow = this.table.getSelectedRow();
        int modelRow = this.table.convertRowIndexToModel(viewRow);
        FeedEntryModel entry = this.tableModel.get(modelRow);
        return entry;
    }

    protected void viewCommit() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link);
    }

    protected void viewCommitDiff() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link.replace("/commit/", "/commitdiff/"));
    }

    protected void viewTree() {
        FeedEntryModel entry = this.getSelectedSyndicatedEntry();
        Utils.browse(entry.link.replace("/commit/", "/tree/"));
    }
}

