/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.SettingCellRenderer;
import com.gitblit.client.SettingPanel;
import com.gitblit.client.SettingsTableModel;
import com.gitblit.client.Translation;
import com.gitblit.client.UsersTableModel;
import com.gitblit.client.Utils;
import com.gitblit.models.SettingModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private HeaderPanel header;
    private JTable table;
    private SettingsTableModel tableModel;
    private TableRowSorter<SettingsTableModel> defaultSorter;
    private JTextField filterTextfield;

    public SettingsPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        JButton refreshSettings = new JButton(Translation.get("gb.refresh"));
        refreshSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.refreshSettings();
            }
        });
        final JButton editSetting = new JButton(Translation.get("gb.edit"));
        editSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int viewRow = SettingsPanel.this.table.getSelectedRow();
                int modelRow = SettingsPanel.this.table.convertRowIndexToModel(viewRow);
                String key = ((SettingsPanel)SettingsPanel.this).tableModel.keys.get(modelRow);
                SettingModel setting = ((SettingsPanel)SettingsPanel.this).tableModel.settings.get(key);
                SettingsPanel.this.editSetting(setting);
            }
        });
        NameRenderer nameRenderer = new NameRenderer();
        final SettingPanel settingPanel = new SettingPanel();
        this.tableModel = new SettingsTableModel();
        this.defaultSorter = new TableRowSorter<SettingsTableModel>(this.tableModel);
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        this.table.setDefaultRenderer(SettingModel.class, new SettingCellRenderer());
        String name = this.table.getColumnName(UsersTableModel.Columns.Name.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        this.table.setRowSorter(this.defaultSorter);
        this.table.getRowSorter().toggleSortOrder(SettingsTableModel.Columns.Name.ordinal());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean singleSelection = SettingsPanel.this.table.getSelectedRows().length == 1;
                editSetting.setEnabled(singleSelection);
                if (singleSelection) {
                    int viewRow = SettingsPanel.this.table.getSelectedRow();
                    int modelRow = SettingsPanel.this.table.convertRowIndexToModel(viewRow);
                    SettingModel setting = SettingsPanel.this.tableModel.get(modelRow);
                    settingPanel.setSetting(setting);
                } else {
                    settingPanel.clear();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int viewRow = SettingsPanel.this.table.getSelectedRow();
                    int modelRow = SettingsPanel.this.table.convertRowIndexToModel(viewRow);
                    SettingModel setting = SettingsPanel.this.tableModel.get(modelRow);
                    SettingsPanel.this.editSetting(setting);
                }
            }
        });
        this.filterTextfield = new JTextField();
        this.filterTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.filterSettings(SettingsPanel.this.filterTextfield.getText());
            }
        });
        this.filterTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SettingsPanel.this.filterSettings(SettingsPanel.this.filterTextfield.getText());
            }
        });
        JPanel settingFilterPanel = new JPanel(new BorderLayout(5, 5));
        settingFilterPanel.add((Component)new JLabel(Translation.get("gb.filter")), "West");
        settingFilterPanel.add((Component)this.filterTextfield, "Center");
        JPanel settingsTablePanel = new JPanel(new BorderLayout(5, 5));
        settingsTablePanel.add((Component)settingFilterPanel, "North");
        settingsTablePanel.add((Component)new JScrollPane(this.table), "Center");
        settingsTablePanel.add((Component)settingPanel, "South");
        JPanel settingsControls = new JPanel(new FlowLayout(1, 5, 0));
        settingsControls.add(refreshSettings);
        settingsControls.add(editSetting);
        this.setLayout(new BorderLayout(5, 5));
        this.header = new HeaderPanel(Translation.get("gb.settings"), "settings_16x16.png");
        this.add((Component)this.header, "North");
        this.add((Component)settingsTablePanel, "Center");
        this.add((Component)settingsControls, "South");
    }

    @Override
    public void requestFocus() {
        this.filterTextfield.requestFocus();
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    protected void updateTable(boolean pack) {
        this.tableModel.setSettings(this.gitblit.getSettings());
        this.tableModel.fireTableDataChanged();
        this.header.setText(Translation.get("gb.settings"));
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
    }

    private void filterSettings(final String fragment) {
        if (StringUtils.isEmpty(fragment)) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        RowFilter<SettingsTableModel, Object> containsFilter = new RowFilter<SettingsTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SettingsTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(fragment.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
        TableRowSorter<SettingsTableModel> sorter = new TableRowSorter<SettingsTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }

    protected void refreshSettings() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.LIST_SETTINGS){

            @Override
            protected Boolean doRequest() throws IOException {
                SettingsPanel.this.gitblit.refreshSettings();
                return true;
            }

            @Override
            protected void onSuccess() {
                SettingsPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void editSetting(SettingModel settingModel) {
        JTextField textField = new JTextField(settingModel.currentValue);
        JPanel editPanel = new JPanel(new GridLayout(0, 1));
        editPanel.add(new JLabel("New Value"));
        editPanel.add(textField);
        JPanel settingPanel = new JPanel(new BorderLayout());
        settingPanel.add((Component)new SettingPanel(settingModel), "Center");
        settingPanel.add((Component)editPanel, "South");
        settingPanel.setPreferredSize(new Dimension(800, 200));
        Object[] options = settingModel.currentValue.equals(settingModel.defaultValue) ? new String[]{Translation.get("gb.cancel"), Translation.get("gb.save")} : new String[]{Translation.get("gb.cancel"), Translation.get("gb.setDefault"), Translation.get("gb.save")};
        String defaultOption = options[0];
        int selection = JOptionPane.showOptionDialog(this, settingPanel, settingModel.name, 0, 3, new ImageIcon(this.getClass().getResource("/settings_16x16.png")), options, defaultOption);
        if (selection <= 0) {
            return;
        }
        if (((String)options[selection]).equals(Translation.get("gb.setDefault"))) {
            textField.setText(settingModel.defaultValue);
        }
        final HashMap<String, String> newSettings = new HashMap<String, String>();
        newSettings.put(settingModel.name, textField.getText().trim());
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.EDIT_SETTINGS){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = SettingsPanel.this.gitblit.updateSettings(newSettings);
                if (success) {
                    SettingsPanel.this.gitblit.refreshSettings();
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                SettingsPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }
}

