/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.Translation;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.SettingModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SettingsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ServerSettings settings;
    List<String> keys;

    public SettingsTableModel() {
        this(null);
    }

    public SettingsTableModel(ServerSettings settings) {
        this.setSettings(settings);
    }

    public void setSettings(ServerSettings settings) {
        this.settings = settings;
        if (settings == null) {
            this.keys = new ArrayList<String>();
        } else {
            this.keys = new ArrayList<String>(settings.getKeys());
            Collections.sort(this.keys);
        }
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int column) {
        Columns col = Columns.values()[column];
        switch (col) {
            case Name: {
                return Translation.get("gb.name");
            }
            case Since: {
                return Translation.get("gb.since");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (Columns.Value.ordinal() == columnIndex) {
            return SettingModel.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String key = this.keys.get(rowIndex);
        SettingModel setting = this.settings.get(key);
        Columns col = Columns.values()[columnIndex];
        switch (col) {
            case Name: {
                return key;
            }
            case Value: {
                return setting;
            }
            case Since: {
                return setting.since;
            }
        }
        return null;
    }

    public SettingModel get(int modelRow) {
        String key = this.keys.get(modelRow);
        return this.settings.get(key);
    }

    static enum Columns {
        Name,
        Value,
        Since;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

