/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.PropertiesTableModel;
import com.gitblit.client.Translation;
import com.gitblit.client.Utils;
import com.gitblit.models.ServerStatus;
import com.gitblit.utils.ByteFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class StatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private JLabel bootDate;
    private JLabel url;
    private JLabel servletContainer;
    private JLabel heapMaximum;
    private JLabel heapAllocated;
    private JLabel heapUsed;
    private PropertiesTableModel tableModel;
    private HeaderPanel header;
    private JLabel version;
    private JLabel releaseDate;

    public StatusPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        JButton refreshStatus = new JButton(Translation.get("gb.refresh"));
        refreshStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.refreshStatus();
            }
        });
        this.version = new JLabel();
        this.releaseDate = new JLabel();
        this.bootDate = new JLabel();
        this.url = new JLabel();
        this.servletContainer = new JLabel();
        this.heapMaximum = new JLabel();
        this.heapAllocated = new JLabel();
        this.heapUsed = new JLabel();
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1, 0, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return Utils.INSETS;
            }
        };
        fieldsPanel.add(this.createFieldPanel("gb.version", this.version));
        fieldsPanel.add(this.createFieldPanel("gb.releaseDate", this.releaseDate));
        fieldsPanel.add(this.createFieldPanel("gb.bootDate", this.bootDate));
        fieldsPanel.add(this.createFieldPanel("gb.url", this.url));
        fieldsPanel.add(this.createFieldPanel("gb.servletContainer", this.servletContainer));
        fieldsPanel.add(this.createFieldPanel("gb.heapUsed", this.heapUsed));
        fieldsPanel.add(this.createFieldPanel("gb.heapAllocated", this.heapAllocated));
        fieldsPanel.add(this.createFieldPanel("gb.heapMaximum", this.heapMaximum));
        this.tableModel = new PropertiesTableModel();
        JTable propertiesTable = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        String name = propertiesTable.getColumnName(PropertiesTableModel.Columns.Name.ordinal());
        NameRenderer nameRenderer = new NameRenderer();
        propertiesTable.getColumn(name).setCellRenderer(nameRenderer);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldsPanel, "North");
        centerPanel.add((Component)new JScrollPane(propertiesTable), "Center");
        JPanel controls = new JPanel(new FlowLayout(1, 5, 0));
        controls.add(refreshStatus);
        this.header = new HeaderPanel(Translation.get("gb.status"), "health_16x16.png");
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.header, "North");
        this.add((Component)centerPanel, "Center");
        this.add((Component)controls, "South");
    }

    private JPanel createFieldPanel(String key, JLabel valueLabel) {
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        JLabel textLabel = new JLabel(Translation.get(key));
        textLabel.setFont(textLabel.getFont().deriveFont(1));
        textLabel.setPreferredSize(new Dimension(120, 10));
        panel.add(textLabel);
        panel.add(valueLabel);
        return panel;
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    protected void refreshStatus() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.LIST_STATUS){

            @Override
            protected Boolean doRequest() throws IOException {
                StatusPanel.this.gitblit.refreshStatus();
                return true;
            }

            @Override
            protected void onSuccess() {
                StatusPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void updateTable(boolean pack) {
        ServerStatus status = this.gitblit.getStatus();
        this.header.setText(Translation.get("gb.status"));
        this.version.setText("Gitblit" + (status.isGO ? " GO v" : " WAR v") + status.version);
        this.releaseDate.setText(status.releaseDate);
        this.bootDate.setText(status.bootDate.toString() + " (" + Translation.getTimeUtils().timeAgo(status.bootDate) + ")");
        this.url.setText(this.gitblit.url);
        this.servletContainer.setText(status.servletContainer);
        ByteFormat byteFormat = new ByteFormat();
        this.heapMaximum.setText(byteFormat.format(status.heapMaximum));
        this.heapAllocated.setText(byteFormat.format(status.heapAllocated));
        this.heapUsed.setText(byteFormat.format(status.heapAllocated - status.heapFree) + " (" + byteFormat.format(status.heapFree) + " " + Translation.get("gb.free") + ")");
        this.tableModel.setProperties(status.systemProperties);
        this.tableModel.fireTableDataChanged();
    }
}

