/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.client.GitblitClient;
import com.gitblit.client.NameRenderer;
import com.gitblit.models.RepositoryModel;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class SubscribedRepositoryRenderer
extends NameRenderer {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private final ImageIcon blankIcon;
    private final ImageIcon subscribedIcon;

    public SubscribedRepositoryRenderer(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.blankIcon = new ImageIcon(this.getClass().getResource("/blank.png"));
        this.subscribedIcon = new ImageIcon(this.getClass().getResource("/bullet_feed.png"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof RepositoryModel) {
            RepositoryModel model = (RepositoryModel)value;
            if (this.gitblit.isSubscribed(model)) {
                this.setIcon(this.subscribedIcon);
            } else {
                this.setIcon(this.blankIcon);
            }
        }
        return this;
    }
}

