/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.EditUserDialog;
import com.gitblit.client.GitblitClient;
import com.gitblit.client.GitblitWorker;
import com.gitblit.client.HeaderPanel;
import com.gitblit.client.NameRenderer;
import com.gitblit.client.Translation;
import com.gitblit.client.UsersTableModel;
import com.gitblit.client.Utils;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public abstract class UsersPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GitblitClient gitblit;
    private HeaderPanel header;
    private JTable table;
    private UsersTableModel tableModel;
    private TableRowSorter<UsersTableModel> defaultSorter;
    private JTextField filterTextfield;

    public UsersPanel(GitblitClient gitblit) {
        this.gitblit = gitblit;
        this.initialize();
    }

    private void initialize() {
        JButton refreshUsers = new JButton(Translation.get("gb.refresh"));
        refreshUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.refreshUsers();
            }
        });
        JButton createUser = new JButton(Translation.get("gb.create"));
        createUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.createUser();
            }
        });
        final JButton editUser = new JButton(Translation.get("gb.edit"));
        editUser.setEnabled(false);
        editUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.editUser((UserModel)UsersPanel.this.getSelectedUsers().get(0));
            }
        });
        final JButton delUser = new JButton(Translation.get("gb.delete"));
        delUser.setEnabled(false);
        delUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.deleteUsers(UsersPanel.this.getSelectedUsers());
            }
        });
        NameRenderer nameRenderer = new NameRenderer();
        this.tableModel = new UsersTableModel();
        this.defaultSorter = new TableRowSorter<UsersTableModel>(this.tableModel);
        this.table = Utils.newTable(this.tableModel, "yyyy-MM-dd");
        String name = this.table.getColumnName(UsersTableModel.Columns.Name.ordinal());
        this.table.getColumn(name).setCellRenderer(nameRenderer);
        int w = 130;
        name = this.table.getColumnName(UsersTableModel.Columns.Type.ordinal());
        this.table.getColumn(name).setMinWidth(w);
        this.table.getColumn(name).setMaxWidth(w);
        name = this.table.getColumnName(UsersTableModel.Columns.Teams.ordinal());
        this.table.getColumn(name).setMinWidth(w);
        this.table.getColumn(name).setMaxWidth(w);
        name = this.table.getColumnName(UsersTableModel.Columns.Repositories.ordinal());
        this.table.getColumn(name).setMinWidth(w);
        this.table.getColumn(name).setMaxWidth(w);
        this.table.setRowSorter(this.defaultSorter);
        this.table.getRowSorter().toggleSortOrder(UsersTableModel.Columns.Name.ordinal());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean selected = UsersPanel.this.table.getSelectedRow() > -1;
                boolean singleSelection = UsersPanel.this.table.getSelectedRows().length == 1;
                editUser.setEnabled(singleSelection && selected);
                delUser.setEnabled(selected);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UsersPanel.this.editUser((UserModel)UsersPanel.this.getSelectedUsers().get(0));
                }
            }
        });
        this.filterTextfield = new JTextField();
        this.filterTextfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.filterUsers(UsersPanel.this.filterTextfield.getText());
            }
        });
        this.filterTextfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UsersPanel.this.filterUsers(UsersPanel.this.filterTextfield.getText());
            }
        });
        JPanel userFilterPanel = new JPanel(new BorderLayout(5, 5));
        userFilterPanel.add((Component)new JLabel(Translation.get("gb.filter")), "West");
        userFilterPanel.add((Component)this.filterTextfield, "Center");
        JPanel userTablePanel = new JPanel(new BorderLayout(5, 5));
        userTablePanel.add((Component)userFilterPanel, "North");
        userTablePanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel userControls = new JPanel(new FlowLayout(1, 5, 0));
        userControls.add(refreshUsers);
        userControls.add(createUser);
        userControls.add(editUser);
        userControls.add(delUser);
        this.setLayout(new BorderLayout(5, 5));
        this.header = new HeaderPanel(Translation.get("gb.users"), "user_16x16.png");
        this.add((Component)this.header, "North");
        this.add((Component)userTablePanel, "Center");
        this.add((Component)userControls, "South");
    }

    @Override
    public void requestFocus() {
        this.filterTextfield.requestFocus();
    }

    @Override
    public Insets getInsets() {
        return Utils.INSETS;
    }

    protected abstract void updateTeamsTable();

    protected void updateTable(boolean pack) {
        this.tableModel.list.clear();
        this.tableModel.list.addAll(this.gitblit.getUsers());
        this.tableModel.fireTableDataChanged();
        this.header.setText(Translation.get("gb.users") + " (" + this.gitblit.getUsers().size() + ")");
        if (pack) {
            Utils.packColumns(this.table, 5);
        }
    }

    private void filterUsers(final String fragment) {
        if (StringUtils.isEmpty(fragment)) {
            this.table.setRowSorter(this.defaultSorter);
            return;
        }
        RowFilter<UsersTableModel, Object> containsFilter = new RowFilter<UsersTableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends UsersTableModel, ? extends Object> entry) {
                for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                    if (!entry.getStringValue(i).toLowerCase().contains(fragment.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
        TableRowSorter<UsersTableModel> sorter = new TableRowSorter<UsersTableModel>(this.tableModel);
        sorter.setRowFilter(containsFilter);
        this.table.setRowSorter(sorter);
    }

    private List<UserModel> getSelectedUsers() {
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (int viewRow : this.table.getSelectedRows()) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            UserModel model = this.tableModel.list.get(modelRow);
            users.add(model);
        }
        return users;
    }

    protected void refreshUsers() {
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.LIST_USERS){

            @Override
            protected Boolean doRequest() throws IOException {
                UsersPanel.this.gitblit.refreshUsers();
                return true;
            }

            @Override
            protected void onSuccess() {
                UsersPanel.this.updateTable(false);
            }
        };
        worker.execute();
    }

    protected void createUser() {
        EditUserDialog dialog = new EditUserDialog(this.gitblit.getProtocolVersion(), this.gitblit.getSettings());
        dialog.setLocationRelativeTo(this);
        dialog.setUsers(this.gitblit.getUsers());
        dialog.setRepositories(this.gitblit.getRepositories(), null);
        dialog.setTeams(this.gitblit.getTeams(), null);
        dialog.setVisible(true);
        final UserModel newUser = dialog.getUser();
        if (newUser == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.CREATE_USER){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = UsersPanel.this.gitblit.createUser(newUser);
                if (success) {
                    UsersPanel.this.gitblit.refreshUsers();
                    if (newUser.teams.size() > 0) {
                        UsersPanel.this.gitblit.refreshTeams();
                    }
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                UsersPanel.this.updateTable(false);
                if (newUser.teams.size() > 0) {
                    UsersPanel.this.updateTeamsTable();
                }
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for user \"{1}\".", new Object[]{this.getRequestType(), newUser.username});
            }
        };
        worker.execute();
    }

    protected void editUser(final UserModel user) {
        EditUserDialog dialog = new EditUserDialog(this.gitblit.getProtocolVersion(), user, this.gitblit.getSettings());
        dialog.setLocationRelativeTo(this);
        dialog.setUsers(this.gitblit.getUsers());
        dialog.setRepositories(this.gitblit.getRepositories(), this.gitblit.getUserAccessPermissions(user));
        dialog.setTeams(this.gitblit.getTeams(), (List<TeamModel>)(user.teams == null ? null : new ArrayList<TeamModel>(user.teams)));
        dialog.setVisible(true);
        final UserModel revisedUser = dialog.getUser();
        if (revisedUser == null) {
            return;
        }
        GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.EDIT_USER){

            @Override
            protected Boolean doRequest() throws IOException {
                boolean success = UsersPanel.this.gitblit.updateUser(user.username, revisedUser);
                if (success) {
                    UsersPanel.this.gitblit.refreshUsers();
                    UsersPanel.this.gitblit.refreshTeams();
                }
                return success;
            }

            @Override
            protected void onSuccess() {
                UsersPanel.this.updateTable(false);
                UsersPanel.this.updateTeamsTable();
            }

            @Override
            protected void onFailure() {
                this.showFailure("Failed to execute request \"{0}\" for user \"{1}\".", new Object[]{this.getRequestType(), user.username});
            }
        };
        worker.execute();
    }

    protected void deleteUsers(final List<UserModel> users) {
        if (users == null || users.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder("Delete the following users?\n\n");
        for (UserModel user : users) {
            message.append(user.username).append("\n");
        }
        int result = JOptionPane.showConfirmDialog(this, message.toString(), "Delete Users?", 0);
        if (result == 0) {
            GitblitWorker worker = new GitblitWorker(this, Constants.RpcRequest.DELETE_USER){

                @Override
                protected Boolean doRequest() throws IOException {
                    boolean success = true;
                    for (UserModel user : users) {
                        success &= UsersPanel.this.gitblit.deleteUser(user);
                    }
                    if (success) {
                        UsersPanel.this.gitblit.refreshUsers();
                        UsersPanel.this.gitblit.refreshTeams();
                    }
                    return success;
                }

                @Override
                protected void onSuccess() {
                    UsersPanel.this.updateTable(false);
                    UsersPanel.this.updateTeamsTable();
                }

                @Override
                protected void onFailure() {
                    this.showFailure("Failed to delete specified users!", new Object[0]);
                }
            };
            worker.execute();
        }
    }
}

