/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.client;

import com.gitblit.Constants;
import com.gitblit.client.DateCellRenderer;
import com.gitblit.client.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Utils {
    public static final int MARGIN = 5;
    public static final Insets INSETS = new Insets(5, 5, 5, 5);
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static JTable newTable(TableModel model, String datePattern) {
        return Utils.newTable(model, datePattern, null);
    }

    public static JTable newTable(TableModel model, String datePattern, final RowRenderer rowRenderer) {
        JTable table = rowRenderer == null ? new JTable(model) : new JTable(model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                boolean isSelected = this.isCellSelected(row, column);
                rowRenderer.prepareRow(c, isSelected, row, column);
                return c;
            }
        };
        table.setRowHeight(table.getFont().getSize() + 8);
        table.setCellSelectionEnabled(false);
        table.setRowSelectionAllowed(true);
        table.getTableHeader().setReorderingAllowed(false);
        table.setGridColor(new Color(0xD9D9D9));
        table.setBackground(Color.white);
        table.setDefaultRenderer(Date.class, new DateCellRenderer(datePattern, Color.orange.darker()));
        return table;
    }

    public static void explainNotAllowed(Component c, Constants.RpcRequest request) {
        String msg = MessageFormat.format("The Gitblit server does not allow the request \"{0}\".", request.name());
        JOptionPane.showMessageDialog(c, msg, "Not Allowed", 0);
    }

    public static void explainForbidden(Component c, Constants.RpcRequest request) {
        String msg = MessageFormat.format("The request \"{0}\" has been forbidden for the account by the Gitblit server.", request.name());
        JOptionPane.showMessageDialog(c, msg, "Forbidden", 0);
    }

    public static void explainUnauthorized(Component c, Constants.RpcRequest request) {
        String msg = MessageFormat.format("This account is not authorized to execute the request \"{0}\".", request.name());
        JOptionPane.showMessageDialog(c, msg, "Unauthorized", 0);
    }

    public static void explainUnknown(Component c, Constants.RpcRequest request) {
        String msg = MessageFormat.format("The request \"{0}\" is not recognized by the Gitblit server.", request.name());
        JOptionPane.showMessageDialog(c, msg, "Unknown Request", 0);
    }

    public static void showException(Component c, Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String stacktrace = writer.toString();
        try {
            writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JTextArea textArea = new JTextArea(stacktrace);
        textArea.setFont(new Font("monospaced", 0, 11));
        JScrollPane jsp = new JScrollPane(textArea);
        jsp.setPreferredSize(new Dimension(800, 400));
        JOptionPane.showMessageDialog(c, jsp, Translation.get("gb.error"), 0);
    }

    public static void packColumns(JTable table, int margin) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            Utils.packColumn(table, c, 4);
        }
    }

    private static void packColumn(JTable table, int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public static void browse(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception x) {
            Utils.showException(null, x);
        }
    }

    public static abstract class RowRenderer {
        public abstract void prepareRow(Component var1, boolean var2, int var3, int var4);
    }
}

