/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.fanout;

import com.gitblit.fanout.FanoutConstants;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanoutClient
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FanoutClient.class);
    private final int clientTimeout = 500;
    private final int reconnectTimeout = 2000;
    private final String host;
    private final int port;
    private final List<FanoutListener> listeners;
    private String id;
    private volatile Selector selector;
    private volatile SocketChannel socketCh;
    private Thread clientThread;
    private final AtomicBoolean isConnected;
    private final AtomicBoolean isRunning;
    private final AtomicBoolean isAutomaticReconnect;
    private final ByteBuffer writeBuffer;
    private final ByteBuffer readBuffer;
    private final CharsetDecoder decoder;
    private final Set<String> subscriptions;
    private boolean resubscribe;

    public static void main(String[] args) throws Exception {
        FanoutClient client = new FanoutClient("localhost", 2000);
        client.addListener(new FanoutAdapter(){

            @Override
            public void pong(Date timestamp) {
                System.out.println("Pong. " + timestamp);
            }

            @Override
            public void announcement(String channel, String message) {
                System.out.println(MessageFormat.format("Here ye, Here ye. {0} says {1}", channel, message));
            }
        });
        client.start();
        Thread.sleep(5000L);
        client.ping();
        client.subscribe("james");
        client.announce("james", "12345");
        client.subscribe("c52f99d16eb5627877ae957df7ce1be102783bd5");
        while (true) {
            Thread.sleep(10000L);
            client.ping();
        }
    }

    public FanoutClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.readBuffer = ByteBuffer.allocateDirect(512);
        this.writeBuffer = ByteBuffer.allocateDirect(512);
        this.decoder = Charset.forName("ISO-8859-1").newDecoder();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.subscriptions = new LinkedHashSet<String>();
        this.isRunning = new AtomicBoolean(false);
        this.isConnected = new AtomicBoolean(false);
        this.isAutomaticReconnect = new AtomicBoolean(true);
    }

    public void addListener(FanoutListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FanoutListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isAutomaticReconnect() {
        return this.isAutomaticReconnect.get();
    }

    public void setAutomaticReconnect(boolean value) {
        this.isAutomaticReconnect.set(value);
    }

    public void ping() {
        this.confirmConnection();
        this.write("ping");
    }

    public void status() {
        this.confirmConnection();
        this.write("status");
    }

    public void subscribe(String channel) {
        this.confirmConnection();
        if (this.subscriptions.add(channel)) {
            this.write("subscribe " + channel);
        }
    }

    public void unsubscribe(String channel) {
        this.confirmConnection();
        if (this.subscriptions.remove(channel)) {
            this.write("unsubscribe " + channel);
        }
    }

    public void announce(String channel, String message) {
        this.confirmConnection();
        this.write("announce " + channel + " " + message);
    }

    private void confirmConnection() {
        if (!this.isConnected()) {
            throw new RuntimeException("Fanout client is disconnected!");
        }
    }

    public boolean isConnected() {
        return this.isRunning.get() && this.socketCh != null && this.isConnected.get();
    }

    public void start() {
        if (this.isRunning.get()) {
            logger.warn("Fanout client is already running");
            return;
        }
        this.clientThread = new Thread((Runnable)this, "Fanout client");
        this.clientThread.start();
    }

    public void startSynchronously() {
        this.start();
        while (!this.isConnected()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void stop() {
        if (!this.isRunning.get()) {
            logger.warn("Fanout client is not running");
            return;
        }
        this.isRunning.set(false);
        try {
            if (this.clientThread != null) {
                this.clientThread.join();
                this.clientThread = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.resetState();
        this.isRunning.set(true);
        while (this.isRunning.get()) {
            if (this.socketCh == null) {
                try {
                    InetAddress addr = InetAddress.getByName(this.host);
                    this.socketCh = SocketChannel.open(new InetSocketAddress(addr, this.port));
                    this.socketCh.configureBlocking(false);
                    this.selector = Selector.open();
                    this.id = FanoutConstants.getLocalSocketId(this.socketCh.socket());
                    this.socketCh.register(this.selector, 1);
                }
                catch (Exception e) {
                    logger.error(MessageFormat.format("failed to open client connection to {0}:{1,number,0}", this.host, this.port), (Throwable)e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
            }
            try {
                this.selector.select(500L);
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    if (key.isReadable()) {
                        String[] lines;
                        String content = this.read();
                        for (String reply : lines = content.split("\n")) {
                            logger.trace(MessageFormat.format("fanout client {0} received: {1}", this.id, reply));
                            if (this.processReply(reply)) continue;
                            logger.error(MessageFormat.format("fanout client {0} received unknown message", this.id));
                        }
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    if (this.resubscribe) {
                        this.resubscribe = false;
                        logger.info(MessageFormat.format("fanout client {0} re-subscribing to {1} channels", this.id, this.subscriptions.size()));
                        for (String subscription : this.subscriptions) {
                            this.write("subscribe " + subscription);
                        }
                    }
                    this.socketCh.register(this.selector, 1);
                }
            }
            catch (IOException e) {
                logger.error(MessageFormat.format("fanout client {0} error: {1}", this.id, e.getMessage()));
                this.closeChannel();
                if (this.isAutomaticReconnect.get()) continue;
                this.isRunning.set(false);
            }
        }
        this.closeChannel();
        this.resetState();
    }

    protected void resetState() {
        this.readBuffer.clear();
        this.writeBuffer.clear();
        this.isRunning.set(false);
        this.isConnected.set(false);
    }

    private void closeChannel() {
        try {
            if (this.socketCh != null) {
                this.socketCh.close();
                this.socketCh = null;
                this.selector.close();
                this.selector = null;
                this.isConnected.set(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean processReply(String reply) {
        String[] fields = reply.split("!", 2);
        if (fields.length == 1) {
            try {
                long time = Long.parseLong(fields[0]);
                Date date = new Date(time);
                this.firePong(date);
            }
            catch (Exception time) {
                // empty catch block
            }
            return true;
        }
        if (fields.length == 2) {
            String channel = fields[0];
            String message = fields[1];
            if ("debug".equals(channel)) {
                if ("connected...".equals(message)) {
                    this.isConnected.set(true);
                    boolean bl = this.resubscribe = this.subscriptions.size() > 0;
                    if (this.resubscribe) {
                        try {
                            this.socketCh.register(this.selector, 4);
                        }
                        catch (Exception e) {
                            logger.error("an error occurred", (Throwable)e);
                        }
                    }
                }
                logger.debug(MessageFormat.format("fanout client {0} < {1}", this.id, reply));
            } else {
                this.fireAnnouncement(channel, message);
            }
            return true;
        }
        return false;
    }

    protected void firePong(Date timestamp) {
        logger.info(MessageFormat.format("fanout client {0} < pong {1,date,yyyy-MM-dd HH:mm:ss}", this.id, timestamp));
        for (FanoutListener listener : this.listeners) {
            try {
                listener.pong(timestamp);
            }
            catch (Throwable t) {
                logger.error("FanoutListener threw an exception!", t);
            }
        }
    }

    protected void fireAnnouncement(String channel, String message) {
        logger.info(MessageFormat.format("fanout client {0} < announcement {1} {2}", this.id, channel, message));
        for (FanoutListener listener : this.listeners) {
            try {
                listener.announcement(channel, message);
            }
            catch (Throwable t) {
                logger.error("FanoutListener threw an exception!", t);
            }
        }
    }

    protected synchronized String read() throws IOException {
        this.readBuffer.clear();
        long len = this.socketCh.read(this.readBuffer);
        if (len == -1L) {
            logger.error(MessageFormat.format("fanout client {0} lost connection to {1}:{2,number,0}, end of stream", this.id, this.host, this.port));
            this.socketCh.close();
            return null;
        }
        this.readBuffer.flip();
        String content = this.decoder.decode(this.readBuffer).toString();
        this.readBuffer.clear();
        return content;
    }

    protected synchronized boolean write(String message) {
        try {
            logger.info(MessageFormat.format("fanout client {0} > {1}", this.id, message));
            byte[] bytes = message.getBytes("ISO-8859-1");
            this.writeBuffer.clear();
            this.writeBuffer.put(bytes);
            if (bytes[bytes.length - 1] != 10) {
                this.writeBuffer.put((byte)10);
            }
            this.writeBuffer.flip();
            long written = 0L;
            long toWrite = this.writeBuffer.remaining();
            while (written != toWrite) {
                written += (long)this.socketCh.write(this.writeBuffer);
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (IOException e) {
            logger.error("fanout client {0} error: {1}", (Object)this.id, (Object)e.getMessage());
            return false;
        }
    }

    public static class FanoutAdapter
    implements FanoutListener {
        @Override
        public void pong(Date timestamp) {
        }

        @Override
        public void announcement(String channel, String message) {
        }
    }

    public static interface FanoutListener {
        public void pong(Date var1);

        public void announcement(String var1, String var2);
    }
}

