/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.fanout;

import com.gitblit.fanout.FanoutConstants;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FanoutServiceConnection
implements Comparable<FanoutServiceConnection> {
    private static final Logger logger = LoggerFactory.getLogger(FanoutServiceConnection.class);
    public final String id;

    protected FanoutServiceConnection(Socket socket) {
        this.id = FanoutConstants.getRemoteSocketId(socket);
    }

    protected abstract void reply(String var1) throws IOException;

    protected void connected() {
        this.reply("debug", "connected...");
    }

    protected void busy() {
        this.reply("debug", "busy");
    }

    protected String reply(String channel, String message) {
        String content = channel != null ? channel + "!" + message : message;
        try {
            this.reply(content);
        }
        catch (Exception e) {
            logger.error("failed to reply to fanout connection " + this.id, (Throwable)e);
        }
        return content;
    }

    @Override
    public int compareTo(FanoutServiceConnection c) {
        return this.id.compareTo(c.id);
    }

    public boolean equals(Object o) {
        if (o instanceof FanoutServiceConnection) {
            return this.id.equals(((FanoutServiceConnection)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

