/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.fanout;

import com.gitblit.fanout.FanoutService;
import com.gitblit.fanout.FanoutServiceConnection;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanoutSocketService
extends FanoutService {
    private static final Logger logger = LoggerFactory.getLogger(FanoutSocketService.class);
    private volatile ServerSocket serviceSocket;

    public static void main(String[] args) throws Exception {
        FanoutSocketService pubsub = new FanoutSocketService(null, 17000);
        pubsub.setStrictRequestTermination(false);
        pubsub.setAllowAllChannelAnnouncements(false);
        pubsub.start();
    }

    public FanoutSocketService(int port) {
        this(null, port);
    }

    public FanoutSocketService(String bindInterface, int port) {
        super(bindInterface, port, "Fanout socket service");
    }

    @Override
    protected boolean isConnected() {
        return this.serviceSocket != null;
    }

    @Override
    protected boolean connect() {
        if (this.serviceSocket == null) {
            try {
                this.serviceSocket = new ServerSocket();
                this.serviceSocket.setReuseAddress(true);
                this.serviceSocket.setSoTimeout(5000);
                this.serviceSocket.bind(this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port));
                logger.info(MessageFormat.format("{0} is ready on {1}:{2,number,0}", this.name, this.host == null ? "0.0.0.0" : this.host, this.serviceSocket.getLocalPort()));
            }
            catch (IOException e) {
                logger.error(MessageFormat.format("failed to open {0} on {1}:{2,number,0}", this.name, this.host == null ? "0.0.0.0" : this.host, this.port), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void disconnect() {
        try {
            if (this.serviceSocket != null) {
                logger.debug(MessageFormat.format("closing {0} server socket", this.name));
                this.serviceSocket.close();
                this.serviceSocket = null;
            }
        }
        catch (IOException e) {
            logger.error(MessageFormat.format("failed to disconnect {0}", this.name), (Throwable)e);
        }
    }

    @Override
    protected void listen() throws IOException {
        try {
            Socket socket = this.serviceSocket.accept();
            this.configureClientSocket(socket);
            FanoutSocketConnection connection = new FanoutSocketConnection(socket);
            if (this.addConnection(connection)) {
                Thread connectionThread = new Thread(connection);
                connectionThread.setDaemon(true);
                connectionThread.setName("Fanout " + connection.id);
                connectionThread.start();
            } else {
                this.removeConnection(connection);
                connection.closeConnection();
                Object var2_3 = null;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    class FanoutSocketConnection
    extends FanoutServiceConnection
    implements Runnable {
        Socket socket;

        FanoutSocketConnection(Socket socket) {
            super(socket);
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedInputStream is = new BufferedInputStream(this.socket.getInputStream());
                byte[] buffer = new byte[512];
                int len = 0;
                block5: while (true) {
                    if (is.available() > 0) {
                        len = is.read(buffer);
                        int i = 0;
                        while (true) {
                            if (i >= len) continue block5;
                            byte b = buffer[i];
                            if (b == 10 || !FanoutSocketService.this.isStrictRequestTermination() && b == 13) {
                                String req = sb.toString();
                                sb.setLength(0);
                                if (req.length() > 0) {
                                    FanoutSocketService.this.processRequest(this, req);
                                }
                            } else {
                                sb.append((char)b);
                            }
                            ++i;
                        }
                    }
                    if (!FanoutSocketService.this.isRunning.get()) {
                        break;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Throwable t) {
                if (t instanceof SocketException) {
                    logger.error(MessageFormat.format("fanout connection {0}: {1}", this.id, t.getMessage()));
                } else if (t instanceof SocketTimeoutException) {
                    logger.error(MessageFormat.format("fanout connection {0}: {1}", this.id, t.getMessage()));
                } else {
                    logger.error(MessageFormat.format("exception while handling fanout connection {0}", this.id), t);
                }
            }
            finally {
                this.closeConnection();
            }
            logger.info(MessageFormat.format("thread for fanout connection {0} is finished", this.id));
        }

        @Override
        protected void reply(String content) throws IOException {
            logger.debug(MessageFormat.format("fanout reply to {0}: {1}", this.id, content));
            OutputStream os = this.socket.getOutputStream();
            byte[] bytes = content.getBytes("ISO-8859-1");
            os.write(bytes);
            if (bytes[bytes.length - 1] != 10) {
                os.write(10);
            }
            os.flush();
        }

        protected void closeConnection() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            FanoutSocketService.this.removeConnection(this);
        }
    }
}

