/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.git;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.git.GitblitReceivePack;
import com.gitblit.git.PatchsetReceivePack;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.transport.git.GitDaemonClient;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitblitReceivePackFactory<X>
implements ReceivePackFactory<X> {
    protected final Logger logger = LoggerFactory.getLogger(GitblitReceivePackFactory.class);
    private final IStoredSettings settings;
    private final IGitblit gitblit;

    public GitblitReceivePackFactory(IGitblit gitblit) {
        this.settings = gitblit.getSettings();
        this.gitblit = gitblit;
    }

    public ReceivePack create(X req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        Object client;
        UserModel user = UserModel.ANONYMOUS;
        String repositoryName = "";
        String origin = "";
        String gitblitUrl = "";
        int timeout = 0;
        Constants.Transport transport = null;
        if (req instanceof HttpServletRequest) {
            UserModel u;
            client = (HttpServletRequest)req;
            repositoryName = client.getAttribute("gitblitRepositoryName").toString();
            origin = client.getRemoteHost();
            gitblitUrl = HttpUtils.getGitblitURL((HttpServletRequest)client);
            String username = client.getRemoteUser();
            if (!StringUtils.isEmpty(username) && (u = this.gitblit.getUserModel(username)) != null) {
                user = u;
            }
            if ("http".equals(client.getScheme())) {
                transport = Constants.Transport.HTTP;
            } else if ("https".equals(client.getScheme())) {
                transport = Constants.Transport.HTTPS;
            }
        } else if (req instanceof GitDaemonClient) {
            client = (GitDaemonClient)req;
            repositoryName = ((GitDaemonClient)client).getRepositoryName();
            origin = ((GitDaemonClient)client).getRemoteAddress().getHostAddress();
            timeout = ((GitDaemonClient)client).getDaemon().getTimeout();
            transport = Constants.Transport.GIT;
        } else if (req instanceof SshDaemonClient) {
            client = (SshDaemonClient)req;
            repositoryName = ((SshDaemonClient)client).getRepositoryName();
            origin = ((SshDaemonClient)client).getRemoteAddress().toString();
            user = ((SshDaemonClient)client).getUser();
            transport = Constants.Transport.SSH;
        }
        if (!this.acceptPush(transport)) {
            throw new ServiceNotAuthorizedException();
        }
        boolean allowAnonymousPushes = this.settings.getBoolean("git.allowAnonymousPushes", false);
        if (!allowAnonymousPushes && UserModel.ANONYMOUS.equals(user)) {
            throw new ServiceNotEnabledException();
        }
        String url = this.settings.getString("web.canonicalUrl", null);
        if (StringUtils.isEmpty(url)) {
            url = gitblitUrl;
        }
        RepositoryModel repository = this.gitblit.getRepositoryModel(repositoryName);
        GitblitReceivePack rp = this.gitblit.getTicketService().isAcceptingNewPatchsets(repository) ? new PatchsetReceivePack(this.gitblit, db, repository, user) : new GitblitReceivePack(this.gitblit, db, repository, user);
        rp.setGitblitUrl(url);
        rp.setRefLogIdent(new PersonIdent(user.username, user.username + "@" + origin));
        rp.setTimeout(timeout);
        return rp;
    }

    protected boolean acceptPush(Constants.Transport byTransport) {
        if (byTransport == null) {
            this.logger.info("Unknown transport, push rejected!");
            return false;
        }
        HashSet<Constants.Transport> transports = new HashSet<Constants.Transport>();
        for (String value : this.gitblit.getSettings().getStrings("git.acceptedPushTransports")) {
            Constants.Transport transport = Constants.Transport.fromString(value);
            if (transport == null) {
                this.logger.info(String.format("Ignoring unknown registered transport %s", value));
                continue;
            }
            transports.add(transport);
        }
        if (transports.isEmpty()) {
            return true;
        }
        return transports.contains((Object)byTransport);
    }
}

