/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.git;

import com.gitblit.models.TicketModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.ReceiveCommand;

public class PatchsetCommand
extends ReceiveCommand {
    public static final String TOPIC = "t=";
    public static final String RESPONSIBLE = "r=";
    public static final String WATCH = "cc=";
    public static final String MILESTONE = "m=";
    protected final TicketModel.Change change;
    protected boolean isNew;
    protected long ticketId;

    public static String getBasePatchsetBranch(long ticketNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("refs/tickets/");
        long m = ticketNumber % 100L;
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        sb.append('/');
        sb.append(ticketNumber);
        sb.append('/');
        return sb.toString();
    }

    public static String getTicketBranch(long ticketNumber) {
        return "refs/heads/ticket/" + ticketNumber;
    }

    public static String getReviewBranch(long ticketNumber) {
        return "ticket-" + ticketNumber;
    }

    public static String getPatchsetBranch(long ticketId, long patchset) {
        return PatchsetCommand.getBasePatchsetBranch(ticketId) + patchset;
    }

    public static long getTicketNumber(String ref) {
        if (ref.startsWith("refs/tickets/")) {
            String p = ref.substring("refs/tickets/".length());
            p = p.substring(p.indexOf(47) + 1);
            p = p.substring(0, p.indexOf(47));
            return Long.parseLong(p);
        }
        if (ref.startsWith("refs/heads/ticket/")) {
            String p = ref.substring("refs/heads/ticket/".length());
            return Long.parseLong(p);
        }
        return 0L;
    }

    public PatchsetCommand(String username, TicketModel.Patchset patchset) {
        super(patchset.isFF() ? ObjectId.fromString((String)patchset.parent) : ObjectId.zeroId(), ObjectId.fromString((String)patchset.tip), null);
        this.change = new TicketModel.Change(username);
        this.change.patchset = patchset;
    }

    public TicketModel.PatchsetType getPatchsetType() {
        return this.change.patchset.type;
    }

    public boolean isNewTicket() {
        return this.isNew;
    }

    public long getTicketId() {
        return this.ticketId;
    }

    public TicketModel.Change getChange() {
        return this.change;
    }

    public void newTicket(RevCommit commit, String mergeTo, long ticketId, String pushRef) {
        this.ticketId = ticketId;
        this.isNew = true;
        this.change.setField(TicketModel.Field.title, this.getTitle(commit));
        this.change.setField(TicketModel.Field.body, this.getBody(commit));
        this.change.setField(TicketModel.Field.status, (Object)TicketModel.Status.New);
        this.change.setField(TicketModel.Field.mergeTo, mergeTo);
        this.change.setField(TicketModel.Field.type, (Object)TicketModel.Type.Proposal);
        TreeSet<String> watchSet = new TreeSet<String>();
        watchSet.add(this.change.author);
        if (!StringUtils.isEmpty(pushRef)) {
            String topic;
            String responsible;
            String milestone;
            List<String> watchers = PatchsetCommand.getOptions(pushRef, WATCH);
            if (!ArrayUtils.isEmpty(watchers)) {
                for (String cc : watchers) {
                    watchSet.add(cc.toLowerCase());
                }
            }
            if (!StringUtils.isEmpty(milestone = PatchsetCommand.getSingleOption(pushRef, MILESTONE))) {
                this.change.setField(TicketModel.Field.milestone, milestone);
            }
            if (!StringUtils.isEmpty(responsible = PatchsetCommand.getSingleOption(pushRef, RESPONSIBLE))) {
                this.change.setField(TicketModel.Field.responsible, responsible);
                watchSet.add(responsible);
            }
            if (!StringUtils.isEmpty(topic = PatchsetCommand.getSingleOption(pushRef, TOPIC))) {
                this.change.setField(TicketModel.Field.topic, topic);
            }
        }
        this.change.watch(watchSet.toArray(new String[watchSet.size()]));
    }

    public void updateTicket(RevCommit commit, String mergeTo, TicketModel ticket, String pushRef) {
        this.ticketId = ticket.number;
        if (ticket.isClosed()) {
            this.change.setField(TicketModel.Field.status, (Object)TicketModel.Status.Open);
        }
        if (StringUtils.isEmpty(ticket.mergeTo) || !ticket.mergeTo.equals(mergeTo)) {
            this.change.setField(TicketModel.Field.mergeTo, mergeTo);
        }
        if (ticket.isProposal() && this.change.patchset.commits == 1 && this.change.patchset.type.isRewrite()) {
            String title = this.getTitle(commit);
            String body = this.getBody(commit);
            if (!ticket.title.equals(title)) {
                this.change.setField(TicketModel.Field.title, title);
            }
            if (!ticket.body.equals(body)) {
                this.change.setField(TicketModel.Field.body, body);
            }
        }
        TreeSet<String> watchSet = new TreeSet<String>();
        watchSet.add(this.change.author);
        if (!StringUtils.isEmpty(pushRef)) {
            String topic;
            String responsible;
            String milestone;
            List<String> watchers = PatchsetCommand.getOptions(pushRef, WATCH);
            if (!ArrayUtils.isEmpty(watchers)) {
                for (String cc : watchers) {
                    watchSet.add(cc.toLowerCase());
                }
            }
            if (!StringUtils.isEmpty(milestone = PatchsetCommand.getSingleOption(pushRef, MILESTONE)) && !milestone.equals(ticket.milestone)) {
                this.change.setField(TicketModel.Field.milestone, milestone);
            }
            if (!StringUtils.isEmpty(responsible = PatchsetCommand.getSingleOption(pushRef, RESPONSIBLE)) && !responsible.equals(ticket.responsible)) {
                this.change.setField(TicketModel.Field.responsible, responsible);
                watchSet.add(responsible);
            }
            if (!StringUtils.isEmpty(topic = PatchsetCommand.getSingleOption(pushRef, TOPIC)) && !topic.equals(ticket.topic)) {
                this.change.setField(TicketModel.Field.topic, topic);
            }
        }
        watchSet.removeAll(ticket.getWatchers());
        if (!watchSet.isEmpty()) {
            this.change.watch(watchSet.toArray(new String[watchSet.size()]));
        }
    }

    public String getRefName() {
        return this.getPatchsetBranch();
    }

    public String getPatchsetBranch() {
        return PatchsetCommand.getBasePatchsetBranch(this.ticketId) + this.change.patchset.number;
    }

    public String getTicketBranch() {
        return PatchsetCommand.getTicketBranch(this.ticketId);
    }

    private String getTitle(RevCommit commit) {
        String title = commit.getShortMessage();
        return title;
    }

    private String getBody(RevCommit commit) {
        String body = commit.getFullMessage().substring(commit.getShortMessage().length()).trim();
        return body;
    }

    private static List<String> getOptions(String refName, String token) {
        if (refName.indexOf(37) > -1) {
            String[] strings;
            ArrayList<String> list = new ArrayList<String>();
            for (String str : strings = refName.substring(refName.indexOf(37) + 1).split(",")) {
                if (!str.toLowerCase().startsWith(token)) continue;
                String val = str.substring(token.length());
                list.add(val);
            }
            return list;
        }
        return null;
    }

    private static String getSingleOption(String refName, String token) {
        List<String> list = PatchsetCommand.getOptions(refName, token);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static String getSingleOption(ReceiveCommand cmd, String token) {
        return PatchsetCommand.getSingleOption(cmd.getRefName(), token);
    }

    public static List<String> getOptions(ReceiveCommand cmd, String token) {
        return PatchsetCommand.getOptions(cmd.getRefName(), token);
    }
}

