/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.git;

import com.gitblit.extensions.PatchsetHook;
import com.gitblit.git.GitblitReceivePack;
import com.gitblit.git.PatchsetCommand;
import com.gitblit.git.SideBandProgressMonitor;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.BranchTicketService;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketNotifier;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchsetReceivePack
extends GitblitReceivePack {
    protected static final List<String> MAGIC_REFS = Arrays.asList("refs/for/", "refs/heads/ticket/");
    protected static final Pattern NEW_PATCHSET = Pattern.compile("^refs/tickets/(?:[0-9a-zA-Z][0-9a-zA-Z]/)?([1-9][0-9]*)(?:/new)?$");
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchsetReceivePack.class);
    protected final ITicketService ticketService;
    protected final TicketNotifier ticketNotifier;
    private boolean requireMergeablePatchset;

    public PatchsetReceivePack(IGitblit gitblit, Repository db, RepositoryModel repository, UserModel user) {
        super(gitblit, db, repository, user);
        this.ticketService = gitblit.getTicketService();
        this.ticketNotifier = this.ticketService.createNotifier();
    }

    private String getPatchsetRef(String refName) {
        for (String patchRef : MAGIC_REFS) {
            if (!refName.startsWith(patchRef)) continue;
            return patchRef;
        }
        return null;
    }

    private boolean isPatchsetRef(String refName) {
        return !StringUtils.isEmpty(this.getPatchsetRef(refName));
    }

    private boolean isTicketRef(String refName) {
        return refName.startsWith("refs/tickets/");
    }

    private String getIntegrationBranch(String refName) {
        String patchsetRef = this.getPatchsetRef(refName);
        String branch = refName.substring(patchsetRef.length());
        if (branch.indexOf(37) > -1) {
            branch = branch.substring(0, branch.indexOf(37));
        }
        String defaultBranch = "master";
        try {
            defaultBranch = this.getRepository().getBranch();
        }
        catch (Exception e) {
            LOGGER.error("failed to determine default branch for " + this.repository.name, (Throwable)e);
        }
        if (!StringUtils.isEmpty(this.getRepositoryModel().mergeTo)) {
            defaultBranch = Repository.shortenRefName((String)this.getRepositoryModel().mergeTo);
        }
        long ticketId = 0L;
        try {
            ticketId = Long.parseLong(branch);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ticketId > 0L || branch.equalsIgnoreCase("default") || branch.equalsIgnoreCase("new")) {
            return defaultBranch;
        }
        return branch;
    }

    private long getTicketId(String refName) {
        if (refName.indexOf(37) > -1) {
            refName = refName.substring(0, refName.indexOf(37));
        }
        if (refName.startsWith("refs/for/")) {
            String ref = refName.substring("refs/for/".length());
            try {
                return Long.parseLong(ref);
            }
            catch (Exception exception) {
            }
        } else if (refName.startsWith("refs/heads/ticket/") || refName.startsWith("refs/tickets/")) {
            return PatchsetCommand.getTicketNumber(refName);
        }
        return 0L;
    }

    private boolean hasRefNamespace(String ref) {
        Map blockingFors;
        try {
            blockingFors = this.getRepository().getRefDatabase().getRefs(ref);
        }
        catch (IOException err) {
            this.sendError("Cannot scan refs in {0}", this.repository.name);
            LOGGER.error("Error!", (Throwable)err);
            return true;
        }
        if (!blockingFors.isEmpty()) {
            this.sendError("{0} needs the following refs removed to receive patchsets: {1}", this.repository.name, blockingFors.keySet());
            return true;
        }
        return false;
    }

    private List<ReceiveCommand> excludeTicketCommands(Collection<ReceiveCommand> commands) {
        ArrayList<ReceiveCommand> filtered = new ArrayList<ReceiveCommand>();
        for (ReceiveCommand cmd : commands) {
            if (this.isTicketRef(cmd.getRefName())) continue;
            filtered.add(cmd);
        }
        return filtered;
    }

    private List<ReceiveCommand> excludePatchsetCommands(Collection<ReceiveCommand> commands) {
        ArrayList<ReceiveCommand> filtered = new ArrayList<ReceiveCommand>();
        for (ReceiveCommand cmd : commands) {
            if (this.isPatchsetRef(cmd.getRefName())) continue;
            filtered.add(cmd);
        }
        return filtered;
    }

    @Override
    public void onPreReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        List<ReceiveCommand> filtered = this.excludePatchsetCommands(commands);
        super.onPreReceive(rp, filtered);
    }

    @Override
    public void onPostReceive(ReceivePack rp, Collection<ReceiveCommand> commands) {
        List<ReceiveCommand> filtered = this.excludePatchsetCommands(commands);
        super.onPostReceive(rp, filtered);
        this.ticketNotifier.sendAll();
    }

    protected void validateCommands() {
        for (ReceiveCommand cmd : this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED)) {
            if (!this.isPatchsetRef(cmd.getRefName()) || cmd.getType() != ReceiveCommand.Type.CREATE) continue;
            cmd.setResult(ReceiveCommand.Result.OK);
        }
        super.validateCommands();
    }

    @Override
    protected void executeCommands() {
        List allUpdates;
        List<ReceiveCommand> refUpdates;
        List<ReceiveCommand> stdUpdates;
        boolean processPatchsets = true;
        for (ReceiveCommand cmd : this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED)) {
            if (!(this.ticketService instanceof BranchTicketService) || !"refs/meta/gitblit/tickets".equals(cmd.getRefName())) continue;
            processPatchsets = false;
        }
        for (ReceiveCommand cmd : this.filterCommands(ReceiveCommand.Result.OK)) {
            if (this.isPatchsetRef(cmd.getRefName())) {
                cmd.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
                continue;
            }
            if (!(this.ticketService instanceof BranchTicketService) || !"refs/meta/gitblit/tickets".equals(cmd.getRefName())) continue;
            processPatchsets = false;
        }
        List toApply = this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED);
        if (toApply.isEmpty()) {
            return;
        }
        Object updating = NullProgressMonitor.INSTANCE;
        boolean sideBand = this.isCapabilityEnabled("side-band-64k");
        if (sideBand) {
            SideBandProgressMonitor pm = new SideBandProgressMonitor(this.msgOut);
            pm.setDelayStart(250L, TimeUnit.MILLISECONDS);
            updating = pm;
        }
        BatchRefUpdate batch = this.getRepository().getRefDatabase().newBatchUpdate();
        batch.setAllowNonFastForwards(this.isAllowNonFastForwards());
        batch.setRefLogIdent(this.getRefLogIdent());
        batch.setRefLogMessage("push", true);
        ReceiveCommand patchsetRefCmd = null;
        PatchsetCommand patchsetCmd = null;
        for (ReceiveCommand cmd : toApply) {
            if (ReceiveCommand.Result.NOT_ATTEMPTED != cmd.getResult()) continue;
            if (this.isPatchsetRef(cmd.getRefName()) && processPatchsets) {
                TicketMilestone milestoneModel;
                String milestone;
                if (this.ticketService == null) {
                    this.sendRejection(cmd, "Sorry, the ticket service is unavailable and can not accept patchsets at this time.", new Object[0]);
                    continue;
                }
                if (!this.ticketService.isReady()) {
                    this.sendRejection(cmd, "Sorry, the ticket service can not accept patchsets at this time.", new Object[0]);
                    continue;
                }
                if (UserModel.ANONYMOUS.equals(this.user)) {
                    this.sendRejection(cmd, "Sorry, anonymous patchset contributions are prohibited.", new Object[0]);
                    continue;
                }
                Matcher m = NEW_PATCHSET.matcher(cmd.getRefName());
                if (m.matches()) {
                    long id = this.getTicketId(cmd.getRefName());
                    this.sendError("You may not directly push directly to a patchset ref!");
                    this.sendError("Instead, please push to one the following:");
                    this.sendError(" - {0}{1,number,0}", "refs/for/", id);
                    this.sendError(" - {0}{1,number,0}", "refs/heads/ticket/", id);
                    this.sendRejection(cmd, "protected ref", new Object[0]);
                    continue;
                }
                if (this.hasRefNamespace("refs/for/")) {
                    LOGGER.error("{} already has refs in the {} namespace", (Object)this.repository.name, (Object)"refs/for/");
                    this.sendRejection(cmd, "Sorry, a repository administrator will have to remove the {} namespace", "refs/for/");
                    continue;
                }
                if (cmd.getNewId().equals((AnyObjectId)ObjectId.zeroId())) {
                    if (cmd.getRefName().startsWith("refs/heads/ticket/")) {
                        if (this.user.canDeleteRef(this.repository)) {
                            batch.addCommand(cmd);
                            continue;
                        }
                        this.sendRejection(cmd, "Sorry, you do not have permission to delete {}", cmd.getRefName());
                        continue;
                    }
                    this.sendRejection(cmd, "Sorry, you can not delete {}", cmd.getRefName());
                    continue;
                }
                if (patchsetRefCmd != null) {
                    this.sendRejection(cmd, "You may only push one patchset at a time.", new Object[0]);
                    continue;
                }
                LOGGER.info(MessageFormat.format("Verifying {0} push ref \"{1}\" received from {2}", this.repository.name, cmd.getRefName(), this.user.username));
                String responsible = PatchsetCommand.getSingleOption(cmd, "r=");
                if (!StringUtils.isEmpty(responsible)) {
                    UserModel assignee = this.gitblit.getUserModel(responsible);
                    if (assignee == null) {
                        this.sendRejection(cmd, "{0} can not be assigned any tickets because there is no user account by that name", responsible);
                        continue;
                    }
                    if (!assignee.canPush(this.repository)) {
                        this.sendRejection(cmd, "{0} ({1}) can not be assigned any tickets because the user does not have RW permissions for {2}", assignee.getDisplayName(), assignee.username, this.repository.name);
                        continue;
                    }
                }
                if (!StringUtils.isEmpty(milestone = PatchsetCommand.getSingleOption(cmd, "m=")) && (milestoneModel = this.ticketService.getMilestone(this.repository, milestone)) == null) {
                    this.sendRejection(cmd, "Sorry, \"{0}\" is not a valid milestone!", milestone);
                    continue;
                }
                List<String> watchers = PatchsetCommand.getOptions(cmd, "cc=");
                if (!ArrayUtils.isEmpty(watchers)) {
                    boolean verified = true;
                    for (String watcher : watchers) {
                        UserModel user = this.gitblit.getUserModel(watcher);
                        if (user != null) continue;
                        this.sendRejection(cmd, "Sorry, \"{0}\" is not a valid username for the watch list!", watcher);
                        verified = false;
                        break;
                    }
                    if (!verified) continue;
                }
                patchsetRefCmd = cmd;
                patchsetCmd = this.preparePatchset(cmd);
                if (patchsetCmd == null) continue;
                batch.addCommand((ReceiveCommand)patchsetCmd);
                continue;
            }
            batch.addCommand(cmd);
        }
        if (!batch.getCommands().isEmpty()) {
            try {
                batch.execute(this.getRevWalk(), (ProgressMonitor)updating);
            }
            catch (IOException err) {
                for (ReceiveCommand cmd : toApply) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    this.sendRejection(cmd, "lock error: {0}", err.getMessage());
                    LOGGER.error(MessageFormat.format("failed to lock {0}:{1}", this.repository.name, cmd.getRefName()), (Throwable)err);
                }
            }
        }
        if (patchsetRefCmd != null && patchsetCmd != null) {
            if (!patchsetCmd.getResult().equals((Object)ReceiveCommand.Result.OK)) {
                LOGGER.error(patchsetCmd.getType() + " " + patchsetCmd.getRefName() + " " + patchsetCmd.getResult());
                patchsetRefCmd.setResult(patchsetCmd.getResult(), patchsetCmd.getMessage());
            } else {
                patchsetRefCmd.setResult(ReceiveCommand.Result.OK);
                RefUpdate ru = this.updateRef(patchsetCmd.getTicketBranch(), patchsetCmd.getNewId(), patchsetCmd.getPatchsetType());
                this.updateReflog(ru);
                TicketModel ticket = this.processPatchset(patchsetCmd);
                if (ticket != null) {
                    this.ticketNotifier.queueMailing(ticket);
                }
            }
        }
        if (!(stdUpdates = this.excludeTicketCommands(refUpdates = this.excludePatchsetCommands(allUpdates = ReceiveCommand.filter((List)batch.getCommands(), (ReceiveCommand.Result)ReceiveCommand.Result.OK)))).isEmpty()) {
            int ticketsProcessed = 0;
            block11: for (ReceiveCommand cmd : stdUpdates) {
                switch (cmd.getType()) {
                    case CREATE: 
                    case UPDATE: {
                        if (!cmd.getRefName().startsWith("refs/heads/")) break;
                        Collection<TicketModel> tickets2 = this.processReferencedTickets(cmd);
                        ticketsProcessed += tickets2.size();
                        for (TicketModel ticket : tickets2) {
                            this.ticketNotifier.queueMailing(ticket);
                        }
                        continue block11;
                    }
                    case UPDATE_NONFASTFORWARD: {
                        if (!cmd.getRefName().startsWith("refs/heads/")) break;
                        String base = JGitUtils.getMergeBase(this.getRepository(), cmd.getOldId(), cmd.getNewId());
                        List<TicketModel.TicketLink> deletedRefs = JGitUtils.identifyTicketsBetweenCommits(this.getRepository(), this.settings, base, cmd.getOldId().name());
                        for (TicketModel.TicketLink link : deletedRefs) {
                            link.isDelete = true;
                        }
                        TicketModel.Change deletion = new TicketModel.Change(this.user.username);
                        deletion.pendingLinks = deletedRefs;
                        this.ticketService.updateTicket(this.repository, 0L, deletion);
                        Collection<TicketModel> tickets3 = this.processReferencedTickets(cmd);
                        ticketsProcessed += tickets3.size();
                        for (TicketModel ticket : tickets3) {
                            this.ticketNotifier.queueMailing(ticket);
                        }
                        continue block11;
                    }
                }
            }
            if (ticketsProcessed == 1) {
                this.sendInfo("1 ticket updated", new Object[0]);
            } else if (ticketsProcessed > 1) {
                this.sendInfo("{0} tickets updated", ticketsProcessed);
            }
        }
        this.ticketService.resetCaches(this.repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchsetCommand preparePatchset(ReceiveCommand cmd) {
        PatchsetCommand psCmd;
        TicketModel.Patchset patchset;
        String branch = this.getIntegrationBranch(cmd.getRefName());
        long number = this.getTicketId(cmd.getRefName());
        TicketModel ticket = null;
        if (number > 0L && this.ticketService.hasTicket(this.repository, number)) {
            ticket = this.ticketService.getTicket(this.repository, number);
        }
        if (ticket == null) {
            if (number > 0L) {
                this.sendError("Sorry, {0} does not have ticket {1,number,0}!", this.repository.name, number);
                this.sendRejection(cmd, "Invalid ticket number", new Object[0]);
                return null;
            }
        } else {
            if (ticket.isMerged()) {
                TicketModel.Change mergeChange = null;
                for (TicketModel.Change change : ticket.changes) {
                    if (!change.isMerge()) continue;
                    mergeChange = change;
                    break;
                }
                if (mergeChange != null) {
                    this.sendError("Sorry, {0} already merged {1} from ticket {2,number,0} to {3}!", mergeChange.author, mergeChange.patchset, number, ticket.mergeTo);
                }
                this.sendRejection(cmd, "Ticket {0,number,0} already resolved", number);
                return null;
            }
            if (!StringUtils.isEmpty(ticket.mergeTo)) {
                branch = ticket.mergeTo;
            }
        }
        int shortCommitIdLen = this.settings.getInteger("web.shortCommitIdLength", 6);
        String shortTipId = cmd.getNewId().getName().substring(0, shortCommitIdLen);
        RevCommit tipCommit = JGitUtils.getCommit(this.getRepository(), cmd.getNewId().getName());
        String forBranch = branch;
        RevCommit mergeBase = null;
        Ref forBranchRef = (Ref)this.getAdvertisedRefs().get("refs/heads/" + forBranch);
        if (forBranchRef == null || forBranchRef.getObjectId() == null) {
            this.sendError("Sorry, there is no integration branch named ''{0}''.", forBranch);
            this.sendRejection(cmd, "Invalid integration branch specified", new Object[0]);
            return null;
        }
        String base = JGitUtils.getMergeBase(this.getRepository(), forBranchRef.getObjectId(), tipCommit.getId());
        if (StringUtils.isEmpty(base)) {
            this.sendError("");
            this.sendError("There is no common ancestry between {0} and {1}.", forBranch, shortTipId);
            this.sendError("Please reconsider your proposed integration branch, {0}.", forBranch);
            this.sendError("");
            this.sendRejection(cmd, "no merge base for patchset and {0}", forBranch);
            return null;
        }
        mergeBase = JGitUtils.getCommit(this.getRepository(), base);
        JGitUtils.MergeStatus status = JGitUtils.canMerge(this.getRepository(), tipCommit.getName(), forBranch, this.repository.mergeType);
        switch (status) {
            case ALREADY_MERGED: {
                this.sendError("");
                this.sendError("You have already merged this patchset.", forBranch);
                this.sendError("");
                this.sendRejection(cmd, "everything up-to-date", new Object[0]);
                return null;
            }
            case MERGEABLE: {
                break;
            }
            default: {
                if (ticket != null && !this.requireMergeablePatchset) break;
                this.sendError("");
                this.sendError("Your patchset can not be cleanly merged into {0}.", forBranch);
                this.sendError("Please rebase your patchset and push again.");
                this.sendError("NOTE:", number);
                this.sendError("You should push your rebase to refs/for/{0,number,0}", number);
                this.sendError("");
                this.sendError("  git push origin HEAD:refs/for/{0,number,0}", number);
                this.sendError("");
                this.sendRejection(cmd, "patchset not mergeable", new Object[0]);
                return null;
            }
        }
        if (ticket != null && JGitUtils.getTicketNumberFromCommitBranch(this.getRepository(), tipCommit) == ticket.number) {
            this.sendError("{0} has already been pushed to ticket {1,number,0}.", shortTipId, ticket.number);
            this.sendRejection(cmd, "everything up-to-date", new Object[0]);
            return null;
        }
        List<TicketModel.TicketLink> ticketLinks = JGitUtils.identifyTicketsFromCommitMessage(this.getRepository(), this.settings, tipCommit);
        if (ticket == null) {
            patchset = this.newPatchset(null, mergeBase.getName(), tipCommit.getName());
            int minLength = 10;
            int maxLength = 100;
            String minTitle = MessageFormat.format("  minimum length of a title is {0} characters.", minLength);
            String maxTitle = MessageFormat.format("  maximum length of a title is {0} characters.", maxLength);
            if (patchset.commits > 1) {
                this.sendError("");
                this.sendError("You may not create a ''{0}'' branch proposal ticket from {1} commits!", forBranch, patchset.commits);
                this.sendError("");
                RevWalk walk = this.getRevWalk();
                walk.reset();
                walk.sort(RevSort.TOPO);
                int boundary = 3;
                int count = 0;
                try {
                    RevCommit c;
                    walk.markStart(tipCommit);
                    walk.markUninteresting(mergeBase);
                    while ((c = walk.next()) != null) {
                        if (count < boundary || count >= patchset.commits - boundary) {
                            walk.parseBody((RevObject)c);
                            this.sendError("   {0}  {1}", c.getName().substring(0, shortCommitIdLen), StringUtils.trimString(c.getShortMessage(), 60));
                        } else if (count == boundary) {
                            this.sendError("   ... more commits ...");
                        }
                        ++count;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("failed to get commit count", (Throwable)e);
                }
                finally {
                    walk.close();
                }
                this.sendError("");
                this.sendError("Possible Solutions:");
                this.sendError("");
                int solution = 1;
                String forSpec = cmd.getRefName().substring("refs/for/".length());
                if (forSpec.equals("default") || forSpec.equals("new")) {
                    try {
                        ArrayList bases = Lists.newArrayList();
                        for (Ref ref : this.getRepository().getRefDatabase().getRefs("refs/heads/").values()) {
                            if (ref.getName().startsWith("refs/heads/ticket/") || ref.getName().equals(forBranchRef.getName()) || !JGitUtils.isMergedInto(this.getRepository(), ref.getObjectId(), (ObjectId)tipCommit)) continue;
                            bases.add(Repository.shortenRefName((String)ref.getName()));
                        }
                        if (!bases.isEmpty()) {
                            if (bases.size() == 1) {
                                String base2 = (String)bases.get(0);
                                this.sendError("{0}. Propose this change for the ''{1}'' branch.", solution++, base2);
                                this.sendError("");
                                this.sendError("   git push origin HEAD:refs/for/{0}", base2);
                                this.sendError("   pt propose {0}", base2);
                                this.sendError("");
                            } else {
                                this.sendError("{0}. Propose this change for a different branch.", solution++);
                                this.sendError("");
                                for (String base3 : bases) {
                                    this.sendError("   git push origin HEAD:refs/for/{0}", base3);
                                    this.sendError("   pt propose {0}", base3);
                                    this.sendError("");
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error(null, (Throwable)e);
                    }
                }
                this.sendError("{0}. Squash your changes into a single commit with a meaningful message.", solution++);
                this.sendError("");
                this.sendError("{0}. Open a ticket for your changes and then push your {1} commits to the ticket.", solution++, patchset.commits);
                this.sendError("");
                this.sendError("   git push origin HEAD:refs/for/{id}");
                this.sendError("   pt propose {id}");
                this.sendError("");
                this.sendRejection(cmd, "too many commits", new Object[0]);
                return null;
            }
            String title = tipCommit.getFullMessage().trim().split("\n")[0];
            if (title.length() < minLength) {
                this.sendError("");
                this.sendError("Please supply a longer title in your commit message!");
                this.sendError("");
                this.sendError(minTitle);
                this.sendError(maxTitle);
                this.sendError("");
                this.sendRejection(cmd, "ticket title is too short [{0}/{1}]", title.length(), maxLength);
                return null;
            }
            if (title.length() > maxLength) {
                this.sendError("");
                this.sendError("Please supply a more concise title in your commit message!");
                this.sendError("");
                this.sendError(minTitle);
                this.sendError(maxTitle);
                this.sendError("");
                this.sendRejection(cmd, "ticket title is too long [{0}/{1}]", title.length(), maxLength);
                return null;
            }
            long ticketId = this.ticketService.assignNewId(this.repository);
            psCmd = new PatchsetCommand(this.user.username, patchset);
            psCmd.newTicket(tipCommit, forBranch, ticketId, cmd.getRefName());
        } else {
            patchset = this.newPatchset(ticket, mergeBase.getName(), tipCommit.getName());
            psCmd = new PatchsetCommand(this.user.username, patchset);
            psCmd.updateTicket(tipCommit, forBranch, ticket, cmd.getRefName());
        }
        boolean pushPermitted = ticket == null || !ticket.hasPatchsets() || ticket.isAuthor(this.user.username) || ticket.isPatchsetAuthor(this.user.username) || ticket.isResponsible(this.user.username) || this.user.canPush(this.repository);
        switch (psCmd.getPatchsetType()) {
            case Proposal: {
                break;
            }
            case FastForward: {
                if (pushPermitted) break;
                this.sendError("");
                this.sendError("To push a patchset to this ticket one of the following must be true:");
                this.sendError("  1. you created the ticket");
                this.sendError("  2. you created the first patchset");
                this.sendError("  3. you are specified as responsible for the ticket");
                this.sendError("  4. you have push (RW) permissions to {0}", this.repository.name);
                this.sendError("");
                this.sendRejection(cmd, "not permitted to push to ticket {0,number,0}", ticket.number);
                return null;
            }
            default: {
                if (pushPermitted) break;
                this.sendRejection(cmd, "non-fast-forward ({0})", new Object[]{psCmd.getPatchsetType()});
                return null;
            }
        }
        TicketModel.Change change = psCmd.getChange();
        change.pendingLinks = ticketLinks;
        return psCmd;
    }

    private TicketModel processPatchset(PatchsetCommand cmd) {
        TicketModel.Change change = cmd.getChange();
        if (cmd.isNewTicket()) {
            TicketModel ticket = this.ticketService.createTicket(this.repository, cmd.getTicketId(), change);
            if (ticket != null) {
                this.sendInfo("", new Object[0]);
                this.sendHeader("#{0,number,0}: {1}", ticket.number, StringUtils.trimString(ticket.title, 78));
                this.sendInfo("created proposal ticket from patchset", new Object[0]);
                this.sendInfo(this.ticketService.getTicketUrl(ticket), new Object[0]);
                this.sendInfo("", new Object[0]);
                RefLogUtils.updateRefLog(this.user, this.getRepository(), Arrays.asList(new ReceiveCommand(cmd.getOldId(), cmd.getNewId(), cmd.getRefName())));
                for (PatchsetHook hook : this.gitblit.getExtensions(PatchsetHook.class)) {
                    try {
                        hook.onNewPatchset(ticket);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to execute extension", (Throwable)e);
                    }
                }
                return ticket;
            }
            this.sendError("FAILED to create ticket");
        } else {
            TicketModel ticket = this.ticketService.updateTicket(this.repository, cmd.getTicketId(), change);
            if (ticket != null) {
                this.sendInfo("", new Object[0]);
                this.sendHeader("#{0,number,0}: {1}", ticket.number, StringUtils.trimString(ticket.title, 78));
                if (change.patchset.rev == 1) {
                    this.sendInfo("uploaded patchset {0} ({1})", change.patchset.number, change.patchset.type.toString());
                } else {
                    this.sendInfo("added {0} {1} to patchset {2}", change.patchset.added, change.patchset.added == 1 ? "commit" : "commits", change.patchset.number);
                }
                this.sendInfo(this.ticketService.getTicketUrl(ticket), new Object[0]);
                this.sendInfo("", new Object[0]);
                RefLogUtils.updateRefLog(this.user, this.getRepository(), Arrays.asList(new ReceiveCommand(cmd.getOldId(), cmd.getNewId(), cmd.getRefName())));
                boolean isNewPatchset = change.patchset.rev == 1;
                for (PatchsetHook hook : this.gitblit.getExtensions(PatchsetHook.class)) {
                    try {
                        if (isNewPatchset) {
                            hook.onNewPatchset(ticket);
                            continue;
                        }
                        hook.onUpdatePatchset(ticket);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to execute extension", (Throwable)e);
                    }
                }
                return ticket;
            }
            this.sendError("FAILED to upload {0} for ticket {1,number,0}", change.patchset, cmd.getTicketId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TicketModel> processReferencedTickets(ReceiveCommand cmd) {
        LinkedHashMap<Long, TicketModel> mergedTickets = new LinkedHashMap<Long, TicketModel>();
        RevWalk rw = this.getRevWalk();
        try {
            RevCommit c;
            rw.reset();
            rw.markStart(rw.parseCommit((AnyObjectId)cmd.getNewId()));
            if (!ObjectId.zeroId().equals((AnyObjectId)cmd.getOldId())) {
                rw.markUninteresting(rw.parseCommit((AnyObjectId)cmd.getOldId()));
            }
            while ((c = rw.next()) != null) {
                rw.parseBody((RevObject)c);
                List<TicketModel.TicketLink> ticketLinks = JGitUtils.identifyTicketsFromCommitMessage(this.getRepository(), this.settings, c);
                if (ticketLinks == null) continue;
                for (TicketModel.TicketLink link : ticketLinks) {
                    TicketModel.Change change;
                    TicketModel ticket;
                    if (mergedTickets.containsKey(link.targetTicketId) || (ticket = this.ticketService.getTicket(this.repository, link.targetTicketId)) == null) continue;
                    String integrationBranch = StringUtils.isEmpty(ticket.mergeTo) ? null : "refs/heads/" + ticket.mergeTo;
                    TicketModel.Patchset patchset = null;
                    String mergeSha = c.getName();
                    String mergeTo = Repository.shortenRefName((String)cmd.getRefName());
                    if (link.action == TicketModel.TicketAction.Commit) {
                        change = new TicketModel.Change(this.user.username);
                        change.referenceCommit(mergeSha);
                    } else {
                        if (ticket.isClosed() || integrationBranch != null && !integrationBranch.equals(cmd.getRefName())) continue;
                        String baseRef = PatchsetCommand.getBasePatchsetBranch(ticket.number);
                        boolean knownPatchset = false;
                        Set refs = (Set)this.getRepository().getAllRefsByPeeledObjectId().get(c.getId());
                        if (refs != null) {
                            for (Ref ref : refs) {
                                if (!ref.getName().startsWith(baseRef)) continue;
                                knownPatchset = true;
                                break;
                            }
                        }
                        if (knownPatchset) {
                            for (TicketModel.Patchset ps : ticket.getPatchsets()) {
                                if (!ps.tip.equals(mergeSha)) continue;
                                patchset = ps;
                                break;
                            }
                            if (patchset == null) {
                                this.sendError("Failed to find the patchset for {0} in ticket {1,number,0}?!", mergeSha, ticket.number);
                                continue;
                            }
                            change = new TicketModel.Change(this.user.username);
                        } else {
                            String base = cmd.getOldId().getName();
                            patchset = this.newPatchset(ticket, base, mergeSha);
                            PatchsetCommand psCmd = new PatchsetCommand(this.user.username, patchset);
                            psCmd.updateTicket(c, mergeTo, ticket, null);
                            this.updateRef(psCmd.getPatchsetBranch(), c.getId(), patchset.type);
                            RefUpdate ru = this.updateRef(psCmd.getTicketBranch(), c.getId(), patchset.type);
                            this.updateReflog(ru);
                            change = psCmd.getChange();
                        }
                        change.setField(TicketModel.Field.status, (Object)TicketModel.Status.Merged);
                        change.setField(TicketModel.Field.mergeSha, mergeSha);
                        change.setField(TicketModel.Field.mergeTo, mergeTo);
                        if (StringUtils.isEmpty(ticket.responsible)) {
                            change.setField(TicketModel.Field.responsible, this.user.username);
                        }
                    }
                    ticket = this.ticketService.updateTicket(this.repository, ticket.number, change);
                    if (ticket != null) {
                        this.sendInfo("", new Object[0]);
                        this.sendHeader("#{0,number,0}: {1}", ticket.number, StringUtils.trimString(ticket.title, 78));
                        switch (link.action) {
                            case Commit: {
                                this.sendInfo("referenced by push of {0} to {1}", c.getName(), mergeTo);
                                break;
                            }
                            case Close: {
                                this.sendInfo("closed by push of {0} to {1}", patchset, mergeTo);
                                mergedTickets.put(ticket.number, ticket);
                                break;
                            }
                        }
                        this.sendInfo(this.ticketService.getTicketUrl(ticket), new Object[0]);
                        this.sendInfo("", new Object[0]);
                        continue;
                    }
                    String shortid = mergeSha.substring(0, this.settings.getInteger("web.shortCommitIdLength", 6));
                    switch (link.action) {
                        case Commit: {
                            this.sendError("FAILED to reference ticket {0,number,0} by push of {1}", link.targetTicketId, shortid);
                            break;
                        }
                        case Close: {
                            this.sendError("FAILED to close ticket {0,number,0} by push of {1}", link.targetTicketId, shortid);
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't scan for changes to reference or close", (Throwable)e);
        }
        finally {
            rw.reset();
        }
        return mergedTickets.values();
    }

    private TicketModel.Patchset newPatchset(TicketModel ticket, String mergeBase, String tip) {
        TicketModel.Patchset currPatchset;
        int totalCommits = JGitUtils.countCommits(this.getRepository(), this.getRevWalk(), mergeBase, tip);
        TicketModel.Patchset newPatchset = new TicketModel.Patchset();
        newPatchset.tip = tip;
        newPatchset.base = mergeBase;
        newPatchset.commits = totalCommits;
        TicketModel.Patchset patchset = currPatchset = ticket == null ? null : ticket.getCurrentPatchset();
        if (currPatchset == null) {
            newPatchset.number = 1;
            newPatchset.rev = 1;
            newPatchset.type = TicketModel.PatchsetType.Proposal;
            DiffUtils.DiffStat diffStat = DiffUtils.getDiffStat(this.getRepository(), mergeBase, tip);
            newPatchset.insertions = diffStat.getInsertions();
            newPatchset.deletions = diffStat.getDeletions();
        } else {
            boolean rebase;
            int added = totalCommits - currPatchset.commits;
            boolean ff = JGitUtils.isMergedInto(this.getRepository(), currPatchset.tip, tip);
            boolean squash = added < 0;
            boolean bl = rebase = !currPatchset.base.equals(mergeBase);
            if (ff) {
                boolean merged = JGitUtils.isMergedInto(this.getRepository(), currPatchset.tip, ticket.mergeTo);
                if (merged) {
                    newPatchset.type = TicketModel.PatchsetType.Rebase;
                    newPatchset.number = currPatchset.number + 1;
                    newPatchset.rev = 1;
                    DiffUtils.DiffStat diffStat = DiffUtils.getDiffStat(this.getRepository(), mergeBase, tip);
                    newPatchset.insertions = diffStat.getInsertions();
                    newPatchset.deletions = diffStat.getDeletions();
                } else {
                    newPatchset.type = TicketModel.PatchsetType.FastForward;
                    newPatchset.number = currPatchset.number;
                    newPatchset.rev = currPatchset.rev + 1;
                    newPatchset.parent = currPatchset.tip;
                    DiffUtils.DiffStat diffStat = DiffUtils.getDiffStat(this.getRepository(), currPatchset.tip, tip);
                    newPatchset.insertions = diffStat.getInsertions();
                    newPatchset.deletions = diffStat.getDeletions();
                }
            } else {
                if (rebase && squash) {
                    newPatchset.type = TicketModel.PatchsetType.Rebase_Squash;
                    newPatchset.number = currPatchset.number + 1;
                    newPatchset.rev = 1;
                } else if (squash) {
                    newPatchset.type = TicketModel.PatchsetType.Squash;
                    newPatchset.number = currPatchset.number + 1;
                    newPatchset.rev = 1;
                } else if (rebase) {
                    newPatchset.type = TicketModel.PatchsetType.Rebase;
                    newPatchset.number = currPatchset.number + 1;
                    newPatchset.rev = 1;
                } else {
                    newPatchset.type = TicketModel.PatchsetType.Amend;
                    newPatchset.number = currPatchset.number + 1;
                    newPatchset.rev = 1;
                }
                DiffUtils.DiffStat diffStat = DiffUtils.getDiffStat(this.getRepository(), mergeBase, tip);
                newPatchset.insertions = diffStat.getInsertions();
                newPatchset.deletions = diffStat.getDeletions();
            }
            if (added > 0) {
                newPatchset.added = added;
            }
        }
        return newPatchset;
    }

    private RefUpdate updateRef(String ref, ObjectId newId, TicketModel.PatchsetType type) {
        ObjectId ticketRefId = ObjectId.zeroId();
        try {
            ticketRefId = this.getRepository().resolve(ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RefUpdate ru = this.getRepository().updateRef(ref, false);
            ru.setRefLogIdent(this.getRefLogIdent());
            switch (type) {
                case Amend: 
                case Rebase: 
                case Rebase_Squash: 
                case Squash: {
                    ru.setForceUpdate(true);
                    break;
                }
            }
            ru.setExpectedOldObjectId((AnyObjectId)ticketRefId);
            ru.setNewObjectId((AnyObjectId)newId);
            RefUpdate.Result result = ru.update(this.getRevWalk());
            if (result == RefUpdate.Result.LOCK_FAILURE) {
                this.sendError("Failed to obtain lock when updating {0}:{1}", this.repository.name, ref);
                this.sendError("Perhaps an administrator should remove {0}/{1}.lock?", this.getRepository().getDirectory(), ref);
                return null;
            }
            return ru;
        }
        catch (IOException e) {
            LOGGER.error("failed to update ref " + ref, (Throwable)e);
            this.sendError("There was an error updating ref {0}:{1}", this.repository.name, ref);
            return null;
        }
    }

    private void updateReflog(RefUpdate ru) {
        if (ru == null) {
            return;
        }
        ReceiveCommand.Type type = null;
        switch (ru.getResult()) {
            case NEW: {
                type = ReceiveCommand.Type.CREATE;
                break;
            }
            case FAST_FORWARD: {
                type = ReceiveCommand.Type.UPDATE;
                break;
            }
            case FORCED: {
                type = ReceiveCommand.Type.UPDATE_NONFASTFORWARD;
                break;
            }
            default: {
                LOGGER.error(MessageFormat.format("unexpected ref update type {0} for {1}", ru.getResult(), ru.getName()));
                return;
            }
        }
        ReceiveCommand cmd = new ReceiveCommand(ru.getOldObjectId(), ru.getNewObjectId(), ru.getName(), type);
        RefLogUtils.updateRefLog(this.user, this.getRepository(), Arrays.asList(cmd));
    }

    public JGitUtils.MergeStatus merge(TicketModel ticket) {
        PersonIdent committer = new PersonIdent(this.user.getDisplayName(), StringUtils.isEmpty(this.user.emailAddress) ? this.user.username + "@gitblit" : this.user.emailAddress);
        TicketModel.Patchset patchset = ticket.getCurrentPatchset();
        String message = MessageFormat.format("Merged #{0,number,0} \"{1}\"", ticket.number, ticket.title);
        Ref oldRef = null;
        try {
            oldRef = this.getRepository().getRef(ticket.mergeTo);
        }
        catch (IOException e) {
            LOGGER.error("failed to get ref for " + ticket.mergeTo, (Throwable)e);
        }
        JGitUtils.MergeResult mergeResult = JGitUtils.merge(this.getRepository(), patchset.tip, ticket.mergeTo, this.getRepositoryModel().mergeType, committer, message);
        if (StringUtils.isEmpty(mergeResult.sha)) {
            LOGGER.error("FAILED to merge {} to {} ({})", new Object[]{patchset, ticket.mergeTo, mergeResult.status.name()});
            return mergeResult.status;
        }
        TicketModel.Change change = new TicketModel.Change(this.user.username);
        change.setField(TicketModel.Field.status, (Object)TicketModel.Status.Merged);
        change.setField(TicketModel.Field.mergeSha, mergeResult.sha);
        change.setField(TicketModel.Field.mergeTo, ticket.mergeTo);
        if (StringUtils.isEmpty(ticket.responsible)) {
            change.setField(TicketModel.Field.responsible, this.user.username);
        }
        long ticketId = ticket.number;
        ticket = this.ticketService.updateTicket(this.repository, ticket.number, change);
        if (ticket != null) {
            this.ticketNotifier.queueMailing(ticket);
            if (oldRef != null) {
                ReceiveCommand cmd = new ReceiveCommand(oldRef.getObjectId(), ObjectId.fromString((String)mergeResult.sha), oldRef.getName());
                cmd.setResult(ReceiveCommand.Result.OK);
                List<ReceiveCommand> commands = Arrays.asList(cmd);
                this.logRefChange(commands);
                this.updateIncrementalPushTags(commands);
                this.updateGitblitRefLog(commands);
            }
            for (PatchsetHook hook : this.gitblit.getExtensions(PatchsetHook.class)) {
                try {
                    hook.onMergePatchset(ticket);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to execute extension", (Throwable)e);
                }
            }
            return mergeResult.status;
        }
        LOGGER.error("FAILED to resolve ticket {} by merge from web ui", (Object)ticketId);
        return mergeResult.status;
    }

    public void sendAll() {
        this.ticketNotifier.sendAll();
    }
}

