/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.git;

import com.gitblit.manager.IGitblit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.transport.git.GitDaemonClient;
import com.gitblit.transport.ssh.SshDaemonClient;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.resolver.FileResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryResolver<X>
extends FileResolver<X> {
    private final Logger logger = LoggerFactory.getLogger(RepositoryResolver.class);
    private final IGitblit gitblit;

    public RepositoryResolver(IGitblit gitblit) {
        super(gitblit.getRepositoriesFolder(), true);
        this.gitblit = gitblit;
    }

    public Repository open(X req, String name) throws RepositoryNotFoundException, ServiceNotEnabledException {
        Repository repo = super.open(req, name);
        if (req instanceof HttpServletRequest) {
            HttpServletRequest client = (HttpServletRequest)req;
            client.setAttribute("gitblitRepositoryName", (Object)name);
        } else if (req instanceof GitDaemonClient) {
            GitDaemonClient client = (GitDaemonClient)req;
            client.setRepositoryName(name);
        } else if (req instanceof SshDaemonClient) {
            SshDaemonClient client = (SshDaemonClient)req;
            client.setRepositoryName(name);
        }
        return repo;
    }

    protected boolean isExportOk(X req, String repositoryName, Repository db) throws IOException {
        RepositoryModel model = this.gitblit.getRepositoryModel(repositoryName);
        UserModel user = UserModel.ANONYMOUS;
        String scheme = null;
        String origin = null;
        if (req instanceof GitDaemonClient) {
            GitDaemonClient client = (GitDaemonClient)req;
            scheme = "git";
            origin = client.getRemoteAddress().toString();
        } else if (req instanceof HttpServletRequest) {
            HttpServletRequest client = (HttpServletRequest)req;
            scheme = client.getScheme();
            origin = client.getRemoteAddr();
            user = this.gitblit.authenticate(client);
            if (user == null) {
                user = UserModel.ANONYMOUS;
            }
        } else if (req instanceof SshDaemonClient) {
            SshDaemonClient client = (SshDaemonClient)req;
            user = client.getUser();
        }
        if (user.canClone(model)) {
            this.logger.debug(MessageFormat.format("{0}:// access of {1} by {2} from {3} PERMITTED", scheme, repositoryName, user.username, origin));
            return true;
        }
        this.logger.warn(MessageFormat.format("{0}:// access of {1} by {2} from {3} DENIED", scheme, repositoryName, user.username, origin));
        return false;
    }
}

