/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.guice;

import com.gitblit.AvatarGenerator;
import com.gitblit.GravatarGenerator;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AvatarGeneratorProvider
implements Provider<AvatarGenerator> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IRuntimeManager runtimeManager;
    private volatile AvatarGenerator avatarGenerator;

    @Inject
    public AvatarGeneratorProvider(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public synchronized AvatarGenerator get() {
        if (this.avatarGenerator != null) {
            return this.avatarGenerator;
        }
        IStoredSettings settings = this.runtimeManager.getSettings();
        String clazz = settings.getString("web.avatarClass", GravatarGenerator.class.getName());
        if (StringUtils.isEmpty(clazz)) {
            clazz = GravatarGenerator.class.getName();
        }
        try {
            Class<?> generatorClass = Class.forName(clazz);
            this.avatarGenerator = (AvatarGenerator)this.runtimeManager.getInjector().getInstance(generatorClass);
        }
        catch (Exception e) {
            this.logger.error("failed to create avatar generator", (Throwable)e);
            this.avatarGenerator = new GravatarGenerator();
        }
        return this.avatarGenerator;
    }
}

