/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.guice;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.NullTicketService;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ITicketServiceProvider
implements Provider<ITicketService> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IRuntimeManager runtimeManager;
    private volatile ITicketService service;

    @Inject
    public ITicketServiceProvider(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public synchronized ITicketService get() {
        if (this.service != null) {
            return this.service;
        }
        IStoredSettings settings = this.runtimeManager.getSettings();
        String clazz = settings.getString("tickets.service", NullTicketService.class.getName());
        if (StringUtils.isEmpty(clazz)) {
            clazz = NullTicketService.class.getName();
        }
        try {
            Class<?> serviceClass = Class.forName(clazz);
            this.service = (ITicketService)this.runtimeManager.getInjector().getInstance(serviceClass);
        }
        catch (Exception e) {
            this.logger.error("failed to create ticket service", (Throwable)e);
            this.service = (ITicketService)this.runtimeManager.getInjector().getInstance(NullTicketService.class);
        }
        return this.service;
    }
}

