/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.auth.AuthenticationProvider;
import com.gitblit.auth.HtpasswdAuthProvider;
import com.gitblit.auth.HttpHeaderAuthProvider;
import com.gitblit.auth.LdapAuthProvider;
import com.gitblit.auth.PAMAuthProvider;
import com.gitblit.auth.RedmineAuthProvider;
import com.gitblit.auth.SalesforceAuthProvider;
import com.gitblit.auth.WindowsAuthProvider;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.SshKey;
import com.gitblit.utils.Base64;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.PasswordHash;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.X509Utils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthenticationManager
implements IAuthenticationManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IStoredSettings settings;
    private final IRuntimeManager runtimeManager;
    private final IUserManager userManager;
    private final List<AuthenticationProvider> authenticationProviders;
    private final Map<String, Class<? extends AuthenticationProvider>> providerNames;
    private final Map<String, String> legacyRedirects;

    @Inject
    public AuthenticationManager(IRuntimeManager runtimeManager, IUserManager userManager) {
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.userManager = userManager;
        this.authenticationProviders = new ArrayList<AuthenticationProvider>();
        this.providerNames = new HashMap<String, Class<? extends AuthenticationProvider>>();
        this.providerNames.put("htpasswd", HtpasswdAuthProvider.class);
        this.providerNames.put("httpheader", HttpHeaderAuthProvider.class);
        this.providerNames.put("ldap", LdapAuthProvider.class);
        this.providerNames.put("pam", PAMAuthProvider.class);
        this.providerNames.put("redmine", RedmineAuthProvider.class);
        this.providerNames.put("salesforce", SalesforceAuthProvider.class);
        this.providerNames.put("windows", WindowsAuthProvider.class);
        this.legacyRedirects = new HashMap<String, String>();
        this.legacyRedirects.put("com.gitblit.HtpasswdUserService", "htpasswd");
        this.legacyRedirects.put("com.gitblit.LdapUserService", "ldap");
        this.legacyRedirects.put("com.gitblit.PAMUserService", "pam");
        this.legacyRedirects.put("com.gitblit.RedmineUserService", "redmine");
        this.legacyRedirects.put("com.gitblit.SalesforceUserService", "salesforce");
        this.legacyRedirects.put("com.gitblit.WindowsUserService", "windows");
    }

    @Override
    public AuthenticationManager start() {
        List<String> providers;
        String realm2 = this.settings.getString("realm.userService", "${baseFolder}/users.conf");
        if (this.legacyRedirects.containsKey(realm2)) {
            this.logger.warn("");
            this.logger.warn("#################################################################");
            this.logger.warn(" IUserService '{}' is obsolete!", (Object)realm2);
            this.logger.warn(" Please set '{}={}'", (Object)"realm.authenticationProviders", (Object)this.legacyRedirects.get(realm2));
            this.logger.warn("#################################################################");
            this.logger.warn("");
            if (StringUtils.isEmpty(this.settings.getString("realm.authenticationProviders", null))) {
                this.settings.overrideSetting("realm.authenticationProviders", this.legacyRedirects.get(realm2));
            }
        }
        if ((providers = this.settings.getStrings("realm.authenticationProviders")).isEmpty()) {
            this.logger.info("External authentication disabled.");
        } else {
            for (String provider : providers) {
                try {
                    Class<Object> authClass = this.providerNames.containsKey(provider) ? this.providerNames.get(provider) : Class.forName(provider);
                    this.logger.info("setting up {}", (Object)authClass.getName());
                    AuthenticationProvider authImpl = (AuthenticationProvider)authClass.newInstance();
                    authImpl.setup(this.runtimeManager, this.userManager);
                    this.authenticationProviders.add(authImpl);
                }
                catch (Exception e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        return this;
    }

    @Override
    public AuthenticationManager stop() {
        for (AuthenticationProvider provider : this.authenticationProviders) {
            try {
                provider.stop();
            }
            catch (Exception e) {
                this.logger.error("Failed to stop " + provider.getClass().getSimpleName(), (Throwable)e);
            }
        }
        return this;
    }

    public void addAuthenticationProvider(AuthenticationProvider prov) {
        this.authenticationProviders.add(prov);
    }

    @Override
    public UserModel authenticate(HttpServletRequest httpRequest) {
        return this.authenticate(httpRequest, false);
    }

    @Override
    public UserModel authenticate(HttpServletRequest httpRequest, boolean requiresCertificate) {
        char[] password;
        String username;
        String base64Credentials;
        String credentials;
        String[] values;
        String[] oids;
        boolean checkValidity;
        UserModel model;
        UserModel user;
        String username2;
        Principal principal;
        String reqAuthUser = (String)httpRequest.getAttribute("Gitblit:authenticated-user");
        if (!StringUtils.isEmpty(reqAuthUser)) {
            this.logger.debug("Called servlet authenticate when request is already authenticated.");
            return this.userManager.getUserModel(reqAuthUser);
        }
        if (!requiresCertificate && (principal = httpRequest.getUserPrincipal()) != null && !StringUtils.isEmpty(username2 = principal.getName())) {
            boolean internalAccount = this.userManager.isInternalAccount(username2);
            user = this.userManager.getUserModel(username2);
            if (user != null) {
                this.flagRequest(httpRequest, Constants.AuthenticationType.CONTAINER, user.username);
                this.logger.debug(MessageFormat.format("{0} authenticated by servlet container principal from {1}", user.username, httpRequest.getRemoteAddr()));
                return this.validateAuthentication(user, Constants.AuthenticationType.CONTAINER);
            }
            if (this.settings.getBoolean("realm.container.autoCreateAccounts", false) && !internalAccount) {
                String adminRole;
                String userLocale;
                String displayName;
                user = new UserModel(username2.toLowerCase());
                user.displayName = username2;
                user.password = "#externalAccount";
                user.accountType = Constants.AccountType.CONTAINER;
                HttpSession session = httpRequest.getSession();
                String emailAddress = this.resolveAttribute(session, "realm.container.autoAccounts.emailAddress");
                if (emailAddress != null) {
                    user.emailAddress = emailAddress;
                }
                if ((displayName = this.resolveAttribute(session, "realm.container.autoAccounts.displayName")) != null) {
                    user.displayName = displayName;
                }
                if ((userLocale = this.resolveAttribute(session, "realm.container.autoAccounts.locale")) != null) {
                    user.getPreferences().setLocale(userLocale);
                }
                if ((adminRole = this.settings.getString("realm.container.autoAccounts.adminRole", null)) != null && !adminRole.isEmpty() && httpRequest.isUserInRole(adminRole)) {
                    user.canAdmin = true;
                }
                this.userManager.updateUserModel(user);
                this.flagRequest(httpRequest, Constants.AuthenticationType.CONTAINER, user.username);
                this.logger.debug(MessageFormat.format("{0} authenticated and created by servlet container principal from {1}", user.username, httpRequest.getRemoteAddr()));
                return this.validateAuthentication(user, Constants.AuthenticationType.CONTAINER);
            }
            if (!internalAccount) {
                this.logger.warn(MessageFormat.format("Failed to find UserModel for {0}, attempted servlet container authentication from {1}", principal.getName(), httpRequest.getRemoteAddr()));
            }
        }
        if ((model = HttpUtils.getUserModelFromCertificate(httpRequest, checkValidity = this.settings.getBoolean("git.enforceCertificateValidity", true), oids = this.settings.getStrings("git.certificateUsernameOIDs").toArray(new String[0]))) != null) {
            user = this.userManager.getUserModel(model.username);
            X509Utils.X509Metadata metadata = HttpUtils.getCertificateMetadata(httpRequest);
            if (user != null) {
                this.flagRequest(httpRequest, Constants.AuthenticationType.CERTIFICATE, user.username);
                this.logger.debug(MessageFormat.format("{0} authenticated by client certificate {1} from {2}", user.username, metadata.serialNumber, httpRequest.getRemoteAddr()));
                return this.validateAuthentication(user, Constants.AuthenticationType.CERTIFICATE);
            }
            this.logger.warn(MessageFormat.format("Failed to find UserModel for {0}, attempted client certificate ({1}) authentication from {2}", model.username, metadata.serialNumber, httpRequest.getRemoteAddr()));
        }
        if (requiresCertificate) {
            return null;
        }
        user = null;
        String cookie = this.getCookie(httpRequest);
        if (!StringUtils.isEmpty(cookie) && (user = this.userManager.getUserModel(cookie.toCharArray())) != null) {
            this.flagRequest(httpRequest, Constants.AuthenticationType.COOKIE, user.username);
            this.logger.debug(MessageFormat.format("{0} authenticated by cookie from {1}", user.username, httpRequest.getRemoteAddr()));
            return this.validateAuthentication(user, Constants.AuthenticationType.COOKIE);
        }
        String authorization = httpRequest.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic") && (values = (credentials = new String(Base64.decode(base64Credentials = authorization.substring("Basic".length()).trim()), Charset.forName("UTF-8"))).split(":", 2)).length == 2 && (user = this.authenticate(username = values[0], password = values[1].toCharArray(), httpRequest.getRemoteAddr())) != null) {
            this.flagRequest(httpRequest, Constants.AuthenticationType.CREDENTIALS, user.username);
            this.logger.debug(MessageFormat.format("{0} authenticated by BASIC request header from {1}", user.username, httpRequest.getRemoteAddr()));
            return this.validateAuthentication(user, Constants.AuthenticationType.CREDENTIALS);
        }
        for (AuthenticationProvider ap : this.authenticationProviders) {
            UserModel authedUser = ap.authenticate(httpRequest);
            if (null == authedUser) continue;
            this.flagRequest(httpRequest, ap.getAuthenticationType(), authedUser.username);
            this.logger.debug(MessageFormat.format("{0} authenticated by {1} from {2} for {3}", authedUser.username, ap.getServiceName(), httpRequest.getRemoteAddr(), httpRequest.getPathInfo()));
            return this.validateAuthentication(authedUser, ap.getAuthenticationType());
        }
        return null;
    }

    private String resolveAttribute(HttpSession session, String attributeMapping) {
        String attributeName = this.settings.getString(attributeMapping, null);
        if (StringUtils.isEmpty(attributeName)) {
            return null;
        }
        Object attributeValue = session.getAttribute(attributeName);
        if (attributeValue == null) {
            return null;
        }
        String value = attributeValue.toString();
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    @Override
    public UserModel authenticate(String username, SshKey key) {
        if (username != null) {
            if (!StringUtils.isEmpty(username)) {
                UserModel user = this.userManager.getUserModel(username);
                if (user != null) {
                    this.logger.debug(MessageFormat.format("{0} authenticated by {1} public key", user.username, key.getAlgorithm()));
                    return this.validateAuthentication(user, Constants.AuthenticationType.PUBLIC_KEY);
                }
                this.logger.warn(MessageFormat.format("Failed to find UserModel for {0} during public key authentication", username));
            }
        } else {
            this.logger.warn("Empty user passed to AuthenticationManager.authenticate!");
        }
        return null;
    }

    @Override
    public UserModel authenticate(String username) {
        if (username != null) {
            if (!StringUtils.isEmpty(username)) {
                UserModel user = this.userManager.getUserModel(username);
                if (user != null) {
                    this.logger.debug(MessageFormat.format("{0} authenticated externally", user.username));
                    return this.validateAuthentication(user, Constants.AuthenticationType.CONTAINER);
                }
                this.logger.warn(MessageFormat.format("Failed to find UserModel for {0} during external authentication", username));
            }
        } else {
            this.logger.warn("Empty user passed to AuthenticationManager.authenticate!");
        }
        return null;
    }

    protected UserModel validateAuthentication(UserModel user, Constants.AuthenticationType type) {
        if (user == null) {
            return null;
        }
        if (user.disabled) {
            this.logger.warn("Rejected {} authentication attempt by disabled account \"{}\"", (Object)type, (Object)user.username);
            return null;
        }
        return user;
    }

    protected void flagRequest(HttpServletRequest httpRequest, Constants.AuthenticationType authenticationType, String authedUsername) {
        httpRequest.setAttribute("Gitblit:authenticated-user", (Object)authedUsername);
        httpRequest.setAttribute("Gitblit:authentication-type", (Object)authenticationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserModel authenticate(String username, char[] password, String remoteIP) {
        block11: {
            if (StringUtils.isEmpty(username)) {
                return null;
            }
            if (username.equalsIgnoreCase("$gitblit")) {
                return null;
            }
            String usernameDecoded = StringUtils.decodeUsername(username);
            if (StringUtils.isEmpty(password)) {
                return null;
            }
            UserModel user = this.userManager.getUserModel(usernameDecoded);
            try {
                if (user != null && user.isLocalAccount()) {
                    UserModel returnedUser = this.authenticateLocal(user, password);
                    if (returnedUser != null) {
                        UserModel userModel = returnedUser;
                        return userModel;
                    }
                    break block11;
                }
                for (AuthenticationProvider provider : this.authenticationProviders) {
                    UserModel returnedUser;
                    if (!(provider instanceof AuthenticationProvider.UsernamePasswordAuthenticationProvider) || (returnedUser = provider.authenticate(usernameDecoded, password)) == null) continue;
                    returnedUser.accountType = provider.getAccountType();
                    UserModel userModel = this.validateAuthentication(returnedUser, Constants.AuthenticationType.CREDENTIALS);
                    return userModel;
                }
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
        }
        this.logger.warn(MessageFormat.format("Failed login attempt for {0}, invalid credentials from {1}", username, remoteIP != null ? remoteIP : "unknown"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserModel authenticateLocal(UserModel user, char[] password) {
        UserModel returnedUser = null;
        char[] pwdToUpgrade = Arrays.copyOf(password, password.length);
        try {
            PasswordHash pwdHash = PasswordHash.instanceFor(user.password);
            if (pwdHash != null) {
                if (pwdHash.matches(user.password, password, user.username)) {
                    returnedUser = user;
                }
            } else if (user.password.equals(new String(password))) {
                returnedUser = user;
            }
            returnedUser = this.validateAuthentication(returnedUser, Constants.AuthenticationType.CREDENTIALS);
            this.upgradeStoredPassword(returnedUser, pwdToUpgrade, pwdHash);
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(pwdToUpgrade, '\u0000');
        }
        return returnedUser;
    }

    private void upgradeStoredPassword(UserModel user, char[] password, PasswordHash pwdHash) {
        if (user == null) {
            return;
        }
        String algorithm = this.settings.getString("realm.passwordStorage", PasswordHash.getDefaultType().name());
        if ((pwdHash == null || pwdHash.needsUpgradeTo(algorithm)) && (pwdHash = PasswordHash.instanceOf(algorithm)) != null) {
            user.password = pwdHash.toHashedEntry(password, user.username);
            this.userManager.updateUserModel(user);
        }
    }

    @Override
    public String getCookie(HttpServletRequest request) {
        Cookie[] cookies;
        if (this.settings.getBoolean("web.allowCookieAuthentication", true) && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("Gitblit")) continue;
                String value = cookie.getValue();
                return value;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void setCookie(HttpServletResponse response, UserModel user) {
        this.setCookie(null, response, user);
    }

    @Override
    public void setCookie(HttpServletRequest request, HttpServletResponse response, UserModel user) {
        if (this.settings.getBoolean("web.allowCookieAuthentication", true)) {
            Constants.AuthenticationType authenticationType;
            boolean standardLogin = true;
            if (null != request && null != (authenticationType = (Constants.AuthenticationType)((Object)request.getAttribute("Gitblit:authentication-type")))) {
                standardLogin = authenticationType.isStandard();
            }
            if (standardLogin) {
                Cookie userCookie;
                if (user == null) {
                    userCookie = new Cookie("Gitblit", "");
                } else {
                    String cookie = this.userManager.getCookie(user);
                    if (StringUtils.isEmpty(cookie)) {
                        userCookie = new Cookie("Gitblit", "");
                    } else {
                        userCookie = new Cookie("Gitblit", cookie);
                        userCookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(7L));
                        userCookie.setHttpOnly(true);
                        userCookie.setSecure(this.httpsOnly());
                    }
                }
                String path = "/";
                if (request != null && !StringUtils.isEmpty(request.getContextPath())) {
                    path = request.getContextPath();
                }
                userCookie.setPath(path);
                response.addCookie(userCookie);
            }
        }
    }

    private boolean httpsOnly() {
        int port = this.settings.getInteger("server.httpPort", 0);
        int tlsPort = this.settings.getInteger("server.httpsPort", 0);
        return port <= 0 && tlsPort > 0 || port > 0 && tlsPort > 0 && this.settings.getBoolean("server.redirectToHttpsPort", true);
    }

    @Override
    @Deprecated
    public void logout(HttpServletResponse response, UserModel user) {
        this.setCookie(null, response, null);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, UserModel user) {
        this.setCookie(request, response, null);
    }

    @Override
    public boolean supportsCredentialChanges(UserModel user) {
        return user != null && user.isLocalAccount() || this.findProvider(user).supportsCredentialChanges();
    }

    @Override
    public boolean supportsDisplayNameChanges(UserModel user) {
        return user != null && user.isLocalAccount() || this.findProvider(user).supportsDisplayNameChanges();
    }

    @Override
    public boolean supportsEmailAddressChanges(UserModel user) {
        return user != null && user.isLocalAccount() || this.findProvider(user).supportsEmailAddressChanges();
    }

    @Override
    public boolean supportsTeamMembershipChanges(UserModel user) {
        return user != null && user.isLocalAccount() || this.findProvider(user).supportsTeamMembershipChanges();
    }

    @Override
    public boolean supportsTeamMembershipChanges(TeamModel team) {
        return team != null && team.isLocalTeam() || this.findProvider(team).supportsTeamMembershipChanges();
    }

    @Override
    public boolean supportsRoleChanges(UserModel user, Constants.Role role) {
        return user != null && user.isLocalAccount() || this.findProvider(user).supportsRoleChanges(user, role);
    }

    @Override
    public boolean supportsRoleChanges(TeamModel team, Constants.Role role) {
        return team != null && team.isLocalTeam() || this.findProvider(team).supportsRoleChanges(team, role);
    }

    protected AuthenticationProvider findProvider(UserModel user) {
        for (AuthenticationProvider provider : this.authenticationProviders) {
            if (!provider.getAccountType().equals((Object)user.accountType)) continue;
            return provider;
        }
        return AuthenticationProvider.NULL_PROVIDER;
    }

    protected AuthenticationProvider findProvider(TeamModel team) {
        for (AuthenticationProvider provider : this.authenticationProviders) {
            if (!provider.getAccountType().equals((Object)team.accountType)) continue;
            return provider;
        }
        return AuthenticationProvider.NULL_PROVIDER;
    }
}

