/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IFilestoreManager;
import com.gitblit.manager.IManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.FilestoreModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JsonUtils;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilestoreManager
implements IFilestoreManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IRuntimeManager runtimeManager;
    private final IRepositoryManager repositoryManager;
    private final IStoredSettings settings;
    public static final int UNDEFINED_SIZE = -1;
    private static final String METAFILE = "filestore.json";
    private static final String METAFILE_TMP = "filestore.json.tmp";
    protected static final Type METAFILE_TYPE = new TypeToken<Collection<FilestoreModel>>(){}.getType();
    private Map<String, FilestoreModel> fileCache = new ConcurrentHashMap<String, FilestoreModel>();

    @Inject
    FilestoreManager(IRuntimeManager runtimeManager, IRepositoryManager repositoryManager) {
        this.runtimeManager = runtimeManager;
        this.repositoryManager = repositoryManager;
        this.settings = runtimeManager.getSettings();
    }

    @Override
    public IManager start() {
        File dir = this.getStorageFolder();
        dir.mkdirs();
        File metadata = new File(dir, METAFILE);
        if (metadata.exists()) {
            Collection items = null;
            Gson gson = FilestoreManager.gson(new ExclusionStrategy[0]);
            try (FileReader file = new FileReader(metadata);){
                items = (Collection)gson.fromJson((Reader)file, METAFILE_TYPE);
                file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (FilestoreModel model : items) {
                this.fileCache.put(model.oid, model);
            }
            this.logger.info("Loaded {} items from filestore metadata file", (Object)this.fileCache.size());
        } else {
            this.logger.info("No filestore metadata file found");
        }
        return this;
    }

    @Override
    public IManager stop() {
        return this;
    }

    @Override
    public boolean isValidOid(String oid) {
        return Pattern.matches("[a-fA-F0-9]{64}", oid);
    }

    @Override
    public FilestoreModel.Status addObject(String oid, long size, UserModel user, RepositoryModel repo) {
        if (!user.canPush(repo)) {
            if (user == UserModel.ANONYMOUS) {
                return FilestoreModel.Status.AuthenticationRequired;
            }
            return FilestoreModel.Status.Error_Unauthorized;
        }
        if (!this.isValidOid(oid)) {
            return FilestoreModel.Status.Error_Invalid_Oid;
        }
        if (this.fileCache.containsKey(oid)) {
            FilestoreModel item = this.fileCache.get(oid);
            if (!item.isInErrorState() && size != -1L && item.getSize() != size) {
                return FilestoreModel.Status.Error_Size_Mismatch;
            }
            item.addRepository(repo.name);
            if (item.isInErrorState()) {
                item.reset(user, size);
            }
        } else {
            if (size < 0L) {
                return FilestoreModel.Status.Error_Invalid_Size;
            }
            if (this.getMaxUploadSize() != -1L && size > this.getMaxUploadSize()) {
                return FilestoreModel.Status.Error_Exceeds_Size_Limit;
            }
            FilestoreModel model = new FilestoreModel(oid, size, user, repo.name);
            this.fileCache.put(oid, model);
            this.saveFilestoreModel(model);
        }
        return this.fileCache.get(oid).getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilestoreModel.Status uploadBlob(String oid, long size, UserModel user, RepositoryModel repo, InputStream streamIn) {
        File file;
        FilestoreModel model;
        block35: {
            FilestoreModel.Status state = this.addObject(oid, size, user, repo);
            if (state != FilestoreModel.Status.Upload_Pending) {
                return state;
            }
            model = this.fileCache.get(oid);
            if (!model.actionUpload(user)) {
                return FilestoreModel.Status.Upload_In_Progress;
            }
            long actualSize = 0L;
            file = this.getStoragePath(oid);
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                try (FileOutputStream streamOut = new FileOutputStream(file);){
                    actualSize = IOUtils.copyLarge((InputStream)streamIn, (OutputStream)streamOut);
                    streamOut.flush();
                    streamOut.close();
                    if (model.getSize() != actualSize) {
                        model.setStatus(FilestoreModel.Status.Error_Size_Mismatch, user);
                        this.logger.warn(MessageFormat.format("Failed to upload blob {0} due to size mismatch, expected {1} got {2}", oid, model.getSize(), actualSize));
                        break block35;
                    }
                    String actualOid = "";
                    try (FileInputStream fileForHash = new FileInputStream(file);){
                        actualOid = DigestUtils.sha256Hex((InputStream)fileForHash);
                        fileForHash.close();
                    }
                    if (oid.equalsIgnoreCase(actualOid)) {
                        model.setStatus(FilestoreModel.Status.Available, user);
                    } else {
                        model.setStatus(FilestoreModel.Status.Error_Hash_Mismatch, user);
                        this.logger.warn(MessageFormat.format("Failed to upload blob {0} due to hash mismatch, got {1}", oid, actualOid));
                    }
                }
            }
            catch (Exception e) {
                model.setStatus(FilestoreModel.Status.Error_Unknown, user);
                this.logger.warn(MessageFormat.format("Failed to upload blob {0}", oid), (Throwable)e);
            }
            finally {
                this.saveFilestoreModel(model);
            }
        }
        if (model.isInErrorState()) {
            file.delete();
            model.removeRepository(repo.name);
        }
        return model.getStatus();
    }

    private FilestoreModel.Status canGetObject(String oid, UserModel user, RepositoryModel repo) {
        if (!user.canView(repo)) {
            if (user == UserModel.ANONYMOUS) {
                return FilestoreModel.Status.AuthenticationRequired;
            }
            return FilestoreModel.Status.Error_Unauthorized;
        }
        if (!this.isValidOid(oid)) {
            return FilestoreModel.Status.Error_Invalid_Oid;
        }
        if (!this.fileCache.containsKey(oid)) {
            return FilestoreModel.Status.Unavailable;
        }
        FilestoreModel item = this.fileCache.get(oid);
        if (item.getStatus() == FilestoreModel.Status.Available) {
            return FilestoreModel.Status.Available;
        }
        return FilestoreModel.Status.Unavailable;
    }

    @Override
    public FilestoreModel getObject(String oid, UserModel user, RepositoryModel repo) {
        if (this.canGetObject(oid, user, repo) == FilestoreModel.Status.Available) {
            return this.fileCache.get(oid);
        }
        return null;
    }

    @Override
    public FilestoreModel.Status downloadBlob(String oid, UserModel user, RepositoryModel repo, OutputStream streamOut) {
        FilestoreModel.Status status = this.canGetObject(oid, user, repo);
        if (status != FilestoreModel.Status.Available) {
            return status;
        }
        FilestoreModel item = this.fileCache.get(oid);
        if (streamOut != null) {
            try (FileInputStream streamIn = new FileInputStream(this.getStoragePath(oid));){
                IOUtils.copyLarge((InputStream)streamIn, (OutputStream)streamOut);
                streamOut.flush();
                streamIn.close();
            }
            catch (EOFException e) {
                this.logger.error(MessageFormat.format("Client aborted connection for {0}", oid), (Throwable)e);
                return FilestoreModel.Status.Error_Unexpected_Stream_End;
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Failed to download blob {0}", oid), (Throwable)e);
                return FilestoreModel.Status.Error_Unknown;
            }
        }
        return item.getStatus();
    }

    @Override
    public List<FilestoreModel> getAllObjects(UserModel user) {
        List<RepositoryModel> viewableRepositories = this.repositoryManager.getRepositoryModels(user);
        ArrayList<String> viewableRepositoryNames = new ArrayList<String>(viewableRepositories.size());
        for (RepositoryModel repository : viewableRepositories) {
            viewableRepositoryNames.add(repository.name);
        }
        if (viewableRepositoryNames.size() == 0) {
            return null;
        }
        Collection<FilestoreModel> allFiles = this.fileCache.values();
        ArrayList<FilestoreModel> userViewableFiles = new ArrayList<FilestoreModel>(allFiles.size());
        for (FilestoreModel file : allFiles) {
            if (!file.isInRepositoryList(viewableRepositoryNames)) continue;
            userViewableFiles.add(file);
        }
        return userViewableFiles;
    }

    @Override
    public File getStorageFolder() {
        return this.runtimeManager.getFileOrFolder("filestore.storageFolder", "${baseFolder}/lfs");
    }

    @Override
    public File getStoragePath(String oid) {
        return new File(this.getStorageFolder(), oid.substring(0, 2).concat("/").concat(oid.substring(2)));
    }

    @Override
    public long getMaxUploadSize() {
        return this.settings.getLong("filestore.maxUploadSize", -1L);
    }

    @Override
    public long getFilestoreUsedByteCount() {
        Iterator<FilestoreModel> iterator = this.fileCache.values().iterator();
        long total = 0L;
        while (iterator.hasNext()) {
            FilestoreModel item = iterator.next();
            if (item.getStatus() != FilestoreModel.Status.Available) continue;
            total += item.getSize();
        }
        return total;
    }

    @Override
    public long getFilestoreAvailableByteCount() {
        try {
            return Files.getFileStore(this.getStorageFolder().toPath()).getUsableSpace();
        }
        catch (IOException e) {
            this.logger.error(MessageFormat.format("Failed to retrive available space in Filestore {0}", e));
            return -1L;
        }
    }

    private synchronized void saveFilestoreModel(FilestoreModel model) {
        File metaFile = new File(this.getStorageFolder(), METAFILE);
        File metaFileTmp = new File(this.getStorageFolder(), METAFILE_TMP);
        boolean isNewFile = false;
        try {
            if (!metaFile.exists()) {
                metaFile.getParentFile().mkdirs();
                metaFile.createNewFile();
                isNewFile = true;
            }
            FileUtils.copyFile((File)metaFile, (File)metaFileTmp);
        }
        catch (IOException e) {
            this.logger.error("Writing filestore model to file {0}, {1}", (Object)METAFILE, (Object)e);
        }
        try (RandomAccessFile fs = new RandomAccessFile(metaFileTmp, "rw");){
            if (isNewFile) {
                fs.writeBytes("[");
            } else {
                fs.seek(fs.length() - 1L);
                fs.writeBytes(",");
            }
            fs.writeBytes(FilestoreManager.gson(new ExclusionStrategy[0]).toJson((Object)model));
            fs.writeBytes("]");
            fs.close();
        }
        catch (IOException e) {
            this.logger.error("Writing filestore model to file {0}, {1}", (Object)METAFILE_TMP, (Object)e);
        }
        try {
            if (metaFileTmp.exists()) {
                FileUtils.copyFile((File)metaFileTmp, (File)metaFile);
                metaFileTmp.delete();
            } else {
                this.logger.error("Writing filestore model to file {0}", (Object)METAFILE);
            }
        }
        catch (IOException e) {
            this.logger.error("Writing filestore model to file {0}, {1}", (Object)METAFILE, (Object)e);
        }
    }

    @Override
    public void clearFilestoreCache() {
        this.fileCache.clear();
    }

    private static Gson gson(ExclusionStrategy ... strategies) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonUtils.GmtDateTypeAdapter());
        if (!ArrayUtils.isEmpty(strategies)) {
            builder.setExclusionStrategies(strategies);
        }
        return builder.create();
    }
}

