/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.GitBlitException;
import com.gitblit.manager.IManager;
import com.gitblit.models.ForkModel;
import com.gitblit.models.Metric;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SearchResult;
import com.gitblit.models.UserModel;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.Repository;

public interface IRepositoryManager
extends IManager {
    public File getRepositoriesFolder();

    public File getHooksFolder();

    public File getGrapesFolder();

    public Date getLastActivityDate();

    public List<RegistrantAccessPermission> getUserAccessPermissions(UserModel var1);

    public List<RegistrantAccessPermission> getUserAccessPermissions(RepositoryModel var1);

    public boolean setUserAccessPermissions(RepositoryModel var1, Collection<RegistrantAccessPermission> var2);

    public List<String> getRepositoryUsers(RepositoryModel var1);

    public List<RegistrantAccessPermission> getTeamAccessPermissions(RepositoryModel var1);

    public boolean setTeamAccessPermissions(RepositoryModel var1, Collection<RegistrantAccessPermission> var2);

    public List<String> getRepositoryTeams(RepositoryModel var1);

    public void addToCachedRepositoryList(RepositoryModel var1);

    public void resetRepositoryListCache();

    public void resetRepositoryCache(String var1);

    public List<String> getRepositoryList();

    public Repository getRepository(String var1);

    public Repository getRepository(String var1, boolean var2);

    public List<RepositoryModel> getRepositoryModels();

    public List<RepositoryModel> getRepositoryModels(UserModel var1);

    public RepositoryModel getRepositoryModel(UserModel var1, String var2);

    public RepositoryModel getRepositoryModel(String var1);

    public long getStarCount(RepositoryModel var1);

    public boolean hasRepository(String var1);

    public boolean hasRepository(String var1, boolean var2);

    public boolean hasFork(String var1, String var2);

    public String getFork(String var1, String var2);

    public ForkModel getForkNetwork(String var1);

    public long updateLastChangeFields(Repository var1, RepositoryModel var2);

    public List<Metric> getRepositoryDefaultMetrics(RepositoryModel var1, Repository var2);

    public void updateRepositoryModel(String var1, RepositoryModel var2, boolean var3) throws GitBlitException;

    public void updateConfiguration(Repository var1, RepositoryModel var2);

    public boolean canDelete(RepositoryModel var1);

    public boolean deleteRepositoryModel(RepositoryModel var1);

    public boolean deleteRepository(String var1);

    public List<String> getAllScripts();

    public List<String> getPreReceiveScriptsInherited(RepositoryModel var1);

    public List<String> getPreReceiveScriptsUnused(RepositoryModel var1);

    public List<String> getPostReceiveScriptsInherited(RepositoryModel var1);

    public List<String> getPostReceiveScriptsUnused(RepositoryModel var1);

    public List<SearchResult> search(String var1, int var2, int var3, List<String> var4);

    public boolean isCollectingGarbage();

    public boolean isCollectingGarbage(String var1);

    public void closeAll();

    public void close(String var1);

    public boolean isIdle(Repository var1);
}

