/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.ServerStatus;
import com.gitblit.models.SettingModel;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.XssFilter;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RuntimeManager
implements IRuntimeManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IStoredSettings settings;
    private final XssFilter xssFilter;
    private final ServerStatus serverStatus;
    private final ServerSettings settingsModel;
    private File baseFolder;
    private TimeZone timezone;
    @Inject
    private Injector injector;

    @Inject
    public RuntimeManager(IStoredSettings settings, XssFilter xssFilter) {
        this(settings, xssFilter, null);
    }

    public RuntimeManager(IStoredSettings settings, XssFilter xssFilter, File baseFolder) {
        this.settings = settings;
        this.settingsModel = new ServerSettings();
        this.serverStatus = new ServerStatus();
        this.xssFilter = xssFilter;
        this.baseFolder = baseFolder == null ? new File("") : baseFolder;
    }

    @Override
    public RuntimeManager start() {
        this.logger.info("Basefolder  : " + this.baseFolder.getAbsolutePath());
        this.logger.info("Settings    : " + this.settings.toString());
        this.logTimezone("JVM timezone: ", TimeZone.getDefault());
        this.logTimezone("App timezone: ", this.getTimezone());
        this.logger.info("JVM locale  : " + Locale.getDefault());
        this.logger.info("App locale  : " + (this.getLocale() == null ? "<client>" : this.getLocale()));
        return this;
    }

    @Override
    public RuntimeManager stop() {
        return this;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public File getBaseFolder() {
        return this.baseFolder;
    }

    @Override
    public void setBaseFolder(File folder) {
        this.baseFolder = folder;
    }

    @Override
    public Date getBootDate() {
        return this.serverStatus.bootDate;
    }

    @Override
    public ServerSettings getSettingsModel() {
        for (String key : this.settings.getAllKeys(null)) {
            SettingModel setting = this.settingsModel.get(key);
            if (setting == null) {
                setting = new SettingModel();
                setting.name = key;
                this.settingsModel.add(setting);
            }
            setting.currentValue = this.settings.getString(key, "");
        }
        return this.settingsModel;
    }

    @Override
    public TimeZone getTimezone() {
        if (this.timezone == null) {
            String tzid = this.settings.getString("web.timezone", null);
            if (StringUtils.isEmpty(tzid)) {
                this.timezone = TimeZone.getDefault();
                return this.timezone;
            }
            this.timezone = TimeZone.getTimeZone(tzid);
        }
        return this.timezone;
    }

    private void logTimezone(String type, TimeZone zone) {
        SimpleDateFormat df = new SimpleDateFormat("z Z");
        df.setTimeZone(zone);
        String offset = df.format(new Date());
        this.logger.info("{}{} ({})", new Object[]{type, zone.getID(), offset});
    }

    @Override
    public Locale getLocale() {
        String lc = this.settings.getString("web.forceDefaultLocale", null);
        if (!StringUtils.isEmpty(lc)) {
            int underscore = lc.indexOf(95);
            if (underscore > 0) {
                String lang = lc.substring(0, underscore);
                String cc = lc.substring(underscore + 1);
                return new Locale(lang, cc);
            }
            return new Locale(lc);
        }
        return null;
    }

    @Override
    public boolean isDebugMode() {
        return this.settings.getBoolean("web.debugMode", false);
    }

    @Override
    public File getFileOrFolder(String key, String defaultFileOrFolder) {
        String fileOrFolder = this.settings.getString(key, defaultFileOrFolder);
        return this.getFileOrFolder(fileOrFolder);
    }

    @Override
    public File getFileOrFolder(String fileOrFolder) {
        return FileUtils.resolveParameter("${baseFolder}", this.baseFolder, fileOrFolder);
    }

    @Override
    public IStoredSettings getSettings() {
        return this.settings;
    }

    @Override
    public boolean updateSettings(Map<String, String> updatedSettings) {
        return this.settings.saveSettings(updatedSettings);
    }

    @Override
    public ServerStatus getStatus() {
        this.serverStatus.heapAllocated = Runtime.getRuntime().totalMemory();
        this.serverStatus.heapFree = Runtime.getRuntime().freeMemory();
        return this.serverStatus;
    }

    @Override
    public XssFilter getXssFilter() {
        return this.xssFilter;
    }
}

