/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.manager;

import com.gitblit.ConfigUserService;
import com.gitblit.IStoredSettings;
import com.gitblit.IUserService;
import com.gitblit.extensions.UserTeamLifeCycleListener;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserManager
implements IUserManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IStoredSettings settings;
    private final IRuntimeManager runtimeManager;
    private final IPluginManager pluginManager;
    private final Map<String, String> legacyBackingServices;
    private IUserService userService;

    @Inject
    public UserManager(IRuntimeManager runtimeManager, IPluginManager pluginManager) {
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.pluginManager = pluginManager;
        this.legacyBackingServices = new HashMap<String, String>();
        this.legacyBackingServices.put("com.gitblit.HtpasswdUserService", "realm.htpasswd.backingUserService");
        this.legacyBackingServices.put("com.gitblit.LdapUserService", "realm.ldap.backingUserService");
        this.legacyBackingServices.put("com.gitblit.PAMUserService", "realm.pam.backingUserService");
        this.legacyBackingServices.put("com.gitblit.RedmineUserService", "realm.redmine.backingUserService");
        this.legacyBackingServices.put("com.gitblit.SalesforceUserService", "realm.salesforce.backingUserService");
        this.legacyBackingServices.put("com.gitblit.WindowsUserService", "realm.windows.backingUserService");
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
        this.userService.setup(this.runtimeManager);
        this.logger.info(userService.toString());
    }

    @Override
    public void setup(IRuntimeManager runtimeManager) {
    }

    @Override
    public UserManager start() {
        if (this.userService == null) {
            String realm2 = this.settings.getString("realm.userService", "${baseFolder}/users.conf");
            IUserService service = null;
            if (this.legacyBackingServices.containsKey(realm2)) {
                String realmKey = this.legacyBackingServices.get(realm2);
                this.logger.warn("");
                this.logger.warn("#################################################################");
                this.logger.warn(" Key '{}' is obsolete!", (Object)realmKey);
                this.logger.warn(" Please set '{}={}'", (Object)"realm.userService", (Object)this.settings.getString(realmKey, "${baseFolder}/users.conf"));
                this.logger.warn("#################################################################");
                this.logger.warn("");
                File realmFile = this.runtimeManager.getFileOrFolder(realmKey, "${baseFolder}/users.conf");
                service = this.createUserService(realmFile);
            } else {
                try {
                    Class<?> realmClass = Class.forName(realm2);
                    service = (IUserService)realmClass.newInstance();
                }
                catch (ClassNotFoundException t) {
                    File realmFile = this.runtimeManager.getFileOrFolder("realm.userService", "${baseFolder}/users.conf");
                    service = this.createUserService(realmFile);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.logger.error("failed to instantiate user service {}: {}. Trying once again with IRuntimeManager constructor", (Object)realm2, (Object)e.getMessage());
                    service = this.createIRuntimeManagerAwareUserService(realm2);
                }
            }
            this.setUserService(service);
        }
        return this;
    }

    private IUserService createIRuntimeManagerAwareUserService(String realm2) {
        try {
            Constructor<?> constructor = Class.forName(realm2).getConstructor(IRuntimeManager.class);
            return (IUserService)constructor.newInstance(this.runtimeManager);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("failed to instantiate user service {}: {}", (Object)realm2, (Object)e.getMessage());
            return null;
        }
    }

    protected IUserService createUserService(File realmFile) {
        ConfigUserService service = null;
        if (realmFile.getName().toLowerCase().endsWith(".conf")) {
            service = new ConfigUserService(realmFile);
        }
        assert (service != null);
        if (!realmFile.exists()) {
            try {
                realmFile.createNewFile();
            }
            catch (IOException x) {
                this.logger.error(MessageFormat.format("COULD NOT CREATE REALM FILE {0}!", realmFile), (Throwable)x);
            }
            UserModel admin = new UserModel("admin");
            admin.password = "admin";
            admin.canAdmin = true;
            admin.excludeFromFederation = true;
            service.updateUserModel(admin);
        }
        return service;
    }

    @Override
    public UserManager stop() {
        return this;
    }

    @Override
    public boolean isInternalAccount(String username) {
        return !StringUtils.isEmpty(username) && (username.equalsIgnoreCase("$gitblit") || username.equalsIgnoreCase(UserModel.ANONYMOUS.username));
    }

    @Override
    public String getCookie(UserModel model) {
        return this.userService.getCookie(model);
    }

    @Override
    public UserModel getUserModel(char[] cookie) {
        UserModel user = this.userService.getUserModel(cookie);
        return user;
    }

    @Override
    public UserModel getUserModel(String username) {
        if (StringUtils.isEmpty(username)) {
            return null;
        }
        String usernameDecoded = StringUtils.decodeUsername(username);
        UserModel user = this.userService.getUserModel(usernameDecoded);
        return user;
    }

    @Override
    public boolean updateUserModel(UserModel model) {
        boolean isCreate;
        boolean bl = isCreate = null == this.userService.getUserModel(model.username);
        if (this.userService.updateUserModel(model)) {
            if (isCreate) {
                this.callCreateUserListeners(model);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUserModels(Collection<UserModel> models) {
        return this.userService.updateUserModels(models);
    }

    @Override
    public boolean updateUserModel(String username, UserModel model) {
        boolean isCreate;
        boolean bl = isCreate = null == this.userService.getUserModel(username);
        if (this.userService.updateUserModel(username, model)) {
            if (isCreate) {
                this.callCreateUserListeners(model);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteUserModel(UserModel model) {
        if (this.userService.deleteUserModel(model)) {
            this.callDeleteUserListeners(model);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteUser(String username) {
        if (StringUtils.isEmpty(username)) {
            return false;
        }
        String usernameDecoded = StringUtils.decodeUsername(username);
        UserModel user = this.getUserModel(usernameDecoded);
        if (this.userService.deleteUser(usernameDecoded)) {
            this.callDeleteUserListeners(user);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAllUsernames() {
        ArrayList<String> names = new ArrayList<String>(this.userService.getAllUsernames());
        return names;
    }

    @Override
    public List<UserModel> getAllUsers() {
        List<UserModel> users = this.userService.getAllUsers();
        return users;
    }

    @Override
    public List<String> getAllTeamNames() {
        List<String> teams = this.userService.getAllTeamNames();
        return teams;
    }

    @Override
    public List<TeamModel> getAllTeams() {
        List<TeamModel> teams = this.userService.getAllTeams();
        return teams;
    }

    @Override
    public List<String> getTeamNamesForRepositoryRole(String role) {
        List<String> teams = this.userService.getTeamNamesForRepositoryRole(role);
        return teams;
    }

    @Override
    public TeamModel getTeamModel(String teamname) {
        TeamModel team = this.userService.getTeamModel(teamname);
        return team;
    }

    @Override
    public boolean updateTeamModel(TeamModel model) {
        boolean isCreate;
        boolean bl = isCreate = null == this.userService.getTeamModel(model.name);
        if (this.userService.updateTeamModel(model)) {
            if (isCreate) {
                this.callCreateTeamListeners(model);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean updateTeamModels(Collection<TeamModel> models) {
        return this.userService.updateTeamModels(models);
    }

    @Override
    public boolean updateTeamModel(String teamname, TeamModel model) {
        boolean isCreate;
        boolean bl = isCreate = null == this.userService.getTeamModel(teamname);
        if (this.userService.updateTeamModel(teamname, model)) {
            if (isCreate) {
                this.callCreateTeamListeners(model);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteTeamModel(TeamModel model) {
        if (this.userService.deleteTeamModel(model)) {
            this.callDeleteTeamListeners(model);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteTeam(String teamname) {
        TeamModel team = this.userService.getTeamModel(teamname);
        if (this.userService.deleteTeam(teamname)) {
            this.callDeleteTeamListeners(team);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getUsernamesForRepositoryRole(String role) {
        return this.userService.getUsernamesForRepositoryRole(role);
    }

    @Override
    public boolean renameRepositoryRole(String oldRole, String newRole) {
        return this.userService.renameRepositoryRole(oldRole, newRole);
    }

    @Override
    public boolean deleteRepositoryRole(String role) {
        return this.userService.deleteRepositoryRole(role);
    }

    protected void callCreateUserListeners(UserModel user) {
        if (this.pluginManager == null || user == null) {
            return;
        }
        for (UserTeamLifeCycleListener listener : this.pluginManager.getExtensions(UserTeamLifeCycleListener.class)) {
            try {
                listener.onCreation(user);
            }
            catch (Throwable t) {
                this.logger.error(String.format("failed to call plugin.onCreation%s", user.username), t);
            }
        }
    }

    protected void callCreateTeamListeners(TeamModel team) {
        if (this.pluginManager == null || team == null) {
            return;
        }
        for (UserTeamLifeCycleListener listener : this.pluginManager.getExtensions(UserTeamLifeCycleListener.class)) {
            try {
                listener.onCreation(team);
            }
            catch (Throwable t) {
                this.logger.error(String.format("failed to call plugin.onCreation %s", team.name), t);
            }
        }
    }

    protected void callDeleteUserListeners(UserModel user) {
        if (this.pluginManager == null || user == null) {
            return;
        }
        for (UserTeamLifeCycleListener listener : this.pluginManager.getExtensions(UserTeamLifeCycleListener.class)) {
            try {
                listener.onDeletion(user);
            }
            catch (Throwable t) {
                this.logger.error(String.format("failed to call plugin.onDeletion %s", user.username), t);
            }
        }
    }

    protected void callDeleteTeamListeners(TeamModel team) {
        if (this.pluginManager == null || team == null) {
            return;
        }
        for (UserTeamLifeCycleListener listener : this.pluginManager.getExtensions(UserTeamLifeCycleListener.class)) {
            try {
                listener.onDeletion(team);
            }
            catch (Throwable t) {
                this.logger.error(String.format("failed to call plugin.onDeletion %s", team.name), t);
            }
        }
    }
}

