/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.Metric;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.revwalk.RevCommit;

public class Activity
implements Serializable,
Comparable<Activity> {
    private static final long serialVersionUID = 1L;
    public final Date startDate;
    public final Date endDate;
    private final Set<RepositoryCommit> commits;
    private final Map<String, Metric> authorMetrics;
    private final Map<String, Metric> repositoryMetrics;
    private final Set<String> authorExclusions;

    public Activity(Date date) {
        this(date, 86399999L);
    }

    public Activity(Date date, long duration) {
        this.startDate = date;
        this.endDate = new Date(date.getTime() + duration);
        this.commits = new LinkedHashSet<RepositoryCommit>();
        this.authorMetrics = new HashMap<String, Metric>();
        this.repositoryMetrics = new HashMap<String, Metric>();
        this.authorExclusions = new TreeSet<String>();
    }

    public void excludeAuthors(Collection<String> authors) {
        for (String author : authors) {
            this.authorExclusions.add(author.toLowerCase());
        }
    }

    public RepositoryCommit addCommit(String repository, String branch, RevCommit commit) {
        RepositoryCommit commitModel = new RepositoryCommit(repository, branch, commit);
        return this.addCommit(commitModel);
    }

    public RepositoryCommit addCommit(RepositoryCommit commitModel) {
        if (this.commits.add(commitModel)) {
            String author = StringUtils.removeNewlines(commitModel.getAuthorIdent().getName());
            String authorName = author.toLowerCase();
            String authorEmail = StringUtils.removeNewlines(commitModel.getAuthorIdent().getEmailAddress()).toLowerCase();
            if (!this.repositoryMetrics.containsKey(commitModel.repository)) {
                this.repositoryMetrics.put(commitModel.repository, new Metric(commitModel.repository));
            }
            this.repositoryMetrics.get((Object)commitModel.repository).count += 1.0;
            if (!this.authorExclusions.contains(authorName) && !this.authorExclusions.contains(authorEmail)) {
                if (!this.authorMetrics.containsKey(author)) {
                    this.authorMetrics.put(author, new Metric(author));
                }
                this.authorMetrics.get((Object)author).count += 1.0;
            }
            return commitModel;
        }
        return null;
    }

    public int getCommitCount() {
        return this.commits.size();
    }

    public List<RepositoryCommit> getCommits() {
        ArrayList<RepositoryCommit> list = new ArrayList<RepositoryCommit>(this.commits);
        Collections.sort(list);
        return list;
    }

    public Map<String, Metric> getAuthorMetrics() {
        return this.authorMetrics;
    }

    public Map<String, Metric> getRepositoryMetrics() {
        return this.repositoryMetrics;
    }

    @Override
    public int compareTo(Activity o) {
        return o.startDate.compareTo(this.startDate);
    }
}

