/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RefLogEntry;
import com.gitblit.models.UserModel;
import java.io.Serializable;
import java.util.Date;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.ReceiveCommand;

public class DailyLogEntry
extends RefLogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;

    public DailyLogEntry(String repository, Date date) {
        super(repository, date, new UserModel("digest"));
    }

    public DailyLogEntry(String repository, Date date, UserModel user) {
        super(repository, date, user);
    }

    @Override
    public PersonIdent getCommitterIdent() {
        if (this.getAuthorCount() == 1) {
            return this.getCommits().get(0).getCommitterIdent();
        }
        return super.getCommitterIdent();
    }

    @Override
    public PersonIdent getAuthorIdent() {
        if (this.getAuthorCount() == 1) {
            return this.getCommits().get(0).getAuthorIdent();
        }
        return super.getAuthorIdent();
    }

    @Override
    public void updateRef(String ref, ReceiveCommand.Type type, String oldId, String newId) {
        String preservedNewId = this.getNewId(ref);
        if (preservedNewId == null) {
            preservedNewId = newId;
        }
        this.refUpdates.put(ref, type);
        this.refIdChanges.put(ref, oldId + "-" + preservedNewId);
    }
}

