/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;

public class GitClientApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    public String title;
    public String description;
    public String legal;
    public String icon;
    public String cloneUrl;
    public String command;
    public String productUrl;
    public String[] transports;
    public String[] platforms;
    public Constants.AccessPermission minimumPermission;
    public boolean isActive;

    public boolean allowsPlatform(String p) {
        if (ArrayUtils.isEmpty(this.platforms)) {
            return true;
        }
        if (StringUtils.isEmpty(p)) {
            return false;
        }
        String plc = p.toLowerCase();
        for (String platform : this.platforms) {
            if (!plc.contains(platform)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsTransport(String transportOrUrl) {
        if (ArrayUtils.isEmpty(this.transports)) {
            return true;
        }
        String scheme = transportOrUrl;
        if (transportOrUrl.indexOf(58) > -1) {
            scheme = transportOrUrl.substring(0, transportOrUrl.indexOf(58));
        }
        for (String transport : this.transports) {
            if (!transport.equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return StringUtils.isEmpty(this.title) ? this.name : this.title;
    }
}

