/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;

public class Menu {

    public static class ExternalLinkMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        private final String href;
        private final boolean newWindow;

        public ExternalLinkMenuItem(String displayText, String href) {
            this(displayText, href, false);
        }

        public ExternalLinkMenuItem(String displayText, String href, boolean newWindow) {
            super(displayText);
            this.href = href;
            this.newWindow = newWindow;
        }

        public String getHref() {
            return this.href;
        }

        public boolean openInNewWindow() {
            return this.newWindow;
        }
    }

    public static class PageLinkMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        private final Class<? extends WebPage> pageClass;
        private final PageParameters params;

        public PageLinkMenuItem(String displayText, Class<? extends WebPage> pageClass) {
            this(displayText, pageClass, null);
        }

        public PageLinkMenuItem(String displayText, Class<? extends WebPage> pageClass, PageParameters params) {
            super(displayText);
            this.pageClass = pageClass;
            this.params = params;
        }

        public Class<? extends WebPage> getPageClass() {
            return this.pageClass;
        }

        public PageParameters getPageParameters() {
            return this.params;
        }
    }

    public static class ToggleMenuItem
    extends ParameterMenuItem {
        private static final long serialVersionUID = 1L;

        public ToggleMenuItem(String displayText, String parameter, String value, PageParameters params) {
            super(displayText, parameter, value, params);
            if (this.isSelected) {
                this.parameters.remove((Object)parameter);
            }
        }
    }

    public static class ParameterMenuItem
    extends MenuItem {
        private static final long serialVersionUID = 1L;
        final PageParameters parameters;
        final String parameter;
        final String value;
        final boolean isSelected;

        public ParameterMenuItem(String displayText) {
            this(displayText, null, null, null);
        }

        public ParameterMenuItem(String displayText, String parameter, String value) {
            this(displayText, parameter, value, null);
        }

        public ParameterMenuItem(String displayText, String parameter, String value, PageParameters params) {
            super(displayText);
            this.parameter = parameter;
            this.value = value;
            if (params == null) {
                this.parameters = new PageParameters();
                this.setParameter(parameter, value);
                this.isSelected = false;
            } else {
                this.parameters = new PageParameters((Map)params);
                if (this.parameters.containsKey((Object)parameter)) {
                    this.isSelected = params.getString(parameter).equals(value);
                    this.setParameter(parameter, value);
                } else {
                    this.isSelected = false;
                    this.setParameter(parameter, value);
                }
            }
        }

        protected void setParameter(String parameter, String value) {
            if (!StringUtils.isEmpty(parameter)) {
                if (StringUtils.isEmpty(value)) {
                    this.parameters.remove((Object)parameter);
                } else {
                    this.parameters.put(parameter, (Object)value);
                }
            }
        }

        public String formatParameter() {
            if (StringUtils.isEmpty(this.parameter) || StringUtils.isEmpty(this.value)) {
                return "";
            }
            return this.parameter + "=" + this.value;
        }

        public PageParameters getPageParameters() {
            return this.parameters;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public int hashCode() {
            if (StringUtils.isEmpty(this.displayText)) {
                return this.value.hashCode() + this.parameter.hashCode();
            }
            return this.displayText.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MenuItem) {
                return this.hashCode() == o.hashCode();
            }
            return false;
        }

        @Override
        public String toString() {
            if (StringUtils.isEmpty(this.displayText)) {
                return this.formatParameter();
            }
            return this.displayText;
        }
    }

    public static class MenuDivider
    extends MenuItem {
        private static final long serialVersionUID = 1L;

        public MenuDivider() {
            super("");
        }
    }

    public static abstract class MenuItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String displayText;

        MenuItem(String displayText) {
            this.displayText = displayText;
        }

        public int hashCode() {
            return this.displayText.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MenuItem) {
                return this.hashCode() == o.hashCode();
            }
            return false;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

