/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.FilestoreModel;
import com.gitblit.utils.JGitUtils;
import java.io.Serializable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class PathModel
implements Serializable,
Comparable<PathModel> {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final String path;
    private final FilestoreModel filestoreItem;
    public final long size;
    public final int mode;
    public final String objectId;
    public final String commitId;
    public boolean isParentPath;

    public PathModel(String name, String path, FilestoreModel filestoreItem, long size, int mode, String objectId, String commitId) {
        this.name = name;
        this.path = path;
        this.filestoreItem = filestoreItem;
        this.size = filestoreItem == null ? size : filestoreItem.getSize();
        this.mode = mode;
        this.objectId = objectId;
        this.commitId = commitId;
    }

    public boolean isSymlink() {
        return FileMode.SYMLINK.equals(this.mode);
    }

    public boolean isSubmodule() {
        return FileMode.GITLINK.equals(this.mode);
    }

    public boolean isTree() {
        return FileMode.TREE.equals(this.mode);
    }

    public boolean isFile() {
        return FileMode.REGULAR_FILE.equals(this.mode) || FileMode.EXECUTABLE_FILE.equals(this.mode) || FileMode.MISSING.equals(this.mode) && !this.isSymlink() && !this.isSubmodule() && !this.isTree();
    }

    public boolean isFilestoreItem() {
        return this.filestoreItem != null;
    }

    public String getFilestoreOid() {
        if (this.filestoreItem != null) {
            return this.filestoreItem.oid;
        }
        return null;
    }

    public int hashCode() {
        return this.commitId.hashCode() + this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PathModel) {
            PathModel other = (PathModel)o;
            return this.path.equals(other.path);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(PathModel o) {
        boolean isTree = this.isTree();
        boolean otherTree = o.isTree();
        if (isTree && otherTree) {
            return this.path.compareTo(o.path);
        }
        if (!isTree && !otherTree) {
            if (this.isSubmodule() && o.isSubmodule()) {
                return this.path.compareTo(o.path);
            }
            if (this.isSubmodule()) {
                return -1;
            }
            if (o.isSubmodule()) {
                return 1;
            }
            return this.path.compareTo(o.path);
        }
        if (isTree && !otherTree) {
            return -1;
        }
        return 1;
    }

    public static class PathChangeModel
    extends PathModel {
        private static final long serialVersionUID = 1L;
        public DiffEntry.ChangeType changeType;
        public int insertions;
        public int deletions;

        public PathChangeModel(String name, String path, FilestoreModel filestoreItem, long size, int mode, String objectId, String commitId, DiffEntry.ChangeType type) {
            super(name, path, filestoreItem, size, mode, objectId, commitId);
            this.changeType = type;
        }

        public void update(char op) {
            switch (op) {
                case '+': {
                    ++this.insertions;
                    break;
                }
                case '-': {
                    ++this.deletions;
                    break;
                }
            }
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        public static PathChangeModel from(DiffEntry diff, String commitId, Repository repository) {
            FilestoreModel filestoreItem = null;
            long size = 0L;
            if (repository != null) {
                try (RevWalk revWalk = new RevWalk(repository);){
                    size = revWalk.getObjectReader().getObjectSize((AnyObjectId)diff.getNewId().toObjectId(), 3);
                    if (JGitUtils.isPossibleFilestoreItem(size)) {
                        filestoreItem = JGitUtils.getFilestoreItem(revWalk.getObjectReader().open((AnyObjectId)diff.getNewId().toObjectId()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PathChangeModel pcm = diff.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE) ? new PathChangeModel(diff.getOldPath(), diff.getOldPath(), filestoreItem, size, diff.getNewMode().getBits(), diff.getOldId().name(), commitId, diff.getChangeType()) : (diff.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME) ? new PathChangeModel(diff.getOldPath(), diff.getNewPath(), filestoreItem, size, diff.getNewMode().getBits(), diff.getNewId().name(), commitId, diff.getChangeType()) : new PathChangeModel(diff.getNewPath(), diff.getNewPath(), filestoreItem, size, diff.getNewMode().getBits(), diff.getNewId().name(), commitId, diff.getChangeType()));
            return pcm;
        }
    }
}

