/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.parboiled.common.StringUtils;
import ro.fortsoft.pf4j.Version;

public class PluginRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final List<PluginRegistration> registrations;

    public PluginRegistry(String name) {
        this.name = name;
        this.registrations = new CopyOnWriteArrayList<PluginRegistration>();
    }

    public void setup() {
        for (PluginRegistration reg : this.registrations) {
            reg.registry = this.name;
        }
    }

    public PluginRegistration lookup(String id) {
        for (PluginRegistration registration : this.registrations) {
            if (!registration.id.equalsIgnoreCase(id)) continue;
            return registration;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class PluginRelease
    implements Serializable,
    Comparable<PluginRelease> {
        private static final long serialVersionUID = 1L;
        public String version;
        public Date date;
        public String requires;
        public String url;

        @Override
        public int compareTo(PluginRelease o) {
            return Version.createVersion((String)this.version).compareTo(Version.createVersion((String)o.version));
        }
    }

    public static class PluginRegistration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String id;
        public String description;
        public String provider;
        public String projectUrl;
        public transient String installedRelease;
        public transient String registry;
        public List<PluginRelease> releases;

        public PluginRegistration(String id) {
            this.id = id;
            this.releases = new ArrayList<PluginRelease>();
        }

        public PluginRelease getCurrentRelease(Version system) {
            PluginRelease current = null;
            Date date = new Date(0L);
            for (PluginRelease pv : this.releases) {
                Version requires = Version.ZERO;
                if (!StringUtils.isEmpty((String)pv.requires)) {
                    requires = Version.createVersion((String)pv.requires);
                }
                if (!system.isZero() && !system.atLeast(requires) || !pv.date.after(date)) continue;
                current = pv;
                date = pv.date;
            }
            return current;
        }

        public PluginRelease getRelease(String version) {
            for (PluginRelease pv : this.releases) {
                if (!pv.version.equalsIgnoreCase(version)) continue;
                return pv;
            }
            return null;
        }

        public InstallState getInstallState(Version system) {
            if (StringUtils.isEmpty((String)this.installedRelease)) {
                return InstallState.NOT_INSTALLED;
            }
            Version ir = Version.createVersion((String)this.installedRelease);
            Version cr = Version.ZERO;
            PluginRelease curr = this.getCurrentRelease(system);
            if (curr != null) {
                cr = Version.createVersion((String)curr.version);
            }
            switch (ir.compareTo(cr)) {
                case -1: {
                    return InstallState.UNKNOWN;
                }
                case 1: {
                    return InstallState.UPDATE_AVAILABLE;
                }
            }
            return InstallState.INSTALLED;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum InstallState {
        NOT_INSTALLED,
        INSTALLED,
        UPDATE_AVAILABLE,
        UNKNOWN;

    }
}

